/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatus;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.SearchDependencyContainer;
import ro.amiq.vhdldt.ui.search.RfSearchQueryElement;
import ro.amiq.vhdldt.ui.search.new_engine.ForceHidOperatorVisitor;
import ro.amiq.vhdldt.ui.search.new_engine.ReferenceHidOperatorVisitor;
import ro.amiq.vhdldt.ui.search.new_engine.ReferenceHidSearchVisitor;
import ro.amiq.vhdldt.ui.search.new_engine.ReferenceImportExportHidOperatorVisitor;
import ro.amiq.vhdldt.ui.search.new_engine.ReferenceNamedElementVisitor;
import ro.amiq.vhdldt.ui.search.new_engine.ReportHidOperatorVisitor;

public class VHDLRfReferencesUtils
extends RfReferencesUtils {
    public static final Set<Class<? extends IRfNamedElement>> portClassSet = new HashSet<Class<? extends IRfNamedElement>>(1);
    public static final String NOT_SUPPORTED_RENAME_MESSAGE = "The operation is unavailable on the current selection (the scope could not be determined). Please select another VHDL Language element name or the same element from another location.";
    public static final String IS_PREDEFINED_ELEMENT_RENAME_MESSAGE = "The operation is not allowed on the current selection (the selected element is predefined). Please select another VHDL Language element.";

    static {
        portClassSet.add(RfPort.class);
    }

    public static IRfNamedElement getNamedElementOfDataType(RfNamedElement element, DataType dataType, int i, IRfNamedElement enclosing) {
        if (i == 0) {
            RfNamedElement enclosingScope = element.getEnclosingScope();
            if (enclosingScope == null || dataType.getFirstTypeName() == null) {
                return null;
            }
            return enclosingScope.semanticGetMember(dataType.getFirstTypeName(), null, null, enclosingScope, null, true, true, false);
        }
        if (dataType.getFirstTypeName() == null) {
            return null;
        }
        if (enclosing != null) {
            return enclosing.getMember(dataType.getFirstTypeName(), DVTRfUtils.MEMBERS_OTHERS, null, true, true, false, true, false);
        }
        return null;
    }

    public static Set<IRfNamedElement> getNonOverlappingScopes(Set<IRfNamedElement> allDependencies) {
        HashSet<IRfNamedElement> result = new HashSet<IRfNamedElement>();
        block0: for (IRfNamedElement dependency : allDependencies) {
            IRfScopeElement enclosingScope = dependency.getEnclosingScope();
            while (enclosingScope != null) {
                if (allDependencies.contains(enclosingScope) && !(enclosingScope instanceof RfLibrary) && !(enclosingScope instanceof RfEntity)) continue block0;
                enclosingScope = enclosingScope.getEnclosingScope();
            }
            result.add(dependency);
        }
        return result;
    }

    public static boolean isEqualsInUseClause(IRfNamedElement namedElement, IRfNamedElement usedElement) {
        return namedElement.checkEquals((Object)usedElement) || namedElement.checkEquals((Object)usedElement.getEnclosingScope()) || namedElement.checkEquals((Object)usedElement.getEnclosingLibrary());
    }

    private static List<IRfNamedElement> filterElements(List<RfNamedElement> allElements, Matcher matcher, String searchPackage, String[] searchStructs) {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        int i = 0;
        while (i < allElements.size()) {
            block10: {
                RfNamedElement element;
                block11: {
                    String enclosingName;
                    element = allElements.get(i);
                    if (element == null) break block10;
                    matcher.reset(element.getName());
                    if (!matcher.matches()) break block10;
                    if (searchPackage == null && searchStructs == null) break block11;
                    RfNamedElement enclosing = element;
                    if (searchStructs != null) {
                        String[] stringArray = searchStructs;
                        int n = searchStructs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String struct = stringArray[n2];
                            if ((enclosing = enclosing.getEnclosingScope()) != null) {
                                String enclosingName2;
                                String string = enclosingName2 = enclosing instanceof RfArchitecture ? ((RfArchitecture)enclosing).getEntityName() : enclosing.getName();
                                if (Pattern.matches(struct, enclosingName2)) {
                                    ++n2;
                                    continue;
                                }
                            }
                            break block10;
                        }
                    }
                    if (searchPackage == null) break block11;
                    if ((enclosing = enclosing.getEnclosingScope()) == null) break block10;
                    String string = enclosingName = enclosing instanceof RfArchitecture ? ((RfArchitecture)enclosing).getEntityName() : enclosing.getName();
                    if (!Pattern.matches(searchPackage, enclosingName)) break block10;
                }
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    public static boolean isChildOfScope(IRfNamedElement parentScope, IRfNamedElement childCandidateScope, String fieldName) {
        if (parentScope == null || childCandidateScope == null) {
            return false;
        }
        if (parentScope == childCandidateScope) {
            return true;
        }
        if (childCandidateScope.getLocalMember(portClassSet, fieldName, null) != null) {
            return false;
        }
        if (!(childCandidateScope.getEnclosingScope() instanceof IRfNamedElement)) {
            return false;
        }
        return VHDLRfReferencesUtils.isChildOfScope(parentScope, (IRfNamedElement)childCandidateScope.getEnclosingScope(), fieldName);
    }

    private static void searchForPredefinedElement(IReportHitsListener<SearchHit> listener, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, IRfNamedElement namedElement, ReferenceHidSearchVisitor hidVisitor, ReferenceHidOperatorVisitor hidOperatorVisitor, ReferenceImportExportHidOperatorVisitor hidImportExportVisitor, ReferenceNamedElementVisitor referenceNamedElementVisitor, RfProject rfProject, IProgressMonitor monitor) throws Exception {
        rfProject.visitHidObject(null, hidVisitor);
        rfProject.visitHidObject(null, hidOperatorVisitor);
        rfProject.visitHidObject(null, hidImportExportVisitor);
        rfProject.accept(referenceNamedElementVisitor);
        VHDLRfReferencesUtils.visitVhdlUsesConstructs(listener, documentManager, fileManager, namedElement, rfProject, monitor);
    }

    private static void searchForTypeElement(IReportHitsListener<SearchHit> listener, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, IRfNamedElement namedElement, ReferenceImportExportHidOperatorVisitor hidImportExportVisitor, ReferenceNamedElementVisitor referenceNamedElementVisitor, ReferenceHidSearchVisitor hidVisitor, RfProject rfProject, boolean includeDeclarations, IProgressMonitor monitor) throws Exception {
        rfProject.visitDirectMembersOfLibraries(referenceNamedElementVisitor);
        Set<IRfNamedElement> references = null;
        if (namedElement instanceof RfPackage) {
            references = VHDLRfReferencesUtils.getAllDependencies(namedElement, rfProject, false);
            RfPackageBody packageBody = ((RfPackage)namedElement).getPackageBody();
            if (references != null && packageBody != null) {
                references.add(packageBody);
            }
        } else {
            references = VHDLRfReferencesUtils.getAllDependencies(namedElement, rfProject, true);
        }
        if (references == null || references.isEmpty()) {
            return;
        }
        VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] Dependencies for type " + namedElement.getKindName() + " '" + namedElement.getName() + "' are: " + references));
        for (IRfNamedElement reference : references) {
            VHDLRfReferencesUtils.visitScope(reference, hidImportExportVisitor, referenceNamedElementVisitor, hidVisitor);
            if (!(reference instanceof RfNamedElement) || namedElement instanceof IRfLibraryElement) continue;
            VHDLRfReferencesUtils.visitUsesForReferenceElement(listener, documentManager, fileManager, (RfNamedElement)reference, namedElement, rfProject);
        }
        if (namedElement instanceof IRfLibraryElement) {
            VHDLRfReferencesUtils.visitVhdlUsesConstructs(listener, documentManager, fileManager, namedElement, rfProject, monitor);
        }
        if (includeDeclarations) {
            VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] Searching for declarations of " + namedElement.getKindName() + " '" + namedElement.getName() + "'"));
            VHDLRfReferencesUtils.searchForElementDeclarations(namedElement, referenceNamedElementVisitor);
        }
    }

    private static void visitVhdlUsesConstructs(final IReportHitsListener<SearchHit> listener, final DocumentManager documentManager, final FileSynchedAndAvailableManager fileManager, final IRfNamedElement namedElement, final RfProject rfProject, final IProgressMonitor monitor) {
        if (rfProject == null) {
            return;
        }
        rfProject.visitNamedElements(null, new IRfNamedElementVisitor(){
            private int fCheckMonitorCanceled;

            @Override
            public boolean visit(RfNamedElement element) {
                List<ImportInfo> referencesUses;
                if (!RfSearchUtils.isTypeElement((IRfNamedElement)element, (IProject)rfProject.getProject())) {
                    return true;
                }
                if (this.fCheckMonitorCanceled++ == 20) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException("Operation Canceled");
                    }
                    this.fCheckMonitorCanceled = 0;
                }
                if ((referencesUses = element.getReferencesUses(namedElement)) == null || referencesUses.isEmpty()) {
                    return true;
                }
                for (ImportInfo referenceUse : referencesUses) {
                    SearchHit searchHit;
                    try {
                        searchHit = VHDLRfReferencesUtils.addImportHit(documentManager, fileManager, referenceUse, namedElement, rfProject.getProject());
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return false;
                    }
                    if (searchHit == null) continue;
                    listener.addMatch((Object)searchHit);
                }
                return true;
            }
        });
    }

    private static void searchForElementDeclarations(IRfNamedElement namedElement, ReferenceNamedElementVisitor referenceNamedElementVisitor) {
        if (!(namedElement instanceof RfNamedElement)) {
            return;
        }
        referenceNamedElementVisitor.visit((RfNamedElement)namedElement);
    }

    private static void visitUsesForReferenceElement(IReportHitsListener<SearchHit> listener, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, RfNamedElement reference, IRfNamedElement namedElement, RfProject rfProject) throws Exception {
        IProject project = rfProject.getProject();
        if (project == null) {
            return;
        }
        List<ImportInfo> referencesUses = reference.getReferencesUses(namedElement);
        if (referencesUses.isEmpty()) {
            return;
        }
        for (ImportInfo referenceUse : referencesUses) {
            SearchHit searchHit = VHDLRfReferencesUtils.addImportHit(documentManager, fileManager, referenceUse, namedElement, project);
            if (searchHit == null) continue;
            listener.addMatch((Object)searchHit);
        }
    }

    private static List<IRfNamedElement> getElementsToSearch(RfProject rfProject, Pattern searchpattern, RfSearchQueryElement namedElement) {
        Matcher matcher = searchpattern.matcher("");
        String searchPackage = null;
        String[] searchStructs = null;
        String[] tempMatchPatterns = DVTStringUtil.split((Pattern)DVTStringUtil.BACKSLASH_DOT, (String)matcher.pattern().pattern());
        if (tempMatchPatterns.length == 1) {
            if ((tempMatchPatterns = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)tempMatchPatterns[0])).length == 2) {
                searchPackage = tempMatchPatterns[0];
                matcher = Pattern.compile(tempMatchPatterns[1], 2).matcher("");
            }
        } else if (tempMatchPatterns.length > 1) {
            int index = tempMatchPatterns[0].indexOf("::");
            if (tempMatchPatterns.length > 0 && index > 0) {
                searchPackage = tempMatchPatterns[0].substring(0, index);
                tempMatchPatterns[0] = tempMatchPatterns[0].substring(index + 2);
            }
            searchStructs = new String[tempMatchPatterns.length - 1];
            int i = 0;
            while (i < tempMatchPatterns.length - 1) {
                searchStructs[i] = tempMatchPatterns[tempMatchPatterns.length - 2 - i];
                ++i;
            }
            matcher = Pattern.compile(tempMatchPatterns[tempMatchPatterns.length - 1], 2).matcher("");
        }
        switch (namedElement.getType()) {
            case 0: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllTypes(false, false), matcher, searchPackage, searchStructs);
            }
            case 9: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllTypes(true, false), matcher, searchPackage, searchStructs);
            }
            case 1: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllFunctions(false), matcher, searchPackage, searchStructs);
            }
            case 5: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllFunctions(true), matcher, searchPackage, searchStructs);
            }
            case 2: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllVariables(32768), matcher, searchPackage, searchStructs);
            }
            case 7: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllVariables(16384), matcher, searchPackage, searchStructs);
            }
            case 3: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllComponents(), matcher, searchPackage, searchStructs);
            }
            case 4: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllPorts(), matcher, searchPackage, searchStructs);
            }
            case 6: {
                return VHDLRfReferencesUtils.filterElements(rfProject.getAllEntities(), matcher, searchPackage, searchStructs);
            }
        }
        return null;
    }

    public static void computeMatchesForSemanticSearch(IReportHitsListener<SearchHit> listener, Pattern searchPattern, IProject project, IRfNamedElement namedElement, IProgressMonitor monitor, Map<IProject, Set<ParserPath>> searchedFiles, FileSynchedAndAvailableManager fileManager, boolean includeDeclarations) throws Exception {
        try {
            IRfSingleLangProject rfSingleLangProject = RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vhdldt.VhdlNature", true);
            if (!(rfSingleLangProject instanceof RfProject) || !(namedElement instanceof RfSearchQueryElement)) {
                return;
            }
            RfProject rfProject = (RfProject)rfSingleLangProject;
            List<IRfNamedElement> elements = VHDLRfReferencesUtils.getElementsToSearch(rfProject, searchPattern, (RfSearchQueryElement)namedElement);
            if (elements == null || elements.isEmpty()) {
                return;
            }
            VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] Semantic search: Elements that match the search pattern '" + searchPattern + "' and the selected search type '" + ((RfSearchQueryElement)namedElement).getStringType() + "' are: " + elements));
            for (IRfNamedElement element : elements) {
                RfSearchUtils.computeReferences(listener, (IProject)project, (IRfNamedElement)element, null, (String)element.getName(), (IProgressMonitor)monitor, searchedFiles, (FileSynchedAndAvailableManager)fileManager, (boolean)includeDeclarations, (boolean)includeDeclarations, (boolean)false, (boolean)false, (boolean)false);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void computeMatchesForElement(IReportHitsListener<SearchHit> listener, DocumentManager documentManager, RfProject rfProject, IProject project, IProgressMonitor monitor, FileSynchedAndAvailableManager fileManager, boolean includeDeclarations, IRfNamedElement element, Map<Integer, List<SearchedElementWrapper>> searchedElementsRelativeDepthPairs, RenameAcrossHierarchyInfo renameWrapper, SearchedElementWrapper elementWrapper, boolean skipImplicitComponentEntityAssociation) throws Exception {
        IRfNamedElement enclosingScope;
        String operationType;
        if (element instanceof DummyElement) {
            if ("report_clauses".equals(element.getName())) {
                VHDLRfReferencesUtils.searchForReportMatches(listener, monitor, documentManager, fileManager, rfProject, project);
            } else if ("force_assignments".equals(element.getName())) {
                VHDLRfReferencesUtils.searchForForceMatches(listener, monitor, documentManager, fileManager, rfProject);
            }
            return;
        }
        ReferenceHidSearchVisitor hidVisitor = new ReferenceHidSearchVisitor(listener, element, project, documentManager, fileManager, monitor, elementWrapper, skipImplicitComponentEntityAssociation);
        ReferenceHidOperatorVisitor hidOperatorVisitor = new ReferenceHidOperatorVisitor(listener, monitor, fileManager, element, project, includeDeclarations, documentManager, searchedElementsRelativeDepthPairs, renameWrapper, elementWrapper, skipImplicitComponentEntityAssociation);
        ReferenceImportExportHidOperatorVisitor hidImportExportVisitor = new ReferenceImportExportHidOperatorVisitor(listener, monitor, fileManager, element, project, documentManager);
        ReferenceNamedElementVisitor namedElementVisitor = new ReferenceNamedElementVisitor(listener, monitor, fileManager, element, includeDeclarations, project, documentManager, elementWrapper, skipImplicitComponentEntityAssociation);
        String string = operationType = includeDeclarations ? "Refactoring" : "Searching";
        if (element.isPredefined()) {
            VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] " + operationType + " for predefined " + element.getKindName() + " '" + element.getName() + "'"));
            VHDLRfReferencesUtils.searchForPredefinedElement(listener, documentManager, fileManager, element, hidVisitor, hidOperatorVisitor, hidImportExportVisitor, namedElementVisitor, rfProject, monitor);
        } else if (RfSearchUtils.isTypeElement((IRfNamedElement)element, (IProject)project)) {
            VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] " + operationType + " for type " + element.getKindName() + " '" + element.getName() + "'"));
            VHDLRfReferencesUtils.searchForTypeElement(listener, documentManager, fileManager, element, hidImportExportVisitor, namedElementVisitor, hidVisitor, rfProject, includeDeclarations, monitor);
        } else {
            VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] " + operationType + " for non-type " + element.getKindName() + " '" + element.getName() + "'"));
            VHDLRfReferencesUtils.searchForNonTypeElement(element, hidVisitor, hidOperatorVisitor, namedElementVisitor, rfProject, includeDeclarations);
        }
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return;
        }
        if (!RfSearchUtils.isPortOrParameterElement((IRfNamedElement)element) && !(element instanceof IRfDesignElement)) {
            return;
        }
        Object object = enclosingScope = element instanceof IRfDesignElement ? element : element.getEnclosingScope();
        if (!(enclosingScope instanceof IRfDesignElement)) {
            return;
        }
        IRfDesignElement designElement = (IRfDesignElement)enclosingScope;
        List instancesFor = elManager.getMemory().getInstancesFor((IRfNamedElement)designElement, designElement.getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY, Integer.MAX_VALUE);
        if (instancesFor == null || instancesFor.isEmpty()) {
            return;
        }
        hidOperatorVisitor.setAssumeHitWhenSameNameAndType();
        namedElementVisitor.setAssumeHitWhenSameNameAndType();
        for (ELInstance elInstance : instancesFor) {
            Map parameterOverrides;
            List portConnections;
            IRfInstanceElement instanceElement;
            if (elInstance == null || !((instanceElement = elInstance.getDescription()) instanceof RfInstance) || instanceElement instanceof DummyInstance) continue;
            IRfConfiguration elaborationConfig = elInstance.getElaborationConfig();
            IRfConfigurationRule elaborationRule = elInstance.getElaborationRule();
            if ((elaborationConfig == null || elaborationConfig.isDummyConfig()) && elaborationRule == null || elaborationRule != null && (element instanceof IRfPortElement ? (portConnections = elaborationRule.getPortConnections(false, false)) != null && !portConnections.isEmpty() : RfSearchUtils.isParameterElement((IRfNamedElement)element) && (parameterOverrides = elaborationRule.getParameterOverrides(false)) != null && !parameterOverrides.isEmpty())) continue;
            instanceElement.visitHidObject(null, (IHidVisitor)hidOperatorVisitor);
            namedElementVisitor.visit((RfInstance)instanceElement);
        }
    }

    private static void searchForForceMatches(IReportHitsListener<SearchHit> listener, IProgressMonitor monitor, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, RfProject rfProject) {
        ForceHidOperatorVisitor forceHidOperatorVisitor = new ForceHidOperatorVisitor(monitor, documentManager, fileManager, listener, rfProject.getProject());
        rfProject.visitHidObject(null, forceHidOperatorVisitor);
    }

    private static void searchForReportMatches(IReportHitsListener<SearchHit> reportHitsListener, IProgressMonitor progressMonitor, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, RfProject rfProject, IProject project) {
        ReportHidOperatorVisitor forceHidOperatorVisitor = new ReportHidOperatorVisitor(progressMonitor, documentManager, fileManager, reportHitsListener, project);
        rfProject.visitHidObject(null, forceHidOperatorVisitor);
    }

    private static SearchHit addImportHit(DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, ImportInfo referenceUse, IRfNamedElement namedElement, IProject project) throws Exception {
        if (referenceUse == null || project == null || namedElement == null) {
            return null;
        }
        ParserPath path = referenceUse.getParserPath();
        if (path == null) {
            return null;
        }
        if (!fileManager.isSynchedFile(path, project)) {
            return null;
        }
        IDocument document = documentManager.getDocument(path, project);
        if (document == null) {
            return null;
        }
        int offset = VHDLRfReferencesUtils.findInUseClause(referenceUse, namedElement);
        if (offset == -1) {
            return null;
        }
        IRegion region = document.getLineInformationOfOffset(offset);
        String lineContents = document.get(region.getOffset(), region.getLength());
        int line = document.getLineOfOffset(offset) + 1;
        int lineOffset = document.getLineOffset(line - 1);
        String matchString = namedElement.getName();
        SearchHit searchElement = new SearchHit(path, line, offset, lineContents, matchString.length(), project);
        searchElement.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)project, (ParserPath)path, (int)line, (int)offset, (boolean)false));
        int counter = -1;
        try {
            counter = VHDLRfReferencesUtils.countStartWS((String)lineContents);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (counter >= 0) {
            searchElement.setSearchedElement(matchString, offset - lineOffset - counter, false);
        }
        return searchElement;
    }

    private static int findInUseClause(ImportInfo importInfo, IRfNamedElement namedElement) {
        if (namedElement == null) {
            return -1;
        }
        String name = namedElement.getName();
        if (name == null) {
            return -1;
        }
        IRfNamedElement usedElement = importInfo.getElement();
        if (usedElement == null) {
            return -1;
        }
        String explicitName = importInfo.getExplicitName();
        if (explicitName != null && name.equalsIgnoreCase(explicitName) && namedElement.checkEquals((Object)usedElement)) {
            return importInfo.getOffset();
        }
        List<DataTypeChunk> useClauseList = importInfo.getUseClauseList();
        if (useClauseList == null || useClauseList.isEmpty()) {
            return -1;
        }
        for (DataTypeChunk useClauseDataTypeChunk : useClauseList) {
            if (useClauseDataTypeChunk == null || useClauseDataTypeChunk.name == null || !name.equalsIgnoreCase(useClauseDataTypeChunk.name) || !VHDLRfReferencesUtils.isEqualsInUseClause(namedElement, usedElement)) continue;
            return useClauseDataTypeChunk.offset;
        }
        return -1;
    }

    public static Set<IRfNamedElement> getAllDependencies(IRfNamedElement element, RfProject rfProject, boolean searchForType) {
        Set<IRfNamedElement> result = SearchDependencyContainer.getAllDependencies(element, rfProject, searchForType);
        ArrayList<IRfNamedElement> dependencyList = new ArrayList<IRfNamedElement>(result);
        Collections.sort(dependencyList, new Comparator<IRfNamedElement>(){

            @Override
            public int compare(IRfNamedElement element1, IRfNamedElement element2) {
                if (element1 == null) {
                    return -1;
                }
                if (element2 == null) {
                    return 1;
                }
                IResource element1FileAdapter = element1.getFileAdapter();
                IResource element2FileAdapter = element2.getFileAdapter();
                if (element1FileAdapter == null) {
                    return 1;
                }
                if (element2FileAdapter == null) {
                    return -1;
                }
                return element1FileAdapter.getLocation().toOSString().compareTo(element2FileAdapter.getLocation().toOSString());
            }
        });
        LinkedHashSet<IRfNamedElement> sortedResult = new LinkedHashSet<IRfNamedElement>();
        sortedResult.addAll(dependencyList);
        return sortedResult;
    }

    private static void searchForNonTypeElement(IRfNamedElement namedElement, ReferenceHidSearchVisitor hidVisitor, ReferenceHidOperatorVisitor hidOperatorVisitor, ReferenceNamedElementVisitor namedElementVisitor, RfProject rfProject, boolean includeDeclarations) {
        Set<IRfNamedElement> referencedScopes = VHDLRfReferencesUtils.getAllDependencies(namedElement, rfProject, false);
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        if (enclosingScope instanceof RfEntity) {
            List<RfArchitecture> architectures = ((RfEntity)enclosingScope).getArchitectures();
            if (architectures != null) {
                referencedScopes.addAll(architectures);
            }
            referencedScopes.add(((RfEntity)enclosingScope).getEnclosingScope());
        } else if (enclosingScope instanceof RfPackageBody) {
            referencedScopes.add(((RfPackageBody)enclosingScope).getPackage());
        }
        referencedScopes = VHDLRfReferencesUtils.getNonOverlappingScopes(referencedScopes);
        if (namedElement instanceof RfNamedElement) {
            referencedScopes.add(((RfNamedElement)namedElement).getEnclosingScope());
        }
        VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] Dependencies for non-type " + namedElement.getKindName() + " '" + namedElement.getName() + "' are: " + referencedScopes));
        for (IRfNamedElement reference : referencedScopes) {
            if (!(reference instanceof RfNamedElement)) continue;
            reference.visitHidObject(null, (IHidVisitor)hidOperatorVisitor);
            reference.visitHidObject(null, (IHidVisitor)hidVisitor);
            try {
                hidVisitor.reportFromBuffer();
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (!(reference instanceof RfNamedElement)) continue;
            ((RfNamedElement)reference).visitNamedElements(null, namedElementVisitor);
        }
        if (includeDeclarations) {
            VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE: VHDLDT] Searching for declarations of " + namedElement.getKindName() + " '" + namedElement.getName() + "'"));
            VHDLRfReferencesUtils.searchForElementDeclarations(namedElement, namedElementVisitor);
        }
    }

    private static void visitScope(IRfNamedElement reference, ReferenceImportExportHidOperatorVisitor hidImportExportVisitor, ReferenceNamedElementVisitor namedElementVisitor, ReferenceHidSearchVisitor hidVisitor) {
        if (!(reference instanceof RfNamedElement)) {
            return;
        }
        reference.visitHidObject(null, (IHidVisitor)hidVisitor);
        try {
            hidVisitor.reportFromBuffer();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        reference.visitHidObject(null, (IHidVisitor)hidImportExportVisitor);
        ((RfNamedElement)reference).visitNamedElements(null, namedElementVisitor);
    }

    public static IStatus checkOtherElements(String newName, IRfNamedElement namedElement, IRfNamedElement enclosingScope) {
        List<RfProcess> processesWithPrefix;
        List<RfBlock> blocksWithPrefix;
        List<RfNamedElement> variablesWithPrefix;
        List<RfAssociatedType> packagesWithPrefix;
        List<RfFunction> functionsWithPrefix;
        List<RfInstance> instancesWithPrefix;
        List<RfArchitecture> architecturesWithPrefix;
        List<RfComponent> componentsWithPrefix;
        List<RfEntity> entitiesWithPrefix;
        List<RfVariable> signalsWithPrefix;
        List<RfPort> portsWithPrefix;
        if (!(enclosingScope instanceof IRfScope)) {
            return Status.OK_STATUS;
        }
        IRfScope scope = (IRfScope)enclosingScope;
        if (namedElement instanceof RfPort && (portsWithPrefix = scope.getPortsWithPrefix(newName, 1, true)) != null && !portsWithPrefix.isEmpty()) {
            NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a port"));
            status.setConflicting(portsWithPrefix);
            return status;
        }
        if (namedElement instanceof RfVariable && ((RfVariable)namedElement).isSignal() && (signalsWithPrefix = scope.getVariablesWithPrefix(newName, 1, true)) != null && !signalsWithPrefix.isEmpty()) {
            NameConflictStatus status = new NameConflictStatus(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a signal"));
            status.setConflicting(signalsWithPrefix);
            return status;
        }
        if (namedElement instanceof RfEntity && (entitiesWithPrefix = scope.getEntitiesWithPrefix(newName, 1)) != null && !entitiesWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "an entity"));
        }
        if (namedElement instanceof RfComponent && (componentsWithPrefix = scope.getComponentsWithPrefix(newName, 1, true)) != null && !componentsWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a component"));
        }
        if (namedElement instanceof RfArchitecture && (architecturesWithPrefix = scope.getArchitecturesWithPrefix(newName, 1)) != null && !architecturesWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "an architecture"));
        }
        if (namedElement instanceof RfInstance && (instancesWithPrefix = scope.getInstancesWithPrefix(newName, 1, true)) != null && !instancesWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "an instance"));
        }
        if (namedElement instanceof RfFunction && (functionsWithPrefix = scope.getFunctionsWithPrefix(newName, 1, true)) != null && !functionsWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a function"));
        }
        if (namedElement instanceof RfPackage && (packagesWithPrefix = scope.getPackagesWithPrefix(newName, 1)) != null && !packagesWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a package"));
        }
        if (namedElement instanceof RfPackageBody && (packagesWithPrefix = scope.getPackageBodiesWithPrefix(newName, 1)) != null && !packagesWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a package body"));
        }
        if (namedElement instanceof RfVariable && (variablesWithPrefix = scope.getVariablesWithPrefix(newName, 1, true)) != null && !variablesWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a variable"));
        }
        if (namedElement instanceof RfType && (variablesWithPrefix = scope.getTypesWithPrefix(newName, 1, true)) != null && !variablesWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a type"));
        }
        if (namedElement instanceof RfBlock && (blocksWithPrefix = scope.getBlocksWithPrefix(newName, 1, true)) != null && !blocksWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a block"));
        }
        if (namedElement instanceof RfProcess && (processesWithPrefix = scope.getProcessesWithPrefix(newName, 1)) != null && !processesWithPrefix.isEmpty()) {
            return new Status(4, "ro.amiq.vhdldt", MessageFormat.format("There is already {0} with this name.", "a process"));
        }
        return Status.OK_STATUS;
    }

    public static boolean isSemanticSearch(IRfNamedElement namedElement) {
        return namedElement instanceof RfSearchQueryElement;
    }
}

