/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.VhdlLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.VhdlLanguageElement;
import ro.amiq.vhdldt.parser.VhdlFileInstance;

public class CompileOrderViewLabelProvider
extends VhdlLabelProvider {
    public Image getImage(Object object) {
        if (!(object instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Object rfElement = ((RfTreeElementWrapper)((Object)object)).getRfElement();
        if (rfElement instanceof VhdlLanguageElement) {
            return DVTImages.imageCache.getImage(DVTImages.VHDL_LANGUAGE);
        }
        if (!(rfElement instanceof VhdlFileInstance)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        VhdlFileInstance instance = (VhdlFileInstance)rfElement;
        IFile file = RfUtils.getFile(instance, ((RfTreeElementWrapper)((Object)object)).getProject());
        Image result = null;
        result = file != null ? DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE) : DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE_GRAY);
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, object);
        }
        return result;
    }

    public String getText(Object object) {
        String result = this.internalGetText(object);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String internalGetText(Object object) {
        Object rfElement;
        if (!(object instanceof RfTreeElementWrapper)) {
            return null;
        }
        RfTreeElementWrapper treeElementWrapper = (RfTreeElementWrapper)((Object)object);
        if (treeElementWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null) {
            this.setBoldFont(treeElementWrapper);
        }
        if ((rfElement = treeElementWrapper.getRfElement()) instanceof VhdlLanguageElement) {
            return (String)((VhdlLanguageElement)((Object)rfElement)).getInfo();
        }
        if (rfElement instanceof String) {
            return rfElement.toString();
        }
        if (rfElement instanceof RfNamedElement) {
            return ((RfNamedElement)rfElement).getName();
        }
        if (!(rfElement instanceof VhdlFileInstance)) {
            return null;
        }
        VhdlFileInstance fileInstance = (VhdlFileInstance)rfElement;
        int index = fileInstance.getIndex();
        if (index <= 0) {
            return fileInstance.getShortFileName();
        }
        return String.valueOf(fileInstance.getShortFileName()) + " [" + index + "]";
    }
}

