/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vhdldt.model.reflection.util.RfNameTypeScopeHelper;

public class DHHistoryItem
extends HistoryItem {
    String elementName;
    String projectName;
    private List<? extends DVTRfNameTypeScopeHelper> elementScope;
    private HistoryItemType historyItemType;
    @Deprecated
    int elementType;

    public DHHistoryItem(String label, String projectName, String elementName, List<? extends DVTRfNameTypeScopeHelper> elementScope, HistoryItemType historyItemType) {
        super(label);
        this.projectName = projectName;
        this.elementName = elementName;
        this.elementScope = elementScope;
        this.historyItemType = historyItemType;
    }

    public boolean equals(Object hi) {
        if (hi instanceof DHHistoryItem) {
            boolean firstPart;
            DHHistoryItem lhi = (DHHistoryItem)((Object)hi);
            boolean bl = firstPart = this.projectName.equals(lhi.projectName) && this.elementName.equals(lhi.elementName);
            if (!firstPart) {
                return false;
            }
            String currentScope = this.toString();
            String nextScope = this.toString(lhi.elementScope);
            return currentScope.equals(nextScope);
        }
        return false;
    }

    public String toString(List<? extends DVTRfNameTypeScopeHelper> elementSc) {
        StringBuilder result = new StringBuilder();
        int size = elementSc.size();
        String name = elementSc.get(size - 1).getElementName();
        int i = 0;
        while (i < elementSc.size()) {
            DVTRfNameTypeScopeHelper scopeSegment = elementSc.get(i);
            result.append(String.valueOf(scopeSegment.getElementKind()) + "'" + scopeSegment.getElementName()).append(":");
            if (scopeSegment instanceof RfNameTypeScopeHelper && scopeSegment.getElementKind() == 2 && i == size - 1) {
                String architectureName = ((RfNameTypeScopeHelper)scopeSegment).getElementArchitectureName();
                result.append("256'" + architectureName).append(":");
                name = architectureName;
            }
            ++i;
        }
        result.append(name);
        return result.toString();
    }

    public int hashCode() {
        return super.hashCode() + this.elementName.hashCode() + this.projectName.hashCode() + this.elementScope.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.elementScope.size()) {
            String architectureName;
            DVTRfNameTypeScopeHelper scopeSegment = this.elementScope.get(i);
            result.append(String.valueOf(scopeSegment.getElementKind()) + "'" + scopeSegment.getElementName()).append(":");
            if (scopeSegment instanceof RfNameTypeScopeHelper && scopeSegment.getElementKind() == 2 && i == this.elementScope.size() - 1 && (architectureName = ((RfNameTypeScopeHelper)scopeSegment).getElementArchitectureName()) != null) {
                result.append("256'" + architectureName).append(":");
                this.elementName = architectureName;
            }
            ++i;
        }
        result.append(this.elementName);
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoryItem parseHistoryItem(String projectName, String top, boolean isElab, HistoryItemType historyItemType) {
        try {
            ArrayList<String> pieces = new ArrayList<String>(Arrays.asList(top.split("\\:")));
            if (pieces.size() < 2) {
                return null;
            }
            String elementName = (String)pieces.remove(pieces.size() - 1);
            ArrayList<RfNameTypeScopeHelper> scopeHelpers = new ArrayList<RfNameTypeScopeHelper>();
            Iterator iterator = pieces.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    int len = pieces.size();
                    String[] lastSegmentTypeAndName = ((String)pieces.get(len - 1)).split("'");
                    int lastSegmentType = Integer.parseInt(lastSegmentTypeAndName[0]);
                    String fullName = elementName;
                    if (lastSegmentType == 256) {
                        String[] archPieces = ((String)pieces.get(2)).split("'");
                        String[] entityPieces = ((String)pieces.get(1)).split("'");
                        fullName = String.valueOf(archPieces[1]) + " of " + entityPieces[1];
                    }
                    String label = "[" + projectName + "] " + fullName;
                    return new DHHistoryItem(label, projectName, elementName, scopeHelpers, historyItemType);
                }
                String piece = (String)iterator.next();
                String[] scopePieces = piece.split("'");
                if (scopePieces.length != 2) {
                    return null;
                }
                scopeHelpers.add(new RfNameTypeScopeHelper(Integer.parseInt(scopePieces[0]), scopePieces[1]));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public LanguageKind getLanguage() {
        return LanguageKind.VHDL;
    }

    public IProject getProject() {
        if (this.projectName == null) {
            return null;
        }
        return Utils.getProject((String)this.projectName);
    }

    public List<? extends DVTRfNameTypeScopeHelper> getElementScope() {
        return this.elementScope;
    }

    public HistoryItemType getHistoryItemType() {
        return this.historyItemType;
    }
}

