/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;

public class PortConnectionsHidOperatorVisitor
implements IHidVisitor<RfHidOperator> {
    private IRfNamedElement fRfElement;
    private boolean hasPortConnections;

    public PortConnectionsHidOperatorVisitor(IRfNamedElement element) {
        this.fRfElement = element;
        this.hasPortConnections = false;
    }

    public boolean visit(RfHidOperator hidOperator) {
        if (!hidOperator.isAssociation()) {
            return true;
        }
        boolean isPortConnection = hidOperator.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION.value());
        if (!isPortConnection) {
            return true;
        }
        IHidObject lhHidObject = hidOperator.getLHValue();
        if (this.checkHidObject(lhHidObject)) {
            return false;
        }
        ListContainer rhHidObjects = hidOperator.getRHValues();
        if (rhHidObjects == null || rhHidObjects.isEmpty()) {
            return true;
        }
        for (IHidObject rhValue : rhHidObjects) {
            if (!this.checkHidObject(rhValue)) continue;
            return false;
        }
        return true;
    }

    public boolean checkHidObject(IHidObject hidObject) {
        if (HidUtils.isHid((IHidObject)hidObject)) {
            IRfNamedElement hidElement = ((RfHid)hidObject).getElement();
            boolean isMatch = this.fRfElement.checkEquals((Object)hidElement);
            if (isMatch) {
                this.hasPortConnections = true;
                return true;
            }
            Hid parentHid = ((RfHid)hidObject).getParentHid();
            while (parentHid != null && parentHid.getParentHid() != null && parentHid.getParentHid().getParentHid() != null) {
                parentHid = parentHid.getParentHid();
            }
            if (parentHid != null && (isMatch = this.fRfElement.checkEquals((Object)(hidElement = parentHid.getElement())))) {
                this.hasPortConnections = true;
                return true;
            }
        } else if (HidUtils.isHidAccess((IHidObject)hidObject)) {
            RfHidAccess access = (RfHidAccess)hidObject;
            IRfNamedElement associatedType = access.getAssociatedType();
            if (associatedType instanceof RfFunctionsHolder) {
                List selects = access.getSelects();
                if (selects == null || selects.isEmpty()) {
                    return false;
                }
                for (IHidObject select : selects) {
                    if (!this.checkHidObject(select)) continue;
                    return true;
                }
            } else {
                Hid parentHid = access.getParentHid();
                while (parentHid != null && parentHid.getParentHid() != null && parentHid.getParentHid().getParentHid() != null) {
                    parentHid = parentHid.getParentHid();
                }
                if (parentHid == null) {
                    return false;
                }
                if (this.checkHidObject((IHidObject)parentHid)) {
                    return true;
                }
            }
        }
        return false;
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public boolean hasPortConnections() {
        return this.hasPortConnections;
    }
}

