/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.Comparator;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.ui.editor.outline.CategorySortingAction;
import ro.amiq.vhdldt.ui.editor.outline.IUpdateElement;

public class QuickViewCategorySortingAction
extends CategorySortingAction {
    private Comparator<IDVTElementWrapper> fComparator;
    private IUpdateElement fAtic;

    public QuickViewCategorySortingAction(IUpdateElement atic) {
        this.fAtic = atic;
        boolean disabled = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
        this.setEnabled(!disabled);
        if (!disabled) {
            boolean checked = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
            super.valueChanged(checked);
        }
    }

    @Override
    protected void valueChanged(boolean on) {
        super.valueChanged(on);
        this.fAtic.update(true);
    }

    public Comparator<IDVTElementWrapper> getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new Comparator<IDVTElementWrapper>(){

                public int category(Object obj) {
                    if (obj instanceof RfTreeElementWrapper) {
                        Object elem = ((RfTreeElementWrapper)((Object)obj)).getRfElement();
                        if (elem instanceof RfDefElement) {
                            elem = ((RfDefElement)elem).getNamedElement();
                        }
                        if (elem instanceof RfEntity) {
                            return 0;
                        }
                        if (elem instanceof RfArchitecture) {
                            return 1;
                        }
                        if (elem instanceof RfPackage) {
                            return 2;
                        }
                        if (elem instanceof RfPackageBody) {
                            return 3;
                        }
                        if (elem instanceof RfPort) {
                            RfPort port = (RfPort)elem;
                            if (port.isInput()) {
                                return 0;
                            }
                            if (port.isInout()) {
                                return 1;
                            }
                            if (port.isBuffer()) {
                                return 2;
                            }
                            if (port.isLinkage()) {
                                return 3;
                            }
                            if (port.isOutput()) {
                                return 4;
                            }
                            return 5;
                        }
                        if (elem instanceof RfVariable) {
                            return 6;
                        }
                        if (elem instanceof RfFunction) {
                            if (((RfFunction)elem).isTask()) {
                                return 7;
                            }
                            return 8;
                        }
                        if (elem instanceof RfBlock) {
                            return 9;
                        }
                        if (elem instanceof RfProcess) {
                            return 10;
                        }
                        if (elem instanceof RfComponent) {
                            return 11;
                        }
                        if (elem instanceof RfInstance) {
                            return 12;
                        }
                    }
                    return 100;
                }

                @Override
                public int compare(IDVTElementWrapper e1, IDVTElementWrapper e2) {
                    int line2;
                    int cat2;
                    if (!(e1.getRfElement() instanceof RfDefElement) || !(e2.getRfElement() instanceof RfDefElement)) {
                        return 0;
                    }
                    int cat1 = this.category(e1);
                    if (cat1 != (cat2 = this.category(e2))) {
                        return cat1 - cat2;
                    }
                    int line1 = ((RfDefElement)e1.getRfElement()).getStartLine();
                    if (line1 == (line2 = ((RfDefElement)e2.getRfElement()).getStartLine())) {
                        return 0;
                    }
                    if (line1 > line2) {
                        return 1;
                    }
                    return -1;
                }
            };
        }
        return this.fComparator;
    }
}

