/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTRfLabelProvider;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vhdldt.model.reflection.RfKind;

public class TypesViewMembersLabelProvider
extends DVTRfLabelProvider {
    public Image getNamedElementImage(IRfNamedElement element) {
        ImageDescriptor id = null;
        RfKind kind = RfKind.of(element);
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case ENTITY: {
                id = DVTImages.OUTLINE_ENTITY;
                break;
            }
            case ARCHITECTURE: {
                id = DVTImages.OUTLINE_ARCHITECTURE;
                break;
            }
            case PACKAGE: {
                id = DVTImages.OUTLINE_PACKAGE;
                break;
            }
            case PACKAGE_BODY: {
                id = DVTImages.PACKAGE_BLUE;
                break;
            }
            case PORT: {
                id = DVTImages.OUTLINE_INOUT_PORT;
                break;
            }
            case INPUT_PORT: {
                id = DVTImages.OUTLINE_INPUT_PORT;
                break;
            }
            case INOUT_PORT: {
                id = DVTImages.OUTLINE_INOUT_PORT;
                break;
            }
            case OUTPUT_PORT: {
                id = DVTImages.OUTLINE_OUTPUT_PORT;
                break;
            }
            case BUFFER_PORT: {
                id = DVTImages.OUTLINE_BUFFER_PORT;
                break;
            }
            case LINKAGE_PORT: {
                id = DVTImages.OUTLINE_LINKAGE_PORT;
                break;
            }
            case VARIABLE: {
                id = DVTImages.OUTLINE_VARIABLE;
                break;
            }
            case PROCEDURE: {
                id = DVTImages.OUTLINE_PROCEDURE;
                break;
            }
            case FUNCTION: {
                id = DVTImages.OUTLINE_FUNCTION;
                break;
            }
            case BLOCK: {
                id = DVTImages.OUTLINE_BLOCK;
                break;
            }
            case PROCESS: {
                id = DVTImages.OUTLINE_PROCESS;
                break;
            }
            case COMPONENT: {
                id = DVTImages.OUTLINE_COMPONENT;
                break;
            }
            case TYPE: {
                id = DVTImages.OUTLINE_TYPE;
                break;
            }
            case TYPE_BODY: {
                id = DVTImages.OUTLINE_TYPE;
                break;
            }
            case CONFIGURATION: {
                id = DVTImages.OUTLINE_CONFIGURATION;
                break;
            }
            case INTERFACE_PORT: {
                id = DVTImages.OUTLINE_INTERFACE_PORT;
                break;
            }
            case ARGUMENT: {
                id = DVTImages.OUTLINE_ARGUMENT;
                break;
            }
            case GENERIC: {
                id = DVTImages.OUTLINE_GENERIC;
                break;
            }
            case CONSTANT: {
                id = DVTImages.OUTLINE_CONSTANT;
                break;
            }
            case SIGNAL: {
                id = DVTImages.OUTLINE_SIGNAL;
                break;
            }
            case FILE: {
                id = DVTImages.OUTLINE_FILE;
                break;
            }
        }
        if (id == null) {
            return null;
        }
        return DVTImages.imageCache.getImage(id);
    }

    public String getNamedElementText(IRfNamedElement element) {
        String defaultName = element.getName();
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return defaultName;
        }
        RfMixedLangProject mixedLangProjectParent = rfProject.getMixedLangProjectParent();
        if (mixedLangProjectParent == null) {
            return defaultName;
        }
        try {
            IELParamValue value;
            ELConstantsManager paramManager;
            ELParamValues externalConstants;
            if (ELUtils.isVHDLConstant((IRfNamedElement)element) && (externalConstants = (paramManager = mixedLangProjectParent.getElabConstantsManager()).getExternalConstants((IRfNamedElement)element.getEnclosingScope())) != null && (value = externalConstants.getValueDirectly(defaultName)) != null) {
                ELManager manager = rfProject.getELManager();
                ELParamValuesHidEvaluator evaluator = ELParamValues.create((boolean)true).getHidEvaluator(manager);
                BitVectorContext paramContext = ELUtils.makeEvaluatorContext((IHidEvaluator)evaluator, (IRfNamedElement)element, null, (ELManager)manager);
                String actualValue = value.toNiceString(paramContext, PrefConst.getParamRadix(), true, false);
                return String.valueOf(defaultName) + " = " + actualValue;
            }
            return defaultName;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return defaultName;
        }
    }
}

