/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.compileorder.BaseCompileOrderViewContributor;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.views.CompileOrderViewLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.VhdlLanguageElement;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.utils.VhdlFileUtils;

public abstract class VhdlCompileOrderViewContributorCommon
extends BaseCompileOrderViewContributor {
    private CompileOrderViewLabelProvider fLabelProvider = new CompileOrderViewLabelProvider();

    private void toWrappers(RfTreeElementWrapper root, Collection<VhdlFileInstance> files, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        try {
            if (root == null || files == null || input == null || configurator == null || configurator.isCanceled()) {
                return;
            }
            boolean ignoreContentFilters = configurator.ignoreContentFilters();
            for (VhdlFileInstance instance : files) {
                if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                    return;
                }
                if (instance == null) continue;
                RfTreeElementWrapper child = new RfTreeElementWrapper(instance);
                child.setProject(configurator.getProject());
                String text = this.getLabelProvider((Object)child).getText((Object)child);
                DVTGUIFilterMatcher.ITextProvider textProvider = () -> text;
                if (!ignoreContentFilters && DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)configurator.getProject(), (IDVTFileInstance)instance, (DVTGUIFilterMatcher.ITextProvider)textProvider) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (!input.hasSearchedElementFiltered() && ViewsUtils.matchesPath((Object)((Object)child), (IRfFilterableTreeAccessor)configurator.getView())) {
                        input.setHasSearchedElementFiltered(true);
                    }
                    input.setHasGUIFilteredElements(true);
                    continue;
                }
                if (!this.shouldAddFile((ISymbolCollectorPrerequisite)child, configurator)) continue;
                input.incrementElementCount();
                root.addChild(child);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void countElements(IDVTElementWrapper root, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        if (root == null) {
            return;
        }
        if (root.getRfElement() instanceof VhdlFileInstance && root.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            input.incrementNotFilteredElementCount();
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            if (configurator.isCanceled()) {
                return;
            }
            this.countElements(child, configurator, input);
        }
    }

    private void filterOutElementsWithoutErrors(RfTreeElementWrapper root, RfTreeElementWrapper newRoot, CompileOrderViewInputConfigurator configurator) {
        List<RfTreeElementWrapper> children = root.getChildren();
        VhdlFileInstance rfElement = (VhdlFileInstance)root.getRfElement();
        boolean hasErrors = false;
        if (rfElement != null) {
            hasErrors = Utils.hasErrors((IProject)configurator.getProject(), (String)DVTFileUtils.getInstance().parser2resource(configurator.getProject(), rfElement.getParserPath()), (LanguageKind)LanguageKind.VHDL);
        }
        if (children == null || children.isEmpty()) {
            if (hasErrors) {
                newRoot.addChild(root);
            }
            return;
        }
        Iterator<RfTreeElementWrapper> iterator = children.iterator();
        while (iterator.hasNext()) {
            if (configurator.isCanceled()) {
                return;
            }
            RfTreeElementWrapper child = iterator.next();
            this.filterOutElementsWithoutErrors(child, newRoot, configurator);
            iterator.remove();
        }
        if (hasErrors) {
            newRoot.addChild(root);
        }
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (element == null || !(element instanceof VhdlFileInstance)) {
                return;
            }
            VhdlFileInstance instance = (VhdlFileInstance)element;
            IFile file = RfUtils.getFile(instance, project);
            if (file != null) {
                VhdlFileUtils.getInstance().openEditor(file, 0, null);
            } else if (instance.getParserPath() != null) {
                VhdlFileUtils.getInstance().openFile(project, instance.getParserPath().path, 0, null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public CompileOrderViewInput getInput(CompileOrderViewInputConfigurator configurator) {
        try {
            CompileOrderViewInput input = CompileOrderViewInput.emptyInput();
            IProject project = configurator.getProject();
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                return input;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return input;
            }
            List<VhdlFileInstance> compiledFileInstances = rfProject.getFiles();
            RfTreeElementWrapper root = new RfTreeElementWrapper();
            if (compiledFileInstances == null || compiledFileInstances.isEmpty()) {
                return input;
            }
            this.toWrappers(root, compiledFileInstances, configurator, input);
            if (configurator.isCanceled()) {
                return CompileOrderViewInput.emptyInput();
            }
            ViewsUtils.hierarchicalSearch((IDVTElementWrapper)root, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)configurator.getUpdateJob(), (StringMatcher[])configurator.getSearchSegments(), (boolean[])configurator.getSearchStrictness());
            if (configurator.hasShowFilesWithErrors()) {
                RfTreeElementWrapper newRoot = new RfTreeElementWrapper();
                this.filterOutElementsWithoutErrors(root, newRoot, configurator);
                List<RfTreeElementWrapper> children = newRoot.getChildren();
                if (children != null) {
                    children.stream().forEach(e -> e.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true));
                    Collections.sort(children, (o1, o2) -> ((VhdlFileInstance)o1.getRfElement()).getIndex() - ((VhdlFileInstance)o2.getRfElement()).getIndex());
                } else {
                    this.buildNoFilesWithErrorsContent(project, newRoot);
                }
                root = newRoot;
            }
            if (configurator.hasShowFilesWithErrors() || configurator.getSearchSegments() != null && configurator.getSearchSegments().length != 0) {
                this.countElements(root, configurator, input);
            } else {
                input.setNotFilteredElementCount(input.getElementCount());
            }
            int elementCount = input.getElementCount();
            if (elementCount == 0 || root.getChildren() == null) {
                return CompileOrderViewInput.emptyInput();
            }
            int notFilteredElementCount = input.getNotFilteredElementCount();
            input.setTableInfo("[" + (elementCount != notFilteredElementCount ? String.valueOf(notFilteredElementCount) + "/" + elementCount : Integer.valueOf(elementCount)) + ViewsUtils.getUnitName((String)"file", (int)elementCount, (String)" ", (String)"") + "]");
            List elements = input.getElements();
            if (configurator.isShowLanguageNameAsRootElement()) {
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new VhdlLanguageElement<String>(String.valueOf(LanguageKind.VHDL.VIEW_NAME) + " " + input.getTableInfo()));
                elements.add(languageWrapper);
                if (root.getChildren() != null) {
                    languageWrapper.addChildren(root.getChildren());
                }
            } else if (root.getChildren() != null) {
                elements.addAll(root.getChildren());
            }
            return input;
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
            return CompileOrderViewInput.emptyInput();
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper || adapted instanceof VhdlFileInstance;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : namedElement.getComment();
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoInclude(IProject project, IDVTElementWrapper wrapper) {
        RfTreeElementWrapper selectedElement = (RfTreeElementWrapper)wrapper;
        Object fileInstance = selectedElement.getRfElement();
        if (!(fileInstance instanceof VhdlFileInstance)) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        BuildFilePathLine buildFilePathLine = rfProject.getBuildFilePathLine((VhdlFileInstance)fileInstance);
        if (buildFilePathLine != null) {
            this.gotoTopFile(buildFilePathLine);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof VhdlLanguageElement) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
    }

    public String getShortFileName(IDVTElementWrapper element) {
        RfNamedElement namedElement = this.getNamedElement(element);
        if (namedElement != null) {
            return namedElement.getName();
        }
        return "";
    }

    public boolean canShowGotoIncludeMenu(IDVTElementWrapper element) {
        return true;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public void gotoImport(IProject project, IDVTElementWrapper wrapper) {
    }

    public boolean canShowGotoImportMenu(IDVTElementWrapper element) {
        return false;
    }

    protected InspectViewInput getInspectContent(IDVTElementWrapper wrapper) {
        IFile file;
        block7: {
            Object element;
            block6: {
                block5: {
                    try {
                        if (wrapper instanceof RfTreeElementWrapper) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                element = wrapper.getRfElement();
                if (element != null && element instanceof VhdlFileInstance) break block6;
                return null;
            }
            VhdlFileInstance instance = (VhdlFileInstance)element;
            file = RfUtils.getFile(instance, wrapper.getProject());
            if (file != null) break block7;
            return null;
        }
        return DVTInspectViewUtils.getInstance().processFile(file);
    }

    protected abstract void gotoTopFile(BuildFilePathLine var1);

    protected abstract void buildNoFilesWithErrorsContent(IProject var1, RfTreeElementWrapper var2);
}

