/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.BaseInspectViewContributor;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.FileCompileInfo;
import ro.amiq.dvt.ui.views.inspect.IWaveformViewerInspectViewInputContributor;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.inspect.InspectViewInputBuilder;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.parser.VhdlFileInstancesMap;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;

public abstract class VhdlInspectViewContributorCommon
extends BaseInspectViewContributor
implements IWaveformViewerInspectViewInputContributor {
    private static final HashSet<Character> possibleCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('\''), Character.valueOf('.'), Character.valueOf('B'), Character.valueOf('b'), Character.valueOf('S'), Character.valueOf('s'), Character.valueOf('X'), Character.valueOf('x'), Character.valueOf('O'), Character.valueOf('o'), Character.valueOf('D'), Character.valueOf('d'), Character.valueOf('U'), Character.valueOf('u'), Character.valueOf('\"'), Character.valueOf('_'), Character.valueOf('\''), Character.valueOf('#')));

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursorOffset) {
        IDocument document;
        RfProject rfProject;
        IProject project;
        IFile file;
        block13: {
            block12: {
                block11: {
                    block10: {
                        IEditorInput editorInput;
                        block9: {
                            block8: {
                                try {
                                    if (editor instanceof VhdlEditor) break block8;
                                    return null;
                                }
                                catch (Exception e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    return null;
                                }
                            }
                            VhdlEditor vhdlEditor = (VhdlEditor)editor;
                            editorInput = vhdlEditor.getEditorInput();
                            if (editorInput != null) break block9;
                            return null;
                        }
                        file = (IFile)editorInput.getAdapter(IFile.class);
                        if (file != null) break block10;
                        return null;
                    }
                    project = file.getProject();
                    if (project != null) break block11;
                    return null;
                }
                rfProject = RfManager.getInstance().getRfProject(project);
                if (rfProject != null) break block12;
                return null;
            }
            document = editor.getDocument();
            if (document != null) break block13;
            return null;
        }
        cursorOffset = cursorOffset >= document.getLength() ? document.getLength() - 1 : cursorOffset;
        List<Object> object = Arrays.asList(file, rfProject, document);
        return new InspectViewUpdateEvent(object, LanguageKind.VHDL, cursorOffset, null, project, InspectViewUpdateEventCommon.TYPE.PRELIMINARY_EDITOR);
    }

    public InspectViewUpdateEvent createEventFromPreliminary(InspectViewUpdateEvent preliminaryEvent) {
        RfFileDef fileDef;
        IDocument document;
        RfProject rfProject;
        IFile file;
        int cursorOffset;
        block10: {
            block9: {
                Object preliminaryEventElement;
                block8: {
                    try {
                        preliminaryEventElement = preliminaryEvent.getElement();
                        if (preliminaryEventElement instanceof List) break block8;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                List preliminaryData = (List)preliminaryEventElement;
                cursorOffset = preliminaryEvent.getCallOffset();
                file = (IFile)preliminaryData.get(0);
                rfProject = (RfProject)preliminaryData.get(1);
                document = (IDocument)preliminaryData.get(2);
                if (file != null && rfProject != null && document != null) break block9;
                return null;
            }
            fileDef = rfProject.getFile((IResource)file);
            if (fileDef != null && fileDef.getParserPath() != null) break block10;
            return null;
        }
        String parserPath = fileDef.getParserPath().path;
        IRfNamedElement element = null;
        RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(file, document, cursorOffset);
        if (elementAndScope == null || elementAndScope.getIRfNamedElement() == null) {
            String number = this.findNumberAtOffset(cursorOffset, document);
            if (number != null) {
                number = number.replace("_", "");
                return new InspectViewUpdateEvent((Object)number, LanguageKind.VHDL, cursorOffset, parserPath, file.getProject(), InspectViewUpdateEventCommon.TYPE.NUMBER);
            }
        } else {
            element = elementAndScope.getIRfNamedElement();
        }
        InspectViewUpdateEvent returnEvent = null;
        returnEvent = element == null ? new InspectViewUpdateEvent(file, InspectViewUpdateEventCommon.TYPE.FILE) : new InspectViewUpdateEvent((Object)element, element.getLanguageKind(), cursorOffset, parserPath, rfProject.getProject(), InspectViewUpdateEventCommon.TYPE.EDITOR);
        return returnEvent;
    }

    /*
     * Unable to fully structure code
     */
    private String findNumberAtOffset(int cursorOffset, IDocument document) throws BadLocationException {
        numberAtOffset = new StringBuilder();
        if (cursorOffset >= 0 && cursorOffset < document.getLength()) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            --cursorOffset;
lbl5:
            // 2 sources

            ** while (cursorOffset >= 0 && (document.getChar((int)cursorOffset) == '\n' || document.getChar((int)cursorOffset) == '\t' || document.getChar((int)cursorOffset) == ' '))
        }
lbl6:
        // 1 sources

        if (cursorOffset < 0) {
            return null;
        }
        endPosition = cursorOffset;
        start = '\u0000';
        end = '\u0000';
        for (startingPosition = cursorOffset; startingPosition >= 0; --startingPosition) {
            start = TextUtils.getChar((IDocument)document, (int)startingPosition);
            document.getChar(startingPosition);
            if (VhdlInspectViewContributorCommon.possibleCharacters.contains(Character.valueOf(start))) continue;
        }
        while (endPosition < document.getLength()) {
            end = document.getChar(endPosition);
            ++endPosition;
            if (VhdlInspectViewContributorCommon.possibleCharacters.contains(Character.valueOf(end))) continue;
        }
        index = startingPosition + 2;
        while (index <= endPosition - 2) {
            temp = document.getChar(index);
            numberAtOffset.append(temp);
            ++index;
        }
        return numberAtOffset.length() > 0 ? numberAtOffset.toString() : null;
    }

    public InspectViewInput getInput(InspectViewUpdateEvent event) {
        InspectViewInput result;
        block9: {
            IProject iProject;
            block8: {
                block7: {
                    block6: {
                        result = null;
                        if (event.getLanguage().equals((Object)LanguageKind.VHDL)) break block6;
                        return null;
                    }
                    iProject = event.getProject();
                    if (iProject != null && iProject.isAccessible() && iProject.hasNature("ro.amiq.vhdldt.VhdlNature")) break block7;
                    return null;
                }
                if (DVTPlugin.getDefault().collect().c(iProject, "F7668646C")) break block8;
                return null;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(iProject);
            if (rfProject != null) break block9;
            return null;
        }
        try {
            result = this.getInspectContent(event);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private InspectViewInput getInspectContent(InspectViewUpdateEvent event) {
        if (event.hasInfos()) {
            return this.getInspectFromDiagram(event);
        }
        IProject project = event.getProject();
        Object selectedElement = event.getElement();
        if (event.getType() == InspectViewUpdateEventCommon.TYPE.WRAPPER && selectedElement instanceof IDVTElementWrapper) {
            selectedElement = ((IDVTElementWrapper)selectedElement).getRfElement();
        }
        if (selectedElement instanceof IRfNamedElement) {
            IRfNamedElement element = (IRfNamedElement)selectedElement;
            return this.processNamedElement(project, element, event, null, null);
        }
        if (selectedElement instanceof IRfDefElement) {
            IRfDefElement def = (IRfDefElement)selectedElement;
            return DVTInspectViewUtils.getInstance().processDefElement(project, def, "--", null, 0, null);
        }
        return null;
    }

    public IRfNamedElementAndScope getNamedElementAndScope(IEditorPart activeEditor, int offset) {
        if (!(activeEditor instanceof VhdlEditor var3_4)) {
            return null;
        }
        IFile currentFile = vhdlEditor.getCurrentFile();
        if (currentFile == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getDocument((ITextEditor)vhdlEditor);
        if (document == null) {
            return null;
        }
        return RfUtils.getRfElement(currentFile, document, offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InspectViewInput processNamedElement(IProject project, IRfNamedElement element, InspectViewUpdateEvent event, String powerDomain, String ruleDetails) {
        int callOffset;
        int n = callOffset = event != null ? event.getCallOffset() : -1;
        if (element instanceof RfFunction) {
            RfFunction function = (RfFunction)element;
            if (function.isPrototype()) {
                element = function.getImplementation();
            }
        } else if (element instanceof RfFunctionsHolder) {
            RfFunctionsHolder holder = (RfFunctionsHolder)element;
            if (holder.hasMultipleFunctions()) return DVTInspectViewUtils.getInstance().processMultipleElements(project, holder.getLocalMembers(RfFunction.class));
            element = holder.getLastDefinedFunction();
        } else if (element instanceof IRfFieldElement && ELUtils.isActualValueConstant((IRfNamedElement)element)) {
            InspectViewInputBuilder inputBuilder = new InspectViewInputBuilder().appendInput(DVTInspectViewUtils.getInstance().processConstant((IRfFieldElement)element, project, event, "--")).appendInput(this.getWaveformInspectViewInput(project, element, callOffset));
            return inputBuilder.getInput();
        }
        if (powerDomain != null && !powerDomain.isEmpty()) {
            powerDomain = "Low Power Information:\n" + powerDomain;
        }
        if (ruleDetails != null) {
            String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject((IProject)project);
            powerDomain = String.valueOf(powerDomain) + lineDelimiter + ruleDetails + lineDelimiter;
        }
        IRfDefElement declaration = element.getDeclaration();
        InspectViewInputBuilder inputBuilder = new InspectViewInputBuilder().appendInput(DVTInspectViewUtils.getInstance().processDefElement(project, declaration, "--", powerDomain, 0, null)).appendInput(this.getWaveformInspectViewInput(project, element, callOffset));
        return inputBuilder.getInput();
    }

    public FileCompileInfo getCompileInfo(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        if (iFile.getProject() == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(iFile.getProject());
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)iFile);
        if (parserPath == null) {
            return null;
        }
        VhdlFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return null;
        }
        List<VhdlFileInstance> fileInstances = fileInstancesMap.getFileInstances(parserPath);
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        ArrayList<Integer> compileIndices = new ArrayList<Integer>();
        ArrayList<IBuildConfigParserConstants.LanguageSyntax> languageSyntaxes = new ArrayList<IBuildConfigParserConstants.LanguageSyntax>();
        for (VhdlFileInstance fileInstance : fileInstances) {
            if (fileInstance.getIndex() < 0) continue;
            compileIndices.add(fileInstance.getIndex());
            languageSyntaxes.add(fileInstance.getLanguageSyntax());
        }
        return compileIndices.isEmpty() ? null : new FileCompileInfo(compileIndices, languageSyntaxes);
    }
}

