/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.ui.views.layers.LayersViewInput;
import ro.amiq.dvt.ui.views.layers.LayersViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScopeUtil;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;
import ro.amiq.vhdldt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.VhdlLayersViewLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.VhdlQuickViewersUtil;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VhdlLayersViewContributor
implements ILayersViewContributor {
    private VhdlLayersViewLabelProvider fLabelProvider = new VhdlLayersViewLabelProvider();
    private int fNrTotalLayers;
    private int fNrTotalFiles;
    private int fNrNotFilteredLayers;
    private int fNrNotFilteredFiles;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        Object element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfDefElement) {
            actionHyperlink = RfUtils.createOpenAction((RfDefElement)element, project, null);
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public LayersViewInput getQuickViewInput(LayersViewInputConfigurator inputConfig) {
        this.fLabelProvider.setUsedByQuickLayersView(true);
        this.fNrTotalLayers = 0;
        this.fNrTotalFiles = 0;
        this.fNrNotFilteredLayers = 0;
        this.fNrNotFilteredFiles = 0;
        String bulkDataInfo = "";
        Object namedElement = null;
        boolean showScopeColumn = false;
        List<Object> elements = new ArrayList();
        try {
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)LanguageKind.VHDL)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfElementPair elementPair = this.getLayersData(rfProject, ev.getElementName(), ev.getVhdlEntityName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getStringMather(), true, ev.getOffset(), ev.getFileName(), inputConfig.getUpdateJob());
            if (elementPair.fElements == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, null, elements, showScopeColumn, bulkDataInfo);
            }
            elements = this.toQuickViewWrappers(elementPair.fElements, inputConfig);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
    }

    private List<IDVTElementWrapper> toQuickViewWrappers(List<IDVTElementWrapper> elements, LayersViewInputConfigurator inputConfig) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        UpdateJob updateJob = inputConfig.getUpdateJob();
        try {
            for (IDVTElementWrapper wrapper : elements) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                Object tmpElment = wrapper.getRfElement();
                if (!(tmpElment instanceof RfDefElement)) continue;
                RfDefElement rfDefElem = (RfDefElement)tmpElment;
                RfNamedElement namedElement = rfDefElem.getNamedElement();
                RfTreeElementWrapper lastWrapper = new RfTreeElementWrapper(namedElement.getDeclaration());
                RfNamedElement encScope = namedElement.getEnclosingScope();
                while (encScope != null && !(encScope instanceof RfProject)) {
                    if (encScope instanceof RfFunctionsHolder) {
                        encScope = encScope.getEnclosingScope();
                    }
                    RfTreeElementWrapper tmpWrapper = new RfTreeElementWrapper(encScope);
                    tmpWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS, "false");
                    tmpWrapper.addChild(lastWrapper);
                    lastWrapper = tmpWrapper;
                    encScope = encScope.getEnclosingScope();
                }
                this.addToFullTreeHelper(result, lastWrapper, updateJob);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void addToFullTreeHelper(List<IDVTElementWrapper> allWrappers, IDVTElementWrapper currentWrapper, UpdateJob updateJob) {
        boolean found = false;
        IDVTElementWrapper foundWrapper = null;
        for (IDVTElementWrapper tmpWrapper : allWrappers) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            if (!this.fLabelProvider.getText(tmpWrapper).equalsIgnoreCase(this.fLabelProvider.getText(currentWrapper))) continue;
            found = true;
            foundWrapper = tmpWrapper;
            break;
        }
        if (!found) {
            allWrappers.add(currentWrapper);
            return;
        }
        if (foundWrapper != null) {
            List currentChildren = currentWrapper.getChildren();
            if (currentChildren == null || currentChildren.isEmpty()) {
                return;
            }
            List foundChildren = foundWrapper.getChildren();
            if (foundChildren == null || foundChildren.isEmpty()) {
                foundWrapper.addChildren(currentChildren);
                return;
            }
            for (IDVTElementWrapper currentChild : currentChildren) {
                this.addToFullTreeHelper(foundChildren, currentChild, updateJob);
            }
        }
    }

    public LayersViewInput getInput(LayersViewInputConfigurator inputConfig) {
        this.fLabelProvider.setUsedByQuickLayersView(false);
        this.fNrTotalLayers = 0;
        this.fNrTotalFiles = 0;
        this.fNrNotFilteredFiles = 0;
        this.fNrNotFilteredLayers = 0;
        String bulkDataInfo = "";
        RfNamedElement namedElement = null;
        boolean showScopeColumn = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)LanguageKind.VHDL)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfElementPair elementPair = this.getLayersData(rfProject, ev.getElementName(), ev.getVhdlEntityName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getStringMather(), false, ev.getOffset(), ev.getFileName(), inputConfig.getUpdateJob());
            List<IDVTElementWrapper> wrappers = elementPair.fElements;
            namedElement = elementPair.fNamedElement;
            if (wrappers == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, null, elements, showScopeColumn, bulkDataInfo);
            }
            if (ev.getElementType() == 8 || ev.getElementType() == 16) {
                showScopeColumn = true;
            }
            elements.addAll(wrappers);
            bulkDataInfo = namedElement == null ? "" : (namedElement instanceof RfFunction ? ((RfFunction)namedElement).getFunctionSignatureWithReturnType(false) : namedElement.getSignature());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
    }

    private int getFilesNo(List<IDVTElementWrapper> wrappedElements) {
        HashSet<ParserPath> set = new HashSet<ParserPath>();
        int i = 0;
        while (i < wrappedElements.size()) {
            RfDefElement element = (RfDefElement)wrappedElements.get(i).getRfElement();
            set.add(element.getDefFile().getParserPath());
            ++i;
        }
        return set.size();
    }

    /*
     * WARNING - void declaration
     */
    private RfElementPair getLayersData(RfProject project, String elementName, String entityName, int elementType, List<RfNameTypeScopeHelper> elementScope, StringMatcher matcher, boolean triggeredFromQuickView, int lineOffset, String fileName, UpdateJob updateJob) {
        RfNamedElement namedElement = null;
        NullProtectedList<? extends RfDefElement> elementDefs = new NullProtectedList<RfDefElement>();
        List<IDVTElementWrapper> wrappers = new ArrayList<IDVTElementWrapper>();
        try {
            if (project == null) {
                return new RfElementPair(namedElement, wrappers);
            }
            IRfScopeElement scope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
            if (scope == null || !(scope instanceof IRfScope)) {
                return new RfElementPair(namedElement, wrappers);
            }
            Collection<RfLibrary> allLibraries = project.getLibraries();
            if (allLibraries == null) {
                return new RfElementPair(namedElement, wrappers);
            }
            if (elementType == 256 || elementType == 2) {
                void var16_20;
                Object var16_17 = null;
                if (elementType == 256 && scope instanceof RfArchitecture) {
                    namedElement = (RfArchitecture)scope;
                    RfEntity rfEntity = ((RfArchitecture)scope).getEntity();
                } else if (elementType == 2 && scope instanceof RfEntity) {
                    namedElement = (RfEntity)scope;
                    RfEntity rfEntity = (RfEntity)scope;
                }
                if (var16_20 == null) {
                    return new RfElementPair(namedElement, wrappers);
                }
                elementDefs.addAll(var16_20.getDeclarations());
                List<RfArchitecture> list = var16_20.getLocalMembers(RfArchitecture.class);
                if (list != null) {
                    for (RfArchitecture rfArchitecture : list) {
                        elementDefs.addAll(rfArchitecture.getDeclarations());
                    }
                }
            } else if (elementType == 8 || elementType == 16) {
                void var16_28;
                ArrayList<RfFunction> arrayList = new ArrayList<RfFunction>();
                if (scope instanceof RfFunction) {
                    scope = ((RfFunction)scope).getEnclosingScope();
                }
                if (scope instanceof RfPackage) {
                    List<RfFunction> list = this.getFunctionsFromPackageAndPackageBody((RfPackage)scope, elementName, updateJob);
                } else if (scope instanceof RfPackageBody) {
                    List<RfFunction> list = this.getFunctionsFromPackageAndPackageBody((RfPackageBody)scope, elementName, updateJob);
                } else if (scope instanceof RfEntity) {
                    List<RfFunction> list = this.getFunctionsFromEntityAndArchs((RfEntity)scope, elementName, updateJob);
                } else if (scope instanceof RfArchitecture) {
                    List<RfFunction> list = this.getFunctionsFromEntityAndArchs((RfArchitecture)scope, elementName, updateJob);
                } else if (scope instanceof RfType) {
                    List<RfFunction> list = this.getFunctions((RfNamedElement)scope, elementName);
                    RfNamedElement rfNamedElement = ((RfType)scope).getEnclosingScope();
                    if (rfNamedElement instanceof RfPackage) {
                        typeBody = rfNamedElement.getLocalMember(RfTypeBody.class, scope.getName());
                        if (typeBody != null) {
                            list.addAll(this.getFunctions(typeBody, elementName));
                        }
                        packageName = rfNamedElement.getName();
                        RfNamedElement rfNamedElement2 = rfNamedElement.getEnclosingScope().getLocalMember(RfPackageBody.class, packageName);
                        if (rfNamedElement2 instanceof RfPackageBody && (typeBody = rfNamedElement2.getLocalMember(RfTypeBody.class, scope.getName())) != null) {
                            list.addAll(this.getFunctions(typeBody, elementName));
                        }
                    } else if (rfNamedElement instanceof RfPackageBody) {
                        typeBody = rfNamedElement.getLocalMember(RfTypeBody.class, scope.getName());
                        if (typeBody != null) {
                            list.addAll(this.getFunctions(typeBody, elementName));
                        }
                        packageName = rfNamedElement.getName();
                        RfNamedElement rfNamedElement3 = rfNamedElement.getEnclosingScope().getLocalMember(RfPackage.class, packageName);
                        if (rfNamedElement3 instanceof RfPackage && (typeBody = rfNamedElement3.getLocalMember(RfTypeBody.class, scope.getName())) != null) {
                            list.addAll(this.getFunctions(typeBody, elementName));
                        }
                    }
                } else if (scope instanceof RfTypeBody) {
                    RfNamedElement rfNamedElement = ((RfTypeBody)scope).getEnclosingScope();
                    if (rfNamedElement instanceof RfPackage) {
                        type = rfNamedElement.getLocalMember(RfType.class, scope.getName());
                        if (type != null) {
                            arrayList.addAll(this.getFunctions((RfNamedElement)type, elementName));
                        }
                        packageName = rfNamedElement.getName();
                        RfNamedElement rfNamedElement4 = rfNamedElement.getEnclosingScope().getLocalMember(RfPackageBody.class, packageName);
                        if (rfNamedElement4 instanceof RfPackageBody && (type = rfNamedElement4.getLocalMember(RfType.class, scope.getName())) != null) {
                            arrayList.addAll(this.getFunctions((RfNamedElement)type, elementName));
                        }
                    } else if (rfNamedElement instanceof RfPackageBody) {
                        type = rfNamedElement.getLocalMember(RfType.class, scope.getName());
                        if (type != null) {
                            arrayList.addAll(this.getFunctions((RfNamedElement)type, elementName));
                        }
                        packageName = rfNamedElement.getName();
                        RfNamedElement rfNamedElement5 = rfNamedElement.getEnclosingScope().getLocalMember(RfPackage.class, packageName);
                        if (rfNamedElement5 instanceof RfPackage && (type = rfNamedElement5.getLocalMember(RfType.class, scope.getName())) != null) {
                            arrayList.addAll(this.getFunctions((RfNamedElement)type, elementName));
                        }
                    }
                    arrayList.addAll(this.getFunctions((RfNamedElement)scope, elementName));
                } else if (scope instanceof RfNamedElement) {
                    List<RfFunction> list = this.getFunctions((RfNamedElement)scope, elementName);
                }
                for (RfFunction rfFunction : var16_28) {
                    if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                        return new RfElementPair(namedElement, wrappers);
                    }
                    RfDefElement declaration = rfFunction.getDeclaration();
                    if (declaration != null && declaration.getDefFile().getName().equals(fileName) && declaration.getStartLine() == lineOffset) {
                        namedElement = rfFunction;
                    }
                    elementDefs.addAll(rfFunction.getDeclarations());
                }
            } else if (elementType == 512 || elementType == 1024) {
                if (scope instanceof RfPackage) {
                    RfDefElement rfDefElement = ((RfPackage)scope).getDeclaration();
                    elementDefs.add(rfDefElement);
                    List<RfPackageBody> list = ((RfPackage)scope).getPackageBodiesWithPrefix(scope.getName(), 9);
                    if (list != null) {
                        for (RfPackageBody packageBody : list) {
                            elementDefs.add(packageBody.getDeclaration());
                        }
                    }
                } else if (scope instanceof RfPackageBody) {
                    List<RfPackage> list = ((RfPackageBody)scope).getPackagesWithPrefix(scope.getName(), 9);
                    if (list != null) {
                        for (RfPackage rfPackage : list) {
                            elementDefs.add(rfPackage.getDeclaration());
                        }
                    }
                    RfDefElement rfDefElement = ((RfPackageBody)scope).getDeclaration();
                    elementDefs.add(rfDefElement);
                }
            }
            for (RfDefElement rfDefElement : elementDefs) {
                wrappers.add(new RfTreeElementWrapper(rfDefElement));
            }
            this.fNrTotalLayers = wrappers.size();
            this.fNrTotalFiles = this.getFilesNo(wrappers);
            if (matcher != null) {
                wrappers = this.filterElements(wrappers, matcher, triggeredFromQuickView, elementType);
            }
            this.fNrNotFilteredLayers = wrappers.size();
            this.fNrNotFilteredFiles = this.getFilesNo(wrappers);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new RfElementPair(namedElement, wrappers);
    }

    private List<RfFunction> getFunctions(RfNamedElement namedElement, String funcName) {
        ArrayList<RfFunction> functions = new ArrayList<RfFunction>();
        List<RfFunctionsHolder> fh = namedElement.getLocalMembers(RfFunctionsHolder.class);
        if (fh == null) {
            return functions;
        }
        for (RfFunctionsHolder rfFunctionsHolder : fh) {
            List<RfFunction> localFunctions = rfFunctionsHolder.getLocalMembers(RfFunction.class);
            if (localFunctions == null) continue;
            for (RfFunction rfFunction : localFunctions) {
                if (rfFunction.isPredefined() || !rfFunction.getName().equalsIgnoreCase(funcName)) continue;
                functions.add(rfFunction);
            }
        }
        return functions;
    }

    private List<RfFunction> getFunctionsFromEntityAndArchs(RfEntity entity, String functionName, UpdateJob updateJob) {
        ArrayList<RfFunction> result = new ArrayList<RfFunction>();
        List<RfFunction> tmp = this.getFunctions(entity, functionName);
        if (tmp != null) {
            result.addAll(tmp);
        }
        List<RfArchitecture> archs = entity.getArchitecturesWithPrefix("", 2);
        for (RfArchitecture architecture : archs) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return result;
            }
            tmp = this.getFunctions(architecture, functionName);
            if (tmp == null) continue;
            result.addAll(tmp);
        }
        return result;
    }

    private List<RfFunction> getFunctionsFromEntityAndArchs(RfArchitecture architecture, String functionName, UpdateJob updateJob) {
        return this.getFunctionsFromEntityAndArchs(architecture.getEntity(), functionName, updateJob);
    }

    private List<RfFunction> getFunctionsFromPackageAndPackageBody(RfPackage pkg, String functionName, UpdateJob updateJob) {
        ArrayList<RfFunction> result = new ArrayList<RfFunction>();
        if (pkg.isPredefined()) {
            return result;
        }
        List<RfFunction> tmp = this.getFunctions(pkg, functionName);
        if (tmp != null) {
            result.addAll(tmp);
        }
        List<RfPackageBody> pbodies = pkg.getPackageBodiesWithPrefix(pkg.getName(), 9);
        for (RfPackageBody body : pbodies) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return result;
            }
            tmp = this.getFunctions(body, functionName);
            if (tmp == null) continue;
            result.addAll(tmp);
        }
        return result;
    }

    private List<RfFunction> getFunctionsFromPackageAndPackageBody(RfPackageBody packageBody, String functionName, UpdateJob updateJob) {
        return this.getFunctionsFromPackageAndPackageBody(packageBody.getPackage(), functionName, updateJob);
    }

    private List<IDVTElementWrapper> filterElements(List<IDVTElementWrapper> elements, StringMatcher matcher, boolean triggeredFromQuickView, int elementType) {
        if (matcher == null) {
            return elements;
        }
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper wrapper : elements) {
            this.fLabelProvider.setUsedByQuickLayersView(triggeredFromQuickView);
            String name = this.fLabelProvider.getColumnText(wrapper, 0);
            String scope = elementType == 8 || elementType == 16 ? this.fLabelProvider.getColumnText(wrapper, 1) : "";
            String comment = triggeredFromQuickView ? "" : this.fLabelProvider.getColumnText(wrapper, 2);
            String fileName = this.fLabelProvider.getColumnText(wrapper, 3);
            String linenr = this.fLabelProvider.getColumnText(wrapper, 4);
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)name) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)scope) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)comment) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)fileName) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)linenr)) continue;
            result.add(wrapper);
        }
        return result;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfFileDef) {
            return false;
        }
        if (referenceData instanceof UpdateViewEvent) {
            UpdateViewEvent updateEvent = (UpdateViewEvent)referenceData;
            if (updateEvent.getFileName() == null) {
                return false;
            }
            return this.fLabelProvider.getColumnText(element, 4).equals(updateEvent.getFileName()) && this.fLabelProvider.getColumnText(element, 5).equals(String.valueOf(updateEvent.getOffset())) || this.fLabelProvider.getColumnText(element, 3).equals(updateEvent.getFileName()) && this.fLabelProvider.getColumnText(element, 4).equals(String.valueOf(updateEvent.getOffset()));
        }
        if (referenceData instanceof RfTreeElementWrapper) {
            return this.fLabelProvider.getColumnText(element, 4).equals(this.fLabelProvider.getColumnText(referenceData, 4)) && this.fLabelProvider.getColumnText(element, 5).equals(this.fLabelProvider.getColumnText(referenceData, 5)) || this.fLabelProvider.getColumnText(element, 3).equals(this.fLabelProvider.getColumnText(referenceData, 3)) && this.fLabelProvider.getColumnText(element, 4).equals(this.fLabelProvider.getColumnText(referenceData, 4));
        }
        if (rfElement instanceof RfDefElement) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
        }
        return false;
    }

    public void collectEMethodLayers(List<IDVTElementWrapper> allLayers) {
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursor) {
        RfNamedElement namedElement;
        RfWNamedElementAndScope elementAndScope;
        IDocument document;
        IProject project;
        IFile file;
        block22: {
            block21: {
                block20: {
                    VhdlEditor vhdlEditor;
                    block19: {
                        IDocumentProvider documentProvider;
                        IEditorInput editorInput;
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                try {
                                                    if (editor instanceof VhdlEditor) break block13;
                                                    return null;
                                                }
                                                catch (Exception e) {
                                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                                    return null;
                                                }
                                            }
                                            vhdlEditor = (VhdlEditor)editor;
                                            editorInput = vhdlEditor.getEditorInput();
                                            if (editorInput != null) break block14;
                                            return null;
                                        }
                                        file = (IFile)editorInput.getAdapter(IFile.class);
                                        if (file != null) break block15;
                                        return null;
                                    }
                                    project = file.getProject();
                                    if (project != null) break block16;
                                    return null;
                                }
                                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                                if (rfProject != null) break block17;
                                return null;
                            }
                            documentProvider = vhdlEditor.getDocumentProvider();
                            if (documentProvider != null) break block18;
                            return null;
                        }
                        document = documentProvider.getDocument((Object)editorInput);
                        if (document != null) break block19;
                        return null;
                    }
                    elementAndScope = RfUtils.getRfElement((ITextEditor)vhdlEditor, document, cursor);
                    if (elementAndScope != null) break block20;
                    return null;
                }
                namedElement = elementAndScope.getNamedElement();
                if (namedElement != null) break block21;
                return null;
            }
            if (namedElement instanceof RfFunctionsHolder) {
                namedElement = ((RfFunctionsHolder)namedElement).getLastDefinedFunction();
            }
            if (namedElement instanceof RfEntity || namedElement instanceof RfArchitecture || namedElement instanceof RfFunction || namedElement instanceof RfPackage || namedElement instanceof RfPackageBody) break block22;
            return null;
        }
        UpdateViewEvent updateEvent = VhdlQuickViewersUtil.createViewUpdateEvent(namedElement, project, elementAndScope.getScope(), 1);
        updateEvent.setOffset(document.getLineOfOffset(cursor) + 1);
        updateEvent.setFileName(file.getName());
        return updateEvent;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    static class RfElementPair {
        RfNamedElement fNamedElement;
        List<IDVTElementWrapper> fElements;

        public RfElementPair(RfNamedElement namedElement, List<IDVTElementWrapper> elementDefs) {
            this.fNamedElement = namedElement;
            this.fElements = elementDefs;
        }
    }
}

