/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.VhdlLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.VhdlLanguageElement;

public class VhdlLayersViewLabelProvider
extends VhdlLabelProvider {
    private AtomicBoolean fUsedByQuickLayersView = new AtomicBoolean(false);
    private TypesViewLabelProvider fTypesViewLabelProvider = new TypesViewLabelProvider();

    public void setUsedByQuickLayersView(boolean usedByQuickLayersView) {
        this.fUsedByQuickLayersView.set(usedByQuickLayersView);
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object wrapper, int columnIndex) {
        Image result = null;
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
        Object rfElement = rfWrapper.getRfElement();
        if (rfElement instanceof VhdlLanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(DVTImages.VHDL_LANGUAGE);
        }
        if (!(rfElement instanceof RfDefElement) && this.fUsedByQuickLayersView.get()) {
            if (rfElement instanceof RfArchitecture) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARCHITECTURE);
            }
            if (rfElement instanceof RfEntity) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY);
            } else if (rfElement instanceof RfLibrary) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY);
            } else if (rfElement instanceof RfPackage) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
            } else if (rfElement instanceof RfPackageBody) {
                result = DVTImages.imageCache.getImage(DVTImages.PACKAGE_BLUE);
            } else if (rfElement instanceof RfProcess) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS);
            }
            return this.fTypesViewLabelProvider.getImage(wrapper);
        }
        RfDefElement defElement = (RfDefElement)rfElement;
        RfNamedElement namedElement = defElement.getNamedElement();
        if (columnIndex == 0) {
            if (this.fUsedByQuickLayersView.get() && defElement instanceof RfFileDef) {
                IFile file = (IFile)defElement.getFileAdapter();
                if (file == null) {
                    result = DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE_GRAY);
                } else {
                    result = DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE);
                    IContainer parent = file.getParent();
                    while (parent != null && !(parent instanceof IProject)) {
                        if (parent.isLinked()) {
                            result = DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE_LINKED);
                            break;
                        }
                        parent = parent.getParent();
                    }
                }
            } else {
                result = namedElement instanceof RfFunction ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION) : (namedElement instanceof RfArchitecture ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARCHITECTURE) : (namedElement instanceof RfEntity ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY) : (namedElement instanceof RfLibrary ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY) : (namedElement instanceof RfPackage ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE) : (namedElement instanceof RfPackageBody ? DVTImages.imageCache.getImage(DVTImages.PACKAGE_BLUE) : (namedElement instanceof RfProcess ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS) : this.fTypesViewLabelProvider.getImage((Object)new RfTreeElementWrapper(namedElement))))))));
            }
            if (result != null && this.fDecorator != null) {
                return this.fDecorator.decorateImage(result, wrapper);
            }
        } else if (columnIndex == 1) {
            RfNamedElement enclosing = defElement.getNamedElement().getEnclosingScope();
            if (enclosing instanceof RfFunctionsHolder) {
                enclosing = enclosing.getEnclosingScope();
            }
            if ((result = enclosing instanceof RfFunction ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION) : (enclosing instanceof RfArchitecture ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARCHITECTURE) : (enclosing instanceof RfEntity ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY) : (enclosing instanceof RfLibrary ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY) : (enclosing instanceof RfPackage ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE) : (enclosing instanceof RfPackageBody ? DVTImages.imageCache.getImage(DVTImages.PACKAGE_BLUE) : (enclosing instanceof RfProcess ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS) : this.fTypesViewLabelProvider.getImage((Object)new RfTreeElementWrapper(enclosing))))))))) != null) {
                return result;
            }
        } else if (columnIndex == 3) {
            IFile file = (IFile)defElement.getDefFile().getFileAdapter();
            if (file == null) {
                result = DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE_GRAY);
            } else {
                result = DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE);
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        result = DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        String result = "";
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
        Object rfElement = rfWrapper.getRfElement();
        if (rfElement instanceof VhdlLanguageElement && columnIndex == 0) {
            return (String)((VhdlLanguageElement)((Object)rfElement)).getInfo();
        }
        if (!(rfElement instanceof RfDefElement) && this.fUsedByQuickLayersView.get()) {
            if (rfElement instanceof RfArchitecture || rfElement instanceof RfConfiguration) {
                return ((RfNamedElement)rfElement).getQualifiedName();
            }
            return this.fTypesViewLabelProvider.getText(wrapper);
        }
        RfDefElement defElement = (RfDefElement)rfElement;
        RfNamedElement namedElement = defElement.getNamedElement();
        switch (columnIndex) {
            case 0: {
                if (this.fUsedByQuickLayersView.get() && defElement instanceof RfFileDef) {
                    IFile file = (IFile)defElement.getFileAdapter();
                    if (file != null) {
                        result = file.getName();
                    }
                } else if (namedElement instanceof RfFunction) {
                    result = defElement.getName();
                    RfFunction func = (RfFunction)namedElement;
                    List<RfVariable> args = func.getArguments();
                    StringBuilder argsStr = new StringBuilder("(");
                    if (args != null && !args.isEmpty()) {
                        int i = 0;
                        while (i < args.size()) {
                            argsStr.append(args.get(i).getName());
                            IRfNamedElement associatedType = args.get(i).getAssociatedType();
                            if (associatedType != null) {
                                argsStr.append(" " + associatedType.getName());
                            }
                            if (i < args.size() - 1) {
                                argsStr.append(", ");
                            }
                            ++i;
                        }
                    }
                    argsStr.append(")");
                    IRfNamedElement assocType = func.getAssociatedType();
                    String retType = "";
                    if (assocType != null) {
                        retType = String.valueOf(assocType.getName()) + " ";
                    }
                    result = String.valueOf(retType) + result + argsStr.toString();
                    if (this.fUsedByQuickLayersView.get() && (rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS) == null || !rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS).equals("false"))) {
                        result = String.valueOf(result) + " @" + Integer.toString(defElement.getStartLine());
                    }
                } else {
                    result = defElement.getName();
                    if (this.fUsedByQuickLayersView.get() && (rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS) == null || !rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS).equals("false"))) {
                        result = String.valueOf(result) + " @" + Integer.toString(defElement.getStartLine());
                    }
                }
                result = ViewsUtils.trimText((String)result, (int)1000, (boolean)true);
                break;
            }
            case 1: {
                RfNamedElement enclosing = defElement.getNamedElement().getEnclosingScope();
                if (enclosing instanceof RfFunctionsHolder) {
                    enclosing = enclosing.getEnclosingScope();
                }
                result = "";
                if (enclosing instanceof RfArchitecture || enclosing instanceof RfConfiguration) {
                    result = enclosing.getQualifiedName();
                    break;
                }
                if (enclosing == null) break;
                result = enclosing.isAnonymous() ? "[anonymous]" : enclosing.getName();
                break;
            }
            case 2: {
                String comment = defElement.getDefComment();
                result = comment == null ? "" : comment;
                result = ViewsUtils.trimText((String)result, (int)100, (boolean)true);
                break;
            }
            case 3: {
                result = defElement.getDefFile().getName();
                break;
            }
            case 4: {
                result = Integer.toString(defElement.getStartLine());
            }
        }
        return result;
    }

    public String getText(Object element) {
        String result = this.getColumnText(element, 0);
        if (result == null) {
            return "";
        }
        return result;
    }
}

