/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.IInspectViewInputContributor;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.power.domain.PowerDomainView;
import ro.amiq.vhdldt.model.reflection.views.VhdlInspectViewContributor;

public class VhdlPFInspectViewContributor
implements IInspectViewInputContributor {
    public boolean canHandle(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source == null) {
            return false;
        }
        return source instanceof PowerDomainView;
    }

    public InspectViewInput getInput(InspectViewUpdateEvent event) {
        if (event.getType() != InspectViewUpdateEventCommon.TYPE.WRAPPER) {
            return null;
        }
        IDVTElementWrapper wrapper = (IDVTElementWrapper)event.getElement();
        IProject project = wrapper.getProject();
        if (project == null) {
            return null;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
            return null;
        }
        Object obj = wrapper.getRfElement();
        if (obj instanceof ElementPath) {
            RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
            if (mixedLangProject == null) {
                return null;
            }
            ELManager manager = mixedLangProject.getELManager();
            if (manager == null) {
                return null;
            }
            DVTPFModel pfModel = mixedLangProject.getPFModel();
            ElementPath elementPath = (ElementPath)obj;
            String pdName = pfModel.getPDNameForPath(elementPath);
            DVTPFInfo pdInfo = pfModel.getPDInfoForInstance(elementPath);
            ELInstance rfInstance = manager.getMemory().instanceFor(elementPath);
            IRfNamedElement field = null;
            IRfInstanceElement instance = null;
            String ruleDetails = "";
            if (rfInstance == null) {
                rfInstance = manager.getMemory().instanceFor(elementPath.removeLastSegment());
                if (rfInstance.getDescription() != null && rfInstance.getDescription().getAssociatedType() instanceof IRfDesignElement) {
                    instance = rfInstance.getDescription();
                    IRfNamedElement module = instance.getAssociatedType();
                    String fieldName = elementPath.lastSegment();
                    if (fieldName.contains("[")) {
                        fieldName = fieldName.substring(0, fieldName.indexOf("["));
                    }
                    field = DesignUtils.getFieldOrInstanceByName((String)fieldName, (DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)module));
                    pdName = pfModel.getPDNameForPath(elementPath.removeLastSegment());
                    pdInfo = pfModel.getPDInfoForInstance(elementPath.removeLastSegment());
                    if (pdInfo != null) {
                        String retentionRuleName;
                        String isolationStrategyName = pdInfo.getIsolationStrategyByElement(elementPath);
                        if (isolationStrategyName != null) {
                            DVTPFIsolationStrategyInfo isolationStrategyByName = pdInfo.getIsolationStrategyByName(isolationStrategyName);
                            isolationStrategyName = "Isolation strategy: " + isolationStrategyName;
                            if (isolationStrategyByName != null) {
                                isolationStrategyName = String.valueOf(isolationStrategyName) + " [Clamp value: " + isolationStrategyByName.getClampValue() + "]";
                            }
                            ruleDetails = isolationStrategyName;
                        }
                        if ((retentionRuleName = pdInfo.getRetentionRuleByElement(elementPath)) != null) {
                            ruleDetails = retentionRuleName = "Retention rule: " + retentionRuleName;
                        }
                    }
                }
            } else {
                String retentionRuleName;
                instance = rfInstance.getDescription();
                if (pdInfo != null && (retentionRuleName = pdInfo.getRetentionRuleByElement(elementPath)) != null) {
                    ruleDetails = retentionRuleName = "Retention rule: " + retentionRuleName;
                }
            }
            VhdlInspectViewContributor vhdlInspectViewContributor = new VhdlInspectViewContributor();
            if (field != null) {
                return vhdlInspectViewContributor.processNamedElement(project, field, null, pdName, ruleDetails);
            }
            return vhdlInspectViewContributor.processNamedElement(project, (IRfNamedElement)instance, null, pdName, ruleDetails);
        }
        if (obj instanceof DVTPFIsolationStrategyInfo) {
            DVTPFIsolationStrategyInfo isolationStrategy = (DVTPFIsolationStrategyInfo)obj;
            GoToInfo goTo = GoToInfo.of((String)isolationStrategy.getFilePath(), (int)-1, (int)-1, (int)isolationStrategy.getStartLine(), (int)isolationStrategy.getEndLine(), (String)isolationStrategy.getStrategyName(), (LanguageKind)event.getLanguage());
            InspectViewGoToInfo info = new InspectViewGoToInfo(goTo);
            return DVTInspectViewUtils.getInstance().processGoToInfos(Collections.singletonList(info), event.getProject(), event.getNofContextLine(), event.getLanguage(), true);
        }
        if (obj instanceof DVTPFRetentionRuleInfo) {
            DVTPFRetentionRuleInfo retentionRule = (DVTPFRetentionRuleInfo)obj;
            GoToInfo goTo = GoToInfo.of((String)retentionRule.getFilePath(), (int)-1, (int)-1, (int)retentionRule.getStartLine(), (int)retentionRule.getEndLine(), (String)retentionRule.getRuleName(), (LanguageKind)event.getLanguage());
            InspectViewGoToInfo info = new InspectViewGoToInfo(goTo);
            return DVTInspectViewUtils.getInstance().processGoToInfos(Collections.singletonList(info), event.getProject(), event.getNofContextLine(), event.getLanguage(), true);
        }
        if (obj instanceof DVTPFInfo) {
            DVTPFInfo retentionRule = (DVTPFInfo)obj;
            GoToInfo goTo = GoToInfo.of((String)retentionRule.getFilePath(), (int)-1, (int)-1, (int)retentionRule.getStartLine(), (int)retentionRule.getEndLine(), (String)retentionRule.getPowerDomainName(), (LanguageKind)event.getLanguage());
            InspectViewGoToInfo info = new InspectViewGoToInfo(goTo);
            return DVTInspectViewUtils.getInstance().processGoToInfos(Collections.singletonList(info), event.getProject(), event.getNofContextLine(), event.getLanguage(), true);
        }
        return new InspectViewInput("");
    }
}

