/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.DVTXmlSaveConfig;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.ui.views.semantic.HidHolderView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vhdldt.model.IVhdlModule;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScopeUtil;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.model.reflection.views.DHHistoryItem;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.VhdlHHViewContributor;
import ro.amiq.vhdldt.model.reflection.views.VhdlQuickViewersUtilCommon;

public class VhdlQuickViewersUtil
extends VhdlQuickViewersUtilCommon {
    private static volatile VhdlQuickViewersUtil fInstance;
    private static final Object fSyncInstance;
    private static Map<IFile, WaitEditorActiveJob> fWaitEditorJobs;
    private static final Object FAMILY_MODULE_REPARSE;
    private TreeItem fBestMatch;

    static {
        fSyncInstance = new Object();
        fWaitEditorJobs = new ConcurrentHashMap<IFile, WaitEditorActiveJob>();
        FAMILY_MODULE_REPARSE = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VhdlQuickViewersUtil getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VhdlQuickViewersUtil();
            }
        }
        return fInstance;
    }

    public void scheduleReparseIfNonTop(ITextEditor editor) {
        IProject project = VhdlQuickViewersUtil.getProject(editor);
        if (project == null) {
            return;
        }
        if (BuildConfigManager.isNonTopFileCompilationDisabled((IProject)project)) {
            return;
        }
        IFile resource = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (resource == null) {
            return;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)resource);
        if (parserPath == null) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        RfMixedLangProject rfMixedProject = rfProject.getMixedLangProjectParent();
        if (rfMixedProject == null) {
            return;
        }
        if (RfProjectState.BUILT.equals((Object)rfProject.getProjectState()) && !rfMixedProject.isBuildDone()) {
            return;
        }
        if (!RfProjectState.BUILT.equals((Object)rfProject.getProjectState()) && !RfProjectState.RESTORED.equals((Object)rfProject.getProjectState())) {
            return;
        }
        boolean isCompiled = rfProject.isCompiled(parserPath);
        if (isCompiled) {
            return;
        }
        RfFileDef fileDef = rfProject.getFile((IResource)resource);
        if (fileDef == null && !this.isWaitEditorJobScheduled(resource)) {
            WaitEditorActiveJob fWaitEditorJob = new WaitEditorActiveJob();
            fWaitEditorJob.setFile(resource);
            fWaitEditorJobs.put(resource, fWaitEditorJob);
            fWaitEditorJob.schedule(0L);
        }
    }

    private boolean isWaitEditorJobScheduled(IFile file) {
        if (file == null) {
            return false;
        }
        return fWaitEditorJobs.containsKey(file);
    }

    public void removeWaitEditorJob(IFile file) {
        if (file == null) {
            return;
        }
        fWaitEditorJobs.remove(file);
    }

    public static IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public TreeItem getSymbolAtLine(Tree tree, int line) {
        TreeItem item = this.getSymbolChildAtLine(tree, line);
        if (item == null) {
            item = this.fBestMatch;
        }
        return item;
    }

    private TreeItem getSymbolChildAtLine(Object parent, int line) {
        TreeItem[] items = null;
        if (parent instanceof Tree) {
            items = ((Tree)parent).getItems();
        } else if (parent instanceof TreeItem) {
            items = ((TreeItem)parent).getItems();
        }
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Object data;
                TreeItem item = items[i];
                if (!item.isDisposed() && (data = item.getData()) != null) {
                    Object element = ((RfTreeElementWrapper)((Object)data)).getRfElement();
                    if (!(element instanceof RfDefElement)) {
                        return null;
                    }
                    RfDefElement os = (RfDefElement)element;
                    if (line == os.getStartLine()) {
                        return item;
                    }
                    if (os.getStartLine() < line && (this.fBestMatch == null || this.fBestMatch.isDisposed() || ((RfDefElement)((RfTreeElementWrapper)((Object)this.fBestMatch.getData())).getRfElement()).getStartLine() > line || ((RfDefElement)((RfTreeElementWrapper)((Object)this.fBestMatch.getData())).getRfElement()).getStartLine() < os.getStartLine())) {
                        this.fBestMatch = item;
                    }
                    if ((item = this.getSymbolChildAtLine(item, line)) != null) {
                        return item;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void updateLayersView(RfNamedElement currentscope, RfNamedElement namedElement, IProject project, DVTViewEvent.EventKind kind, String sourceId, boolean updateHistory, boolean forceVisible) {
        UpdateViewEvent updateEvent = VhdlQuickViewersUtil.createViewUpdateEvent(namedElement, project, currentscope, updateHistory ? 1 : 0);
        DVTViewEvent viewEvent = new DVTViewEvent(kind, sourceId, new ViewDataContainer(project, (HistoryItem)updateEvent));
        ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.LayersView", (DVTViewEvent)viewEvent, (boolean)forceVisible);
    }

    public static int matchTypeForDesignHierarchyViewer(IRfNamedElement namedElement) {
        if (namedElement instanceof RfEntity) {
            return 2;
        }
        if (namedElement instanceof RfArchitecture) {
            return 256;
        }
        if (namedElement instanceof RfConfiguration) {
            return 16384;
        }
        if (namedElement instanceof RfInstance) {
            return 2048;
        }
        if (namedElement != null && !(namedElement instanceof RfNamedElement)) {
            return 32768;
        }
        return 0;
    }

    public static int getType(RfNamedElement namedElement) {
        if (namedElement instanceof RfEntity) {
            return 2;
        }
        if (namedElement instanceof RfFunction && ((RfFunction)namedElement).isFunction()) {
            return 8;
        }
        if (namedElement instanceof RfFunction) {
            return 16;
        }
        if (namedElement instanceof RfArchitecture) {
            return 256;
        }
        if (namedElement instanceof RfPackage) {
            return 512;
        }
        if (namedElement instanceof RfPackageBody) {
            return 1024;
        }
        if (namedElement instanceof RfInstance) {
            return 2048;
        }
        if (namedElement instanceof RfLibrary) {
            return 4096;
        }
        if (namedElement instanceof RfTypeBody) {
            return 262144;
        }
        if (namedElement instanceof RfBlock) {
            return 8192;
        }
        return 0;
    }

    public static UpdateViewEvent createViewUpdateEvent(RfNamedElement source, IProject project, IRfScope scope, int updateHistory) {
        String info = "";
        if (source != null) {
            String sig = source.getSignature();
            info = sig.replaceAll("\n", "");
        }
        return VhdlQuickViewersUtil.createViewUpdateEvent(info, source, project, scope, updateHistory);
    }

    public static UpdateViewEvent createViewUpdateEvent(String text, RfNamedElement source, IProject project, IRfScope scope, int updateHistory) {
        String projectName = null;
        if (project != null) {
            projectName = project.getName();
        }
        int elementType = VhdlQuickViewersUtil.getType(source);
        String elementName = null;
        List<? extends DVTRfNameTypeScopeHelper> elementScope = null;
        String entityName = null;
        if (source != null) {
            RfEntity entity;
            elementName = source.getName();
            elementScope = RfScopeUtil.getDefOfScopeElement(source);
            if (elementType == 256 && (entity = ((RfArchitecture)source).getEntity()) != null) {
                entityName = entity.getName();
            }
        }
        return new UpdateViewEvent(text, projectName, elementType, elementName, elementScope, entityName, LanguageKind.VHDL, updateHistory);
    }

    public static UpdateViewEvent createViewUpdateEvent(String text, String projectName, List<RfNameTypeScopeHelper> elementScope, String elementName, String entityName, int elementType, int updateHistory) {
        return new UpdateViewEvent(text, projectName, elementType, elementName, elementScope, entityName, LanguageKind.VHDL, updateHistory);
    }

    public IRfNamedElement getElementAtExactCursor() {
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (editor == null) {
            return null;
        }
        IProject project = Utils.getProjectFromEditor((ITextEditor)((ITextEditor)editor));
        if (project == null) {
            return null;
        }
        IDocument document = Utils.getDocumentFromEditor((ITextEditor)((ITextEditor)editor));
        if (document == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        int offset = ((DVTEditor)editor).getCursor();
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement((ITextEditor)editor, document, offset);
        if (namedElementAndScope != null) {
            return namedElementAndScope.getIRfNamedElement();
        }
        return null;
    }

    private static IRfNamedElement getElementAtVagueCursor() {
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(editor instanceof DVTEditor)) {
            return null;
        }
        DVTEditor dvtEditor = (DVTEditor)editor;
        IRfScopeElement scope = dvtEditor.getCursorScope();
        if (!(scope instanceof RfDefElement)) {
            return null;
        }
        return ((RfDefElement)scope).getNamedElement();
    }

    public void openHidHolderForElementAtCursor() {
        ViewDataContainer data = new ViewDataContainer(null, null);
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        IRfNamedElement namedElement = VhdlQuickViewersUtil.getElementAtVagueCursor();
        if (namedElement instanceof RfNamedElement && namedElement.getRfProject() != null) {
            project = namedElement.getRfProject().getProject();
            data.setHistoryItem((HistoryItem)new VhdlHHViewContributor.VhdlHHHistoryItem(RfElementPath.path((IRfNamedElement)namedElement), project));
        }
        data.setProject(project);
        HidHolderView view = (HidHolderView)ViewsUtils.getViewById((String)"ro.amiq.dvt.tests.ui.views.HidHolderView", (boolean)true);
        if (view == null) {
            return;
        }
        view.setInput(data);
        view.update(null);
    }

    public HistoryItem createDHHistoryItem(DVTXmlSaveConfig config, IProject project, boolean isElab, HistoryItemType historyItemType) {
        List inputElementScope = config.getElementScope();
        if (project == null || inputElementScope == null) {
            return null;
        }
        int size = inputElementScope.size();
        DVTRfNameTypeScopeHelper lastElementScope = (DVTRfNameTypeScopeHelper)inputElementScope.get(size - 1);
        if (lastElementScope == null) {
            return null;
        }
        if (!(lastElementScope instanceof RfNameTypeScopeHelper)) {
            return null;
        }
        String label = "[" + project.getName() + "] ";
        if (historyItemType == HistoryItemType.SHOW_INSTANCES_IN_DESIGN_HIERARCHY) {
            label = String.valueOf(label) + "Instances of ";
        }
        String fullName = lastElementScope.getElementName();
        String elementName = config.getInputElementName();
        String architectureName = ((RfNameTypeScopeHelper)lastElementScope).getElementArchitectureName();
        if (lastElementScope.getElementKind() == 256 && size >= 2) {
            DVTRfNameTypeScopeHelper entityElementScope = (DVTRfNameTypeScopeHelper)inputElementScope.get(size - 2);
            if (entityElementScope == null) {
                return null;
            }
            fullName = String.valueOf(fullName) + " of " + entityElementScope.getElementName();
        } else if (lastElementScope.getElementKind() == 2 && architectureName != null) {
            fullName = String.valueOf(architectureName) + " of " + fullName;
            elementName = architectureName;
        }
        if (fullName == null) {
            return null;
        }
        label = String.valueOf(label) + fullName;
        if (config.getTreePath() != null) {
            label = String.valueOf(label) + " (" + config.getTreePath().toString() + ")";
        }
        return new DHHistoryItem(label, project.getName(), elementName, inputElementScope, historyItemType);
    }

    static class WaitEditorActiveJob
    extends Job {
        private IFile fFile;

        public WaitEditorActiveJob() {
            super("Wait Editor");
            this.setPriority(50);
            this.setSystem(true);
        }

        public void setFile(IFile file) {
            this.fFile = file;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_MODULE_REPARSE;
        }

        public boolean shouldSchedule() {
            boolean shouldSchedule;
            boolean bl = shouldSchedule = super.shouldSchedule() && ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (!shouldSchedule) {
                fWaitEditorJobs.remove(this.fFile);
            }
            return shouldSchedule;
        }

        public boolean shouldRun() {
            boolean shouldRun;
            boolean bl = shouldRun = super.shouldRun() && ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (!shouldRun) {
                fWaitEditorJobs.remove(this.fFile);
            }
            return shouldRun;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    IVhdlModule VhdlFile = VhdlModelManager.getInstance().getVhdlModel().getOrCreateVhdlFile(this.fFile);
                    VhdlFile.scheduleReparse(false, true, 0L, true);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    fWaitEditorJobs.remove(this.fFile);
                }
            }
            finally {
                fWaitEditorJobs.remove(this.fFile);
            }
            return Status.OK_STATUS;
        }
    }
}

