/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.TypesViewMembersLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.VhdlTypesViewContributorCommon;

public class VhdlTypesViewContributor
extends VhdlTypesViewContributorCommon {
    public VhdlTypesViewContributor() {
        super(new TypesViewLabelProvider(), (IMembersLabelProvider)new TypesViewMembersLabelProvider());
    }

    public MembersViewInput getMembersInput(Object wrapper, StringMatcher stringMatcher) {
        MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
        if (wrapper == null) {
            return emptyResult;
        }
        Object rfElement = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : wrapper;
        if (!(rfElement instanceof RfNamedElement) || rfElement instanceof RfConfiguration) {
            return emptyResult;
        }
        RfNamedElement namedElemet = (RfNamedElement)rfElement;
        AtomicBoolean hasGUIFilteredMembers = new AtomicBoolean(false);
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        if (namedElemet instanceof RfArchitecture) {
            this.collectMembers(stringMatcher, namedElemet, elements, hasGUIFilteredMembers);
            this.collectMembers(stringMatcher, ((RfArchitecture)namedElemet).getEntity(), elements, hasGUIFilteredMembers);
            return new MembersViewInput(elements, hasGUIFilteredMembers.get());
        }
        if (namedElemet instanceof IRfAssociatedType && ((IRfAssociatedType)((Object)namedElemet)).getAssociatedType() != null) {
            namedElemet = (RfNamedElement)((IRfAssociatedType)((Object)namedElemet)).getAssociatedType();
        }
        this.collectMembers(stringMatcher, namedElemet, elements, hasGUIFilteredMembers);
        return new MembersViewInput(elements, hasGUIFilteredMembers.get());
    }

    private void collectMembers(StringMatcher stringMatcher, RfNamedElement namedElement, List<IDVTElementWrapper> elements, AtomicBoolean hasGUIFilteredElements) {
        List<RfEnum> enums;
        if (namedElement instanceof RfType && (enums = namedElement.getEnclosingScope().getLocalMembers(RfEnum.class)) != null) {
            Iterator<RfEnum> iterator = enums.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getParentEnumTypeName().equals(namedElement.getName())) continue;
                iterator.remove();
            }
            this.collectMatchingMembers(elements, enums, stringMatcher, hasGUIFilteredElements);
        }
        if (namedElement instanceof RfPackage) {
            this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfComponent.class), stringMatcher, hasGUIFilteredElements);
        }
        if (namedElement instanceof RfBlock) {
            this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfInstance.class), stringMatcher, hasGUIFilteredElements);
            this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfPort.class), stringMatcher, hasGUIFilteredElements);
            this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfComponent.class), stringMatcher, hasGUIFilteredElements);
        }
        if (namedElement instanceof RfComponent) {
            this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfPort.class), stringMatcher, hasGUIFilteredElements);
        }
        this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfVariable.class), stringMatcher, hasGUIFilteredElements);
        this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfActionBlock.class), stringMatcher, hasGUIFilteredElements);
        this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfFunction.class), stringMatcher, hasGUIFilteredElements);
        List<RfFunctionsHolder> localFunctionsHolders = namedElement.getLocalMembers(RfFunctionsHolder.class);
        if (localFunctionsHolders != null) {
            for (RfFunctionsHolder holder : localFunctionsHolders) {
                this.collectMatchingMembers(elements, holder.getLocalMembers(RfFunction.class), stringMatcher, hasGUIFilteredElements);
            }
        }
    }

    private void collectMatchingMembers(Collection<IDVTElementWrapper> result, Iterable<? extends RfNamedElement> members, StringMatcher stringMatcher, AtomicBoolean hasGUIFilteredElements) {
        if (members == null) {
            return;
        }
        for (RfNamedElement rfNamedElement : members) {
            if (rfNamedElement.isPredefined()) continue;
            RfTreeElementWrapper elementWrapper = new RfTreeElementWrapper(rfNamedElement);
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)this.getMembersViewLabelProvider().getText((Object)elementWrapper))) continue;
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES_MEMBERS, (IRfNamedElement)rfNamedElement, () -> this.getLabelProvider((Object)elementWrapper).getText((Object)elementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                hasGUIFilteredElements.set(true);
                continue;
            }
            result.add(elementWrapper);
        }
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return;
        }
        Object elem = element.getRfElement();
        if (!(elem instanceof RfNamedElement)) {
            return;
        }
        RfUtils.createOpenAction((IRfNamedElement)elem, project, null).open();
    }
}

