/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.comparators.ClassComparator;
import ro.amiq.dvt.ui.views.comparators.LabelProviderElementComparator;
import ro.amiq.dvt.ui.views.comparators.LabelProviderWrapperComparator;
import ro.amiq.dvt.ui.views.lazy.views.types.BaseTypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInput;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.VhdlLanguageElement;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class VhdlTypesViewContributorCommon
extends BaseTypesViewContributor {
    protected VhdlTypesViewContributorCommon(DVTBaseLabelProvider typesViewLabelProvider, IMembersLabelProvider typesViewMembersLabelProvider) {
        super(typesViewLabelProvider, typesViewMembersLabelProvider);
    }

    public TypesViewInput getInput(TypesViewInputConfigurator inputConfigurator) {
        try {
            TypesViewInput input = TypesViewInput.emptyInput();
            if (inputConfigurator == null) {
                return input;
            }
            IProject project = inputConfigurator.getProject();
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                return input;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return input;
            }
            RfTreeElementWrapper tmpRoot = new RfTreeElementWrapper();
            this.collectTypes(rfProject, tmpRoot, inputConfigurator, input);
            if (!tmpRoot.hasChildren()) {
                return input;
            }
            if (inputConfigurator.isCanceled()) {
                return TypesViewInput.emptyInput();
            }
            int matchCount = this.filterTree(tmpRoot, inputConfigurator);
            if (matchCount >= 0) {
                input.setNrNotFilteredTypes(matchCount);
            }
            Collections.sort(tmpRoot.getChildren(), new ClassComparator());
            if (inputConfigurator.isShowLanguageNameAsRootElement()) {
                int nrTypes = input.getNrTypes();
                String langInfo = String.valueOf(LanguageKind.VHDL.VIEW_NAME) + " [" + (matchCount != -1 ? String.valueOf(matchCount) + "/" + nrTypes : Integer.valueOf(nrTypes)) + ViewsUtils.getUnitName((String)"type", (int)nrTypes, (String)" ", (String)"") + "]";
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new VhdlLanguageElement<String>(langInfo));
                languageWrapper.addChildren(tmpRoot.getChildren());
                input.setElements(Arrays.asList(new IDVTElementWrapper[]{languageWrapper}));
                return input;
            }
            input.setElements(new ArrayList<RfTreeElementWrapper>(tmpRoot.getChildren()));
            return input;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return TypesViewInput.emptyInput();
        }
    }

    private void collectTypes(RfProject rfProject, RfTreeElementWrapper root, TypesViewInputConfigurator configurator, TypesViewInput input) {
        try {
            if (input == null || configurator == null || configurator.isCanceled() || configurator.shouldStopCollecting()) {
                return;
            }
            boolean ignoreContentFilters = configurator.ignoreContentFilters();
            Collection<RfLibrary> libraries = rfProject.getLibraries();
            if (libraries == null) {
                return;
            }
            for (RfLibrary library : libraries) {
                if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                    return;
                }
                RfTreeElementWrapper wrapper = new RfTreeElementWrapper(library);
                if (!ignoreContentFilters && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES, (IRfNamedElement)library, () -> this.getLabelProvider((Object)wrapper).getText((Object)wrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    input.setHasGUIFilteredElements(true);
                    if (input.isSearchedElementFiltered()) continue;
                    IRfFilterableTreeAccessor view = configurator.getView();
                    if ((view.getTreeSearchPort() == null || view.getTreeSearchPort().isEmpty()) && ViewsUtilsCommon.matchesPath((Object)((Object)wrapper), (IRfFilterableTreeAccessor)view)) {
                        input.setSearchedElementFiltered(true);
                        continue;
                    }
                    if (view.getTreeSearchPort() != null && !view.getTreeSearchPort().isEmpty()) {
                        input.setSearchedElementFiltered(this.hasFilteredSearchedPorts(rfProject, library, view));
                        continue;
                    }
                    if (!library.hasLocalMembers()) continue;
                    input.setSearchedElementFiltered(this.hasFilteredSearchedLocalMember(rfProject, library, view));
                    continue;
                }
                if (library.isPredefined() || library.isImplicit()) continue;
                RfTreeElementWrapper nextRoot = configurator.isCollectingSymbols() ? root : wrapper;
                this.addAllChildElements(rfProject, nextRoot, library, configurator, input);
                if (!this.shouldAddLibrary(wrapper, configurator)) continue;
                root.addChild(wrapper);
            }
            if (root.hasChildren()) {
                Collections.sort(root.getChildren(), new LabelProviderWrapperComparator((ILabelProvider)this.getLabelProvider((Object)root), true));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addAllChildElements(RfProject project, RfTreeElementWrapper root, RfNamedElement parent, TypesViewInputConfigurator configurator, TypesViewInput input) {
        List<Object> childElements;
        if (configurator == null || configurator.isCanceled() || configurator.shouldStopCollecting()) {
            return;
        }
        boolean ignoreContentFilters = configurator.ignoreContentFilters();
        if (this.shouldIncludeEntities(configurator)) {
            List<RfEntity> allEntities = parent == null ? null : parent.getLocalMembers(configurator.hideDuplicates(), RfEntity.class);
            childElements = allEntities == null ? new ArrayList() : allEntities.stream().map(entity -> entity).collect(Collectors.toList());
        } else {
            childElements = project.getLocalTypes(parent, false, configurator.isCategorySort(), configurator.hideDuplicates(), (Comparator<? super RfNamedElement>)new LabelProviderElementComparator((ILabelProvider)this.getLabelProvider((Object)root), true));
        }
        for (RfNamedElement element : childElements) {
            if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                return;
            }
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper(element);
            if (!ignoreContentFilters && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES, (IRfNamedElement)element, () -> this.getLabelProvider((Object)root).getText((Object)wrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                input.setHasGUIFilteredElements(true);
                if (input.isSearchedElementFiltered()) continue;
                IRfFilterableTreeAccessor view = configurator.getView();
                if ((view.getTreeSearchPort() == null || view.getTreeSearchPort().isEmpty()) && ViewsUtilsCommon.matchesPath((Object)((Object)wrapper), (IRfFilterableTreeAccessor)view)) {
                    input.setSearchedElementFiltered(true);
                    continue;
                }
                if (view.getTreeSearchPort() != null && !view.getTreeSearchPort().isEmpty()) {
                    input.setSearchedElementFiltered(this.hasFilteredSearchedPorts(project, element, view));
                    continue;
                }
                if (!element.hasLocalMembers()) continue;
                input.setSearchedElementFiltered(this.hasFilteredSearchedLocalMember(project, element, view));
                continue;
            }
            if (element.isPredefined() || element.isImplicit()) continue;
            if (!(element instanceof RfPackage) && !(element instanceof RfPackageBody)) {
                input.incrementNrTypes();
            }
            if (this.shouldAddType(wrapper, configurator)) {
                root.addChild(wrapper);
            }
            if (configurator.shouldStopCollecting()) break;
            RfTreeElementWrapper nextRoot = configurator.isCollectingSymbols() ? root : wrapper;
            this.addAllChildElements(project, nextRoot, element, configurator, input);
        }
        if (!configurator.isCategorySort() && root.hasChildren()) {
            Collections.sort(root.getChildren(), new LabelProviderWrapperComparator((ILabelProvider)this.getLabelProvider((Object)root), true));
        }
    }

    private boolean shouldAddLibrary(RfTreeElementWrapper libraryWrapper, TypesViewInputConfigurator configurator) {
        if (!configurator.isCollectingSymbols()) {
            return libraryWrapper.hasChildren();
        }
        if (!SymbolQueryKey.LIBRARY.isEqualTo(configurator.getQueryKey())) {
            return false;
        }
        if (!this.symbolMatchesQueryPattern((ISymbolCollectorPrerequisite)libraryWrapper, configurator.getSymbolConfigurator())) {
            return false;
        }
        configurator.countNewSymbol();
        return true;
    }

    private boolean shouldIncludeEntities(TypesViewInputConfigurator configurator) {
        if (!configurator.isCollectingSymbols()) {
            return false;
        }
        return SymbolQueryKey.ENTITY.isEqualTo(configurator.getQueryKey());
    }

    private int filterTree(RfTreeElementWrapper root, TypesViewInputConfigurator viewConfigurator) {
        if (root == null || viewConfigurator == null) {
            return -1;
        }
        if (!viewConfigurator.getView().isFiltered()) {
            return -1;
        }
        if (viewConfigurator.isCollectingSymbols()) {
            return -1;
        }
        ComplexFilter filter = new ComplexFilter(viewConfigurator.getView(), true){

            public boolean shouldSkipCount(IDVTElementWrapper node) {
                if (node.getRfElement() == null) {
                    return true;
                }
                if (!(node.getRfElement() instanceof RfNamedElement)) {
                    return true;
                }
                RfNamedElement namedElement = (RfNamedElement)node.getRfElement();
                return namedElement instanceof RfLibrary || namedElement instanceof RfPackage || namedElement instanceof RfPackageBody;
            }
        };
        ViewsUtils.filterElementComplex((IDVTElementWrapper)root, (ComplexFilter)filter, (IProgressMonitor)viewConfigurator.getMonitor());
        return filter.matchCount;
    }

    private boolean hasFilteredSearchedPorts(RfProject project, RfNamedElement parentElement, IRfFilterableTreeAccessor view) {
        if (ViewsUtilsCommon.matchesUnfilteredPort((IDVTElementWrapper)new RfTreeElementWrapper(parentElement), (IRfFilterableTreeAccessor)view)) {
            return true;
        }
        if (!parentElement.hasLocalMembers()) {
            return false;
        }
        List<RfNamedElement> childElements = project.getLocalTypes(parentElement, false, false, true);
        for (RfNamedElement element : childElements) {
            if (ViewsUtilsCommon.matchesUnfilteredPort((IDVTElementWrapper)new RfTreeElementWrapper(element), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedPorts(project, element, view)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFilteredSearchedLocalMember(RfProject project, RfNamedElement parentElement, IRfFilterableTreeAccessor view) {
        if (!parentElement.hasLocalMembers()) {
            return false;
        }
        List<RfNamedElement> childElements = project.getLocalTypes(parentElement, false, false, true);
        for (RfNamedElement element : childElements) {
            if (ViewsUtilsCommon.matchesPath((Object)((Object)new RfTreeElementWrapper(element)), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(project, element, view)) continue;
            return true;
        }
        return false;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (object == null || !(object instanceof RfNamedElement)) {
                return;
            }
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction((RfNamedElement)object, project, (IRegion)new Region(0, 1));
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof VhdlLanguageElement) {
            return false;
        }
        if (rfElement instanceof RfLibrary) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.getLabelProvider(element).getText(element));
    }

    protected IRfKind getKind(IRfNamedElement e) {
        return RfKind.of(e);
    }

    public IRfKind getKind(String rfKindValue) {
        try {
            return RfKind.valueOf(rfKindValue);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

