/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.vhdldt.model.IVhdlModule;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.parser.IParsingListener;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.parser.VhdlProblem;
import ro.amiq.vhdldt.parser.VhdlSkipInfo;
import ro.amiq.vhdldt.parser.VhdlStartedInfo;
import ro.amiq.vhdldt.parser.VhdlUtil;
import ro.amiq.vhdldt.ui.persistenttask.TaskInfoWrapper;

public class VhdlAMS {
    public static final int ENTITY = 0;
    public static final int COMPONENT = 1;
    public static final int INSTANTIATION = 2;
    public static final int ARCHITECTURE = 3;
    public static final int CONFIGURATION = 4;
    public static final int INSTANTIATION_SET = 5;
    private VhdlUtil fUtil = new VhdlUtil();
    private IVhdlModule fParsingInstanceListener;
    private boolean fInterrupted;

    public void parseFile(String filename, String libraryName, IBuildConfigParserConstants.LanguageSyntax languageSyntax, RfProject rfProject, String documentContent, boolean incremental, int fileIndex, int invocNumber, int maxIssuesKindNumber, Set<String> translatePragmas, List<CustomPragma> customPragmas, DVTCodeCommentsPreferences commentsPreferences, Set<String> taskNames, boolean caseSensitive, boolean hideTaskName, SkipCompileFilter skipCompileFilter) {
        try {
            this.fUtil.setLanguageSyntax(languageSyntax);
            this.fUtil.setMaxIssuesKindPerFile(maxIssuesKindNumber);
            this.fUtil.setTaskTagsProperties(taskNames, caseSensitive, hideTaskName);
            this.fUtil.setCustomPragmas(customPragmas);
            this.fUtil.setTranslatePragmas(translatePragmas);
            this.fUtil.setSkipCompileFilter(skipCompileFilter);
            this.fUtil.restoreFileInstancesMap(rfProject.getFileInstancesMap());
            VhdlUtil.setCommentsPreferences(commentsPreferences);
            File file = new File(filename);
            ParserPath parserPath = new ParserPath(filename);
            this.fUtil.cleanMessages(parserPath);
            if (this.fUtil.isIgnored(file)) {
                this.fUtil.notifyParsingListeners(new VhdlSkipInfo(parserPath));
                return;
            }
            this.fUtil.notifyParsingListeners(new VhdlStartedInfo(parserPath, languageSyntax));
            if (incremental) {
                List<VhdlFileInstance> fileInstances = this.fUtil.getFileInstances(parserPath);
                if (fileInstances == null || fileInstances.isEmpty()) {
                    IProject project = rfProject.getProject();
                    if (project != null && !BuildConfigManager.isNonTopFileCompilationDisabled((IProject)project)) {
                        VhdlFileInstance fileInstance = new VhdlFileInstance(rfProject, parserPath, fileIndex, invocNumber, null, languageSyntax);
                        fileInstance.setLibraryScopeName(libraryName);
                        this.fUtil.setCurrentFile(fileInstance);
                        this.fUtil.addFileInstance(fileInstance);
                        this.fParsingInstanceListener.notifyInstanceParsing(fileInstance, this);
                        this.parseFileInstance(file, parserPath, rfProject, documentContent, libraryName, incremental, languageSyntax);
                    }
                } else {
                    for (VhdlFileInstance fileInstance : fileInstances) {
                        this.fUtil.setCurrentFile(fileInstance);
                        this.fParsingInstanceListener.notifyInstanceParsing(fileInstance, this);
                        libraryName = fileInstance.getLibraryScopeName();
                        this.parseFileInstance(file, parserPath, rfProject, documentContent, libraryName, incremental, languageSyntax);
                    }
                }
            } else {
                VhdlFileInstance fileInstance = new VhdlFileInstance(rfProject, parserPath, fileIndex, invocNumber, null, languageSyntax);
                fileInstance.setLibraryScopeName(libraryName);
                this.fUtil.setCurrentFile(fileInstance);
                this.fUtil.addFileInstance(fileInstance);
                this.parseFileInstance(file, parserPath, rfProject, documentContent, libraryName, incremental, languageSyntax);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fUtil.removeComments();
    }

    public void removeFileInstance(ParserPath parserPath) {
        this.fUtil.removeFileInstance(parserPath);
    }

    /*
     * Exception decompiling
     */
    private void parseFileInstance(File file, ParserPath parserPath, RfProject rfProject, String documentContent, String libraryName, boolean incremental, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void restorePrevDefElementsOnCancel(RfProject project, ParserPath parserPath) {
        try {
            IncrementalDeltaContainer incrementalDeltaContainer = project.getIncrementalDeltaContainer();
            if (incrementalDeltaContainer == null) {
                return;
            }
            if (this.fInterrupted) {
                incrementalDeltaContainer.restoreDefElementsOnCancelIncremental(project, parserPath);
            }
            incrementalDeltaContainer.clearDefElementsBeforeIncremental();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void addParsingInstanceListener(IVhdlModule vhdlModule) {
        this.fParsingInstanceListener = vhdlModule;
    }

    public void removeParsingInstanceListener(IVhdlModule vhdlModule) {
        this.fParsingInstanceListener = null;
    }

    public List<VhdlProblem> getErrors(ParserPath parserPath) {
        Set<VhdlProblem> problems = this.fUtil.getErrors(parserPath);
        if (problems == null) {
            return null;
        }
        ArrayList<VhdlProblem> result = new ArrayList<VhdlProblem>(problems.size());
        result.addAll(problems);
        return result;
    }

    public List<VhdlProblem> getWarnings(ParserPath parserPath) {
        Set<VhdlProblem> problems = this.fUtil.getWarnings(parserPath);
        if (problems == null) {
            return null;
        }
        ArrayList<VhdlProblem> result = new ArrayList<VhdlProblem>(problems.size());
        result.addAll(problems);
        return result;
    }

    public final List<TaskInfoWrapper> getTasks(ParserPath parserPath) {
        List<TaskInfoWrapper> taskInfoWrappers = this.fUtil.getTasks(parserPath);
        if (taskInfoWrappers == null) {
            return null;
        }
        ArrayList<TaskInfoWrapper> result = new ArrayList<TaskInfoWrapper>(taskInfoWrappers.size());
        result.addAll(taskInfoWrappers);
        return result;
    }

    public boolean isEncrypted(ParserPath parserPath) {
        return this.fUtil.isEncrypted(parserPath);
    }

    public Map<ParserPath, Set<VhdlProblem>> getErrorsMap() {
        return this.fUtil.getErrorsMap();
    }

    public Map<ParserPath, Set<VhdlProblem>> getWarningsMap() {
        return this.fUtil.getWarningsMap();
    }

    public Map<ParserPath, List<TaskInfoWrapper>> getTasksMap() {
        return this.fUtil.getTasksMap();
    }

    public void interrupt() {
        this.fUtil.setInterrupt(true);
    }

    public boolean isInterrupted() {
        return this.fUtil.getInterrupt();
    }

    protected boolean hasParsingListeners() {
        return !this.fUtil.fParsingListeners.isEmpty();
    }

    public void addParsingListener(IParsingListener l) {
        this.fUtil.fParsingListeners.add(l);
    }

    public void removeParsingListener(IParsingListener l) {
        this.fUtil.fParsingListeners.remove(l);
    }

    public void resetInterrupt() {
        this.fUtil.setInterrupt(false);
    }
}

