/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentsTable;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.parser.VhdlCompileInfo;
import ro.amiq.vhdldt.utils.Utils;

public class VhdlFileInstance
implements IDVTFileInstance,
Serializable {
    private static final long serialVersionUID = 1L;
    private ParserPath fParserPath;
    private String fLibraryName;
    private String fShortFileName;
    private RfProject fRfProject;
    private IBuildConfigParserConstants.ToolCompat fToolCompat;
    private int fNofRawLines;
    private VhdlCompileInfo compileInfo;
    private List<CustomPragmaUsage> fCustomPragmas;
    private transient CommentsTable fComments;
    private IBuildConfigParserConstants.LanguageSyntax fLanguageSyntax;

    protected VhdlFileInstance(RfProject rfProject, ParserPath parserPath, int index, int invocNumber, IBuildConfigParserConstants.ToolCompat toolCompat, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        this.setFileName(parserPath);
        this.compileInfo = new VhdlCompileInfo(index, invocNumber);
        this.fRfProject = rfProject;
        this.fToolCompat = toolCompat;
        this.fNofRawLines = 0;
        this.fLanguageSyntax = languageSyntax;
        this.fCustomPragmas = new ArrayList<CustomPragmaUsage>();
    }

    public void setFileName(ParserPath parserPath) {
        if (parserPath == null) {
            return;
        }
        this.fParserPath = parserPath;
        this.fShortFileName = Utils.getFileName(parserPath.path);
    }

    public final String getShortFileName() {
        return this.fShortFileName;
    }

    public int getInvocNumber() {
        return this.compileInfo.getInvocNumber();
    }

    public IBuildConfigParserConstants.ToolCompat getToolCompat() {
        return this.fToolCompat;
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return this.fLanguageSyntax;
    }

    public void setNofRawLines(int nofRawLines) {
        this.fNofRawLines = nofRawLines;
    }

    public int getNofRawLines() {
        return this.fNofRawLines;
    }

    protected final void addComment(Comment comment, int line, DVTCodeCommentsPreferences commentsPreferences) {
        if (this.fRfProject == null) {
            return;
        }
        if (!commentsPreferences.getAddSingleLineComment() && comment.getKind() == Comment.CommentStyle.SL_KIND) {
            return;
        }
        if (this.fComments == null) {
            this.fComments = new CommentsTable();
        }
        this.fComments.add(comment, line);
    }

    public final void cleanAllComments(boolean recursive) {
        if (this.fComments != null) {
            this.fComments.clear();
        }
        this.fComments = null;
    }

    public final CommentsTable getComments() {
        return this.fComments;
    }

    public ParserPath getParserPath() {
        return this.fParserPath;
    }

    public VhdlCompileInfo getCompileInfo() {
        return this.compileInfo;
    }

    public int getIndex() {
        return this.compileInfo.getCompileIndex();
    }

    public void endDefElement(IRfDefElement defElement) {
        if (this.fRfProject == null) {
            return;
        }
        if (defElement == null || this.fComments == null) {
            return;
        }
        int i = defElement.getStartLine() + 1;
        while (i < defElement.getEndLine()) {
            Comment comment = this.fComments.get(i);
            if (Comment.isComment((Comment)comment)) {
                this.fComments.remove(i);
            }
            ++i;
        }
    }

    public RfProject getRfProject() {
        return this.fRfProject;
    }

    public void setLibraryScopeName(String libraryName) {
        this.fLibraryName = libraryName;
    }

    public String getLibraryScopeName() {
        return this.fLibraryName;
    }

    public void deepClean() {
    }

    public void addCustomPragma(CustomPragmaUsage pragma) {
        this.fCustomPragmas.add(pragma);
    }

    public List<CustomPragmaUsage> getCustomPragmas() {
        if (this.fCustomPragmas == null) {
            return new ArrayList<CustomPragmaUsage>();
        }
        return this.fCustomPragmas;
    }

    public void setCustomPragmas(List<CustomPragmaUsage> pragmas) {
        if (this.fCustomPragmas == null) {
            this.fCustomPragmas = new ArrayList<CustomPragmaUsage>();
        }
        this.fCustomPragmas.addAll(pragmas);
    }

    public void cleanCustomPragmas() {
        this.fCustomPragmas.clear();
    }

    public boolean isInstanceInScope(IRfNamedElement instance) {
        if (instance == null) {
            return false;
        }
        IRfLibraryElement enclosingLibrary = instance.getEnclosingLibrary();
        if (enclosingLibrary == null) {
            return false;
        }
        if (this.fLibraryName == null) {
            return false;
        }
        return this.fLibraryName.equals(enclosingLibrary.getName());
    }

    public boolean isValid() {
        return this.fLibraryName != null;
    }
}

