/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.parser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.parser.VhdlFileInstance;

public class VhdlFileInstancesMap
implements Serializable {
    private static final long serialVersionUID = 7L;
    private Map<ParserPath, List<VhdlFileInstance>> fFileInstancesMap = new LinkedHashMap<ParserPath, List<VhdlFileInstance>>();

    public VhdlFileInstancesMap(RfProject rfProject) {
    }

    public void addFileInstance(VhdlFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        List<VhdlFileInstance> fileInstances = this.fFileInstancesMap.get(parserPath);
        if (fileInstances == null) {
            fileInstances = new ArrayList<VhdlFileInstance>();
            this.fFileInstancesMap.put(parserPath, fileInstances);
        }
        fileInstances.add(fileInstance);
    }

    protected void removeFileInstance(ParserPath parserPath) {
        this.fFileInstancesMap.remove(parserPath);
    }

    protected Map<ParserPath, List<VhdlFileInstance>> getFileInstances() {
        return this.fFileInstancesMap;
    }

    public List<VhdlFileInstance> getFileInstances(ParserPath parserPath) {
        if (this.fFileInstancesMap == null) {
            return Collections.emptyList();
        }
        return this.fFileInstancesMap.get(parserPath);
    }

    public final void clear() {
        if (this.fFileInstancesMap != null) {
            this.fFileInstancesMap.clear();
        }
    }

    public final void cleanAllComments(boolean recursive) {
        if (this.fFileInstancesMap == null || this.fFileInstancesMap.isEmpty()) {
            return;
        }
        for (List<VhdlFileInstance> fileInstances : this.fFileInstancesMap.values()) {
            for (VhdlFileInstance fileInstance : fileInstances) {
                fileInstance.cleanAllComments(recursive);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void deepClean() {
        if (this.fFileInstancesMap == null || this.fFileInstancesMap.isEmpty()) {
            return;
        }
        for (List<VhdlFileInstance> fileInstances : this.fFileInstancesMap.values()) {
            for (VhdlFileInstance fileInstance : fileInstances) {
                fileInstance.deepClean();
            }
        }
    }
}

