/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.parser;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.DVTLexerStack;
import ro.amiq.vhdldt.parser.VhdlLexer;
import ro.amiq.vhdldt.parser.VhdlUtil;

public class VhdlLexerStack
extends DVTLexerStack
implements TokenStream {
    private VhdlLexer lexer;
    private volatile VhdlUtil util;
    private VhdlLexerState lexerState;

    public VhdlLexerStack(VhdlLexer lexer, VhdlUtil util) {
        this.push(lexer);
        this.util = util;
        this.lexerState = VhdlLexerState.OTHERS;
    }

    public Token nextToken() throws TokenStreamException {
        if (this.util.getInterrupt()) {
            throw new TokenStreamException("Parsing canceled!");
        }
        Token currToken = this.lexer.nextTokenCustom();
        if (currToken != null && currToken.getType() != 1) {
            if (this.lexerState == VhdlLexerState.OTHERS && (currToken.getType() == 70 || currToken.getType() == 152)) {
                this.lexerState = VhdlLexerState.LIBRARY_OR_USE_CLAUSE;
                this.util.addComment(this.lexer.parserPath, currToken.getLine(), Comment.CODE_USELIB_INFO);
            } else if (this.lexerState == VhdlLexerState.LIBRARY_OR_USE_CLAUSE && currToken.getType() == 197) {
                this.lexerState = VhdlLexerState.OTHERS;
                this.util.addComment(this.lexer.parserPath, currToken.getLine(), Comment.CODE_USELIB_INFO);
            } else {
                this.util.nextTokenLine(this.lexer.parserPath, currToken.getLine());
            }
        }
        return currToken;
    }

    public void push(VhdlLexer lexer) {
        this.lexer = lexer;
    }

    public void pop() {
    }

    public static enum VhdlLexerState {
        LIBRARY_OR_USE_CLAUSE,
        OTHERS;

    }
}

