/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.parser;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import ro.amiq.dvt.model.problems.ISourceProblem;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;

public class VhdlProblem
implements ISourceProblem,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    private int fSeverity;
    private int fLine;
    private int fOffsetStart;
    private int fOffsetEnd;
    private String fFileName;
    private String fMessage;
    private String fPrefix;
    private int fFileIndex;
    private int fInvocNumber;
    private Map<String, Object> fAttributes;
    private transient Severity fSeverityAfterWaive;

    public VhdlProblem(int severity, String filename, String prefix, int line, String message, int fileIndex, int invocNumber) {
        this.fFileName = DVTStringUtil.intern((String)Utils.canonicPath((String)filename));
        this.fLine = line;
        this.fMessage = message;
        this.fPrefix = DVTStringUtil.intern((String)prefix);
        this.fSeverity = severity;
        this.fFileIndex = fileIndex;
        this.fInvocNumber = invocNumber;
    }

    public int getInvocNumber() {
        return this.fInvocNumber;
    }

    public int getLine() {
        return this.fLine;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public int getFileIndex() {
        return this.fFileIndex;
    }

    public String getMessage(boolean prependPrefix) {
        if (prependPrefix &= this.fPrefix != null) {
            if (this.fFileIndex <= 0) {
                return DVTStringUtil.appendString((Object[])new Object[]{"_", this.fPrefix, " ", this.fMessage});
            }
            return DVTStringUtil.appendString((Object[])new Object[]{this.fPrefix, " ", this.fMessage});
        }
        if (this.fFileIndex <= 0) {
            return DVTStringUtil.appendString((Object[])new Object[]{"_", this.fMessage});
        }
        return this.fMessage;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public String getCanonicFileName() {
        try {
            return new File(this.fFileName).getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.fFileName;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof VhdlProblem && this.fLine == ((VhdlProblem)obj).getLine() && this.fSeverity == ((VhdlProblem)obj).fSeverity && this.fFileName.equals(((VhdlProblem)obj).getFileName())) {
            if (this.fMessage.startsWith("NON_STANDARD_") || ((VhdlProblem)obj).fMessage.startsWith("NON_STANDARD_")) {
                return this.fMessage.equals(((VhdlProblem)obj).fMessage);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String result = null;
        result = this.fSeverity == 1 ? "*** Error: " : "*** Warning: ";
        result = String.valueOf(result) + this.getMessage(true) + "\n" + "    detected at line " + this.getLine() + " in '" + this.getFileName() + "'";
        return result;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.fAttributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    public void setOffsetStart(int offsetStart) {
        this.fOffsetStart = offsetStart;
    }

    public void setOffsetEnd(int offsetEnd) {
        this.fOffsetEnd = offsetEnd;
    }

    public int getOffsetStart() {
        return this.fOffsetStart;
    }

    public int getOffsetEnd() {
        return this.fOffsetEnd;
    }

    public void setFileName(String filename) {
        this.fFileName = DVTStringUtil.intern((String)filename);
    }

    public int hashCode() {
        return (String.valueOf(this.fSeverity) + "@" + this.fLine + "@" + this.fFileName).hashCode();
    }

    public Severity getSeverityAfterWaive() {
        return this.fSeverityAfterWaive;
    }

    public void setSeverityAfterWaive(Severity severity) {
        this.fSeverityAfterWaive = severity;
    }
}

