/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.CommentsTable;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.vhdldt.model.reflection.RfNonStandardProblem;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.parser.IParsingInfo;
import ro.amiq.vhdldt.parser.IParsingListener;
import ro.amiq.vhdldt.parser.VhdlCompileInfo;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.parser.VhdlFileInstancesMap;
import ro.amiq.vhdldt.parser.VhdlProblem;
import ro.amiq.vhdldt.ui.persistenttask.TaskInfoWrapper;

public class VhdlUtil {
    private VhdlFileInstancesMap fFileInstancesMap;
    private Map<ParserPath, List<TaskInfoWrapper>> fTaskTableMap;
    private Map<ParserPath, Set<VhdlProblem>> fErrorTableMap;
    private Map<ParserPath, Set<VhdlProblem>> fWarningTableMap;
    private Map<ParserPath, Boolean> fEncryptedTableMap;
    private VhdlFileInstance fCurrentFileInstance;
    protected static boolean fDebugMode = false;
    public static final String SEVERITY_ERROR = "*** Error: ";
    public static final String SEVERITY_WARNING = "*** Warning: ";
    protected static final String DEBUG_PREFIX = "*** Debug: ";
    protected static final String LOADING_MESSAGE = "Parsing file: ";
    private static final String NON_STANDARD_SEVERITY = "*** Warning: ";
    private static final String NON_STANDARD_COMMON_ID = "NON_STANDARD_";
    private int MAX_ISSUE_KIND_PER_FILE = 100;
    private SkipCompileFilter fSkipCompileFilter;
    private static DVTCodeCommentsPreferences fCommentsPreferences = new DVTCodeCommentsPreferences();
    protected List<IParsingListener> fParsingListeners = new ArrayList<IParsingListener>();
    private volatile boolean fInterrupt;
    private final HashSet<String> fRemoved_1076_1987_Set = this.getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1987);
    private final HashSet<String> fRemoved_1076_1993_Set = this.getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1993);
    private final HashSet<String> fRemoved_1076_1_1999_Set = this.getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_1999);
    private final HashSet<String> fRemoved_1076_2000_Set = this.getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2000);
    private final HashSet<String> fRemoved_1076_2002_Set = this.getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2002);
    private final HashSet<String> fRemoved_1076_1_2007_Set = this.getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_2007);
    private final HashSet<String> fRemoved_1076_2008_Set = this.getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008);
    private IBuildConfigParserConstants.LanguageSyntax fLanguageSyntax = IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_1999;
    private static final int TASK_TAG_MAX_DESCRIPTION_LENGTH = 100;
    private static final int TASK_TAG_MAX_LINE_LENGTH = 200;
    private static final int TASK_TAG_LIMIT = 100;
    private Set<String> fTranslatePragmas;
    private Set<String> fCustomPragmaFirstIdentifiers;
    private Map<String, CustomPragma> fStartPragmas;
    private Map<String, CustomPragma> fEndPragmas;
    private Set<String> fTaskNames;
    private boolean fTaskNamesCaseSensitive;
    private boolean fHideTaskName;

    protected VhdlUtil() {
        this.fErrorTableMap = new HashMap<ParserPath, Set<VhdlProblem>>();
        this.fWarningTableMap = new HashMap<ParserPath, Set<VhdlProblem>>();
        this.fTaskTableMap = new HashMap<ParserPath, List<TaskInfoWrapper>>();
        this.fEncryptedTableMap = new HashMap<ParserPath, Boolean>();
    }

    public static void setCommentsPreferences(DVTCodeCommentsPreferences commentsPreferences) {
        fCommentsPreferences = commentsPreferences == null ? new DVTCodeCommentsPreferences() : commentsPreferences;
    }

    public void restoreFileInstancesMap(VhdlFileInstancesMap fileInstancesMap) {
        this.fFileInstancesMap = fileInstancesMap;
    }

    protected List<VhdlFileInstance> getFileInstances(ParserPath parserPath) {
        return this.fFileInstancesMap.getFileInstances(parserPath);
    }

    public void addFileInstance(VhdlFileInstance fileInstance) {
        this.fFileInstancesMap.addFileInstance(fileInstance);
    }

    protected void removeFileInstance(ParserPath parserPath) {
        this.fFileInstancesMap.removeFileInstance(parserPath);
    }

    protected void reportClean() {
        this.fErrorTableMap = new HashMap<ParserPath, Set<VhdlProblem>>();
        this.fWarningTableMap = new HashMap<ParserPath, Set<VhdlProblem>>();
        this.fTaskTableMap = new HashMap<ParserPath, List<TaskInfoWrapper>>();
        this.fEncryptedTableMap = new HashMap<ParserPath, Boolean>();
    }

    protected Map<ParserPath, Set<VhdlProblem>> getErrorsMap() {
        return this.fErrorTableMap;
    }

    protected Map<ParserPath, Set<VhdlProblem>> getWarningsMap() {
        return this.fWarningTableMap;
    }

    protected Map<ParserPath, List<TaskInfoWrapper>> getTasksMap() {
        return this.fTaskTableMap;
    }

    public void setSkipCompileFilter(SkipCompileFilter skipCompileFilter) {
        this.fSkipCompileFilter = skipCompileFilter;
    }

    public boolean isIgnored(File file) {
        if (this.fSkipCompileFilter == null) {
            return false;
        }
        ParserPath parserPath = new ParserPath(file.getAbsolutePath());
        return this.fSkipCompileFilter.shouldSkip(parserPath, true);
    }

    protected void reportError(String severity, String filename, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, int offsetStart, int length, String message) {
        Set<VhdlProblem> warningTable;
        String messagePrefix;
        ParserPath parserPath = new ParserPath(filename);
        if (message != null && message.length() > 1) {
            message = String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1);
        }
        boolean isNonStandard = message != null && message.startsWith(NON_STANDARD_COMMON_ID);
        String string = messagePrefix = isNonStandard ? null : String.valueOf(this.getLanguageSyntaxName(languageSyntax)) + ":";
        if (severity != null && severity.equals(SEVERITY_ERROR)) {
            Set<VhdlProblem> errorTable = this.getErrors(parserPath);
            if (errorTable.size() < this.MAX_ISSUE_KIND_PER_FILE || isNonStandard) {
                VhdlProblem problem = new VhdlProblem(1, filename, messagePrefix, line, message, this.fCurrentFileInstance.getIndex(), this.fCurrentFileInstance.getInvocNumber());
                if (offsetStart >= 0 && length > 0) {
                    problem.setOffsetStart(offsetStart);
                    problem.setOffsetEnd(offsetStart + length);
                }
                if (!errorTable.contains(problem)) {
                    errorTable.add(problem);
                }
            }
        } else if (severity != null && severity.equals("*** Warning: ") && ((warningTable = this.getWarnings(parserPath)).size() < this.MAX_ISSUE_KIND_PER_FILE || isNonStandard)) {
            VhdlProblem problem = new VhdlProblem(0, filename, messagePrefix, line, message, this.fCurrentFileInstance.getIndex(), this.fCurrentFileInstance.getInvocNumber());
            if (offsetStart >= 0 && length > 0) {
                problem.setOffsetStart(offsetStart);
                problem.setOffsetEnd(offsetStart + length);
            }
            if (!warningTable.contains(problem)) {
                warningTable.add(problem);
            }
        }
    }

    protected void cleanMessages(ParserPath parserPath) {
        if (this.fWarningTableMap.containsKey(parserPath)) {
            this.fWarningTableMap.remove(parserPath);
        }
        if (this.fErrorTableMap.containsKey(parserPath)) {
            this.fErrorTableMap.remove(parserPath);
        }
        if (this.fTaskTableMap.containsKey(parserPath)) {
            this.fTaskTableMap.remove(parserPath);
        }
        if (this.fEncryptedTableMap.containsKey(parserPath)) {
            this.fEncryptedTableMap.remove(parserPath);
        }
    }

    public Set<VhdlProblem> getWarnings(ParserPath parserPath) {
        if (this.fWarningTableMap.containsKey(parserPath)) {
            return this.fWarningTableMap.get(parserPath);
        }
        LinkedHashSet<VhdlProblem> warningTable = new LinkedHashSet<VhdlProblem>();
        this.fWarningTableMap.put(parserPath, warningTable);
        return warningTable;
    }

    public Set<VhdlProblem> getErrors(ParserPath parserPath) {
        if (this.fErrorTableMap.containsKey(parserPath)) {
            return this.fErrorTableMap.get(parserPath);
        }
        LinkedHashSet<VhdlProblem> errorTable = new LinkedHashSet<VhdlProblem>();
        this.fErrorTableMap.put(parserPath, errorTable);
        return errorTable;
    }

    public List<TaskInfoWrapper> getTasks(ParserPath parserPath) {
        if (this.fTaskTableMap.containsKey(parserPath)) {
            return this.fTaskTableMap.get(parserPath);
        }
        LinkedList<TaskInfoWrapper> taskTable = new LinkedList<TaskInfoWrapper>();
        this.fTaskTableMap.put(parserPath, taskTable);
        return taskTable;
    }

    protected void setCurrentFile(VhdlFileInstance fileToParse) {
        this.fCurrentFileInstance = fileToParse;
    }

    public int getCurrentFileIndex() {
        return this.fCurrentFileInstance.getIndex();
    }

    public VhdlCompileInfo getCurrentFileCompileInfo() {
        return this.fCurrentFileInstance.getCompileInfo();
    }

    protected HashSet<String> getRemovedKeywordsSet(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        switch (languageSyntax) {
            case VHDL_1076_1987: {
                return this.fRemoved_1076_1987_Set;
            }
            case VHDL_1076_1993: {
                return this.fRemoved_1076_1993_Set;
            }
            case VHDL_1076_1_1999: {
                return this.fRemoved_1076_1_1999_Set;
            }
            case VHDL_1076_2000: {
                return this.fRemoved_1076_2000_Set;
            }
            case VHDL_1076_2002: {
                return this.fRemoved_1076_2002_Set;
            }
            case VHDL_1076_1_2007: {
                return this.fRemoved_1076_1_2007_Set;
            }
            case VHDL_1076_2008: {
                return this.fRemoved_1076_2008_Set;
            }
        }
        return null;
    }

    protected String getLanguageSyntaxName(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        switch (languageSyntax) {
            case VHDL_1076_1987: {
                return "VHDL_1076_1987";
            }
            case VHDL_1076_1993: {
                return "VHDL_1076_1993";
            }
            case VHDL_1076_1_1999: {
                return "VHDL_1076.1_1999";
            }
            case VHDL_1076_2000: {
                return "VHDL_1076_2000";
            }
            case VHDL_1076_2002: {
                return "VHDL_1076_2002";
            }
            case VHDL_1076_1_2007: {
                return "VHDL_1076.1_2007";
            }
            case VHDL_1076_2008: {
                return "VHDL_1076_2008";
            }
        }
        return "VHDL_1076.1_1999";
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return this.fLanguageSyntax;
    }

    public void setLanguageSyntax(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        this.fLanguageSyntax = languageSyntax;
    }

    private final HashSet<String> getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        HashSet<String> removedVhdlKeywords = new HashSet<String>();
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_2007 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2002 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2000 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_1999 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1993 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1987) {
            removedVhdlKeywords.add("assume");
            removedVhdlKeywords.add("assume_guarantee");
            removedVhdlKeywords.add("context");
            removedVhdlKeywords.add("cover");
            removedVhdlKeywords.add("default");
            removedVhdlKeywords.add("fairness");
            removedVhdlKeywords.add("force");
            removedVhdlKeywords.add("parameter");
            removedVhdlKeywords.add("property");
            removedVhdlKeywords.add("release");
            removedVhdlKeywords.add("restrict");
            removedVhdlKeywords.add("restrict_guarantee");
            removedVhdlKeywords.add("sequence");
            removedVhdlKeywords.add("strong");
            removedVhdlKeywords.add("vmode");
            removedVhdlKeywords.add("vprop");
            removedVhdlKeywords.add("vunit");
            removedVhdlKeywords.add("abort");
            removedVhdlKeywords.add("always");
            removedVhdlKeywords.add("async_abort");
            removedVhdlKeywords.add("before");
            removedVhdlKeywords.add("before_");
            removedVhdlKeywords.add("const");
            removedVhdlKeywords.add("clock");
            removedVhdlKeywords.add("countones");
            removedVhdlKeywords.add("eventually!");
            removedVhdlKeywords.add("ended");
            removedVhdlKeywords.add("endpoint");
            removedVhdlKeywords.add("forall");
            removedVhdlKeywords.add("fell");
            removedVhdlKeywords.add("hdltype");
            removedVhdlKeywords.add("inf");
            removedVhdlKeywords.add("inherit");
            removedVhdlKeywords.add("isunknown");
            removedVhdlKeywords.add("never");
            removedVhdlKeywords.add("next_a");
            removedVhdlKeywords.add("next_e");
            removedVhdlKeywords.add("next_event");
            removedVhdlKeywords.add("next_event_a");
            removedVhdlKeywords.add("next_event_e");
            removedVhdlKeywords.add("nondet");
            removedVhdlKeywords.add("nondet_vector");
            removedVhdlKeywords.add("onehot");
            removedVhdlKeywords.add("onehot0");
            removedVhdlKeywords.add("prev");
            removedVhdlKeywords.add("rose");
            removedVhdlKeywords.add("stable");
            removedVhdlKeywords.add("sync_abort");
            removedVhdlKeywords.add("union");
            removedVhdlKeywords.add("until_");
            removedVhdlKeywords.add("X");
            removedVhdlKeywords.add("F");
            removedVhdlKeywords.add("G");
            removedVhdlKeywords.add("U");
            removedVhdlKeywords.add("W");
            removedVhdlKeywords.add("A");
            removedVhdlKeywords.add("AF");
            removedVhdlKeywords.add("AG");
            removedVhdlKeywords.add("AX");
            removedVhdlKeywords.add("E");
            removedVhdlKeywords.add("EF");
            removedVhdlKeywords.add("EG");
            removedVhdlKeywords.add("EX");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2002 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2000 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1993 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1987) {
            removedVhdlKeywords.add("across");
            removedVhdlKeywords.add("break");
            removedVhdlKeywords.add("limit");
            removedVhdlKeywords.add("nature");
            removedVhdlKeywords.add("noise");
            removedVhdlKeywords.add("quantity");
            removedVhdlKeywords.add("spectrum");
            removedVhdlKeywords.add("subnature");
            removedVhdlKeywords.add("terminal");
            removedVhdlKeywords.add("through");
            removedVhdlKeywords.add("tolerance");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_1999 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1993 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1987) {
            removedVhdlKeywords.add("procedural");
            removedVhdlKeywords.add("protected");
            removedVhdlKeywords.add("reference");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_1999) {
            removedVhdlKeywords.remove("procedural");
            removedVhdlKeywords.remove("reference");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1987) {
            removedVhdlKeywords.add("group");
            removedVhdlKeywords.add("impure");
            removedVhdlKeywords.add("inertial");
            removedVhdlKeywords.add("literal");
            removedVhdlKeywords.add("postponed");
            removedVhdlKeywords.add("pure");
            removedVhdlKeywords.add("reject");
            removedVhdlKeywords.add("rol");
            removedVhdlKeywords.add("ror");
            removedVhdlKeywords.add("shared");
            removedVhdlKeywords.add("sla");
            removedVhdlKeywords.add("sll");
            removedVhdlKeywords.add("sra");
            removedVhdlKeywords.add("srl");
            removedVhdlKeywords.add("unaffected");
            removedVhdlKeywords.add("xnor");
        }
        return removedVhdlKeywords;
    }

    protected void notifyParsingListeners(IParsingInfo e) {
        for (IParsingListener l : this.fParsingListeners) {
            l.parsing(e);
        }
    }

    protected void debug(Object ... s) {
        if (fDebugMode) {
            Object[] sl = Arrays.asList(s).toArray();
            StringBuilder sb = new StringBuilder(DEBUG_PREFIX);
            int i = 0;
            while (i < sl.length) {
                sb.append(sl[i].toString());
                ++i;
            }
            TestHelper.out.println(sb.toString());
        }
    }

    protected void setDebugMode() {
        fDebugMode = true;
    }

    public void addComment(ParserPath parserPath, int line, Comment comment) {
        this.fCurrentFileInstance.addComment(comment, line, fCommentsPreferences);
    }

    public CommentBlock getHeaderCommentBlock(ParserPath parserPath, int startLine) {
        String commentString;
        if (parserPath == null) {
            return null;
        }
        List<VhdlFileInstance> fileInstances = this.fFileInstancesMap.getFileInstances(parserPath);
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        VhdlFileInstance fileInstance = fileInstances.get(0);
        if (fileInstance == null) {
            return null;
        }
        CommentsTable comments = fileInstance.getComments();
        if (comments == null) {
            return null;
        }
        StringBuilder commentSB = new StringBuilder();
        int firstLineOfAboveComment = -1;
        int glueLine = 0;
        int line = 1;
        while (line < startLine) {
            Comment commentLine = comments.get(line);
            if (Comment.isComment((Comment)commentLine) && !Comment.isVhdlLibraryClause((Comment)commentLine)) {
                int commentStartLine = commentLine.getStartLine();
                int commentEndLine = commentLine.getEndLine();
                if (commentStartLine != 1 && commentStartLine != 2 && commentStartLine != glueLine + 1) break;
                glueLine = commentEndLine;
                comments.remove(line);
                commentSB.append(commentLine.getRawComment()).append('\n');
                if (firstLineOfAboveComment < 0) {
                    firstLineOfAboveComment = commentStartLine;
                }
            }
            ++line;
        }
        if ((commentString = commentSB.toString()).isEmpty()) {
            return null;
        }
        return new CommentBlock(null, commentString, firstLineOfAboveComment, false);
    }

    public void newLine(ParserPath parserPath, int line) {
        this.addComment(parserPath, line, Comment.EMPTY_LINE_INFO);
    }

    public void nextTokenLine(ParserPath parserPath, int line) {
        this.addComment(parserPath, line, Comment.CODE_LINE_INFO);
    }

    public CommentBlock getCommentAtLine(ParserPath parserPath, int startLine, boolean addAbove, boolean addInline, boolean addHeader) {
        CommentBlock result = this.getCommentAtLine(parserPath, startLine, 0, addAbove, startLine, addInline);
        if (!(addHeader &= fCommentsPreferences.getUseHeaderComment())) {
            return result;
        }
        CommentBlock headerCommentBlock = this.getHeaderCommentBlock(parserPath, startLine);
        if (headerCommentBlock == null) {
            return result;
        }
        if (result == null) {
            return headerCommentBlock;
        }
        result.setHeaderComment(headerCommentBlock.getRawAboveComment());
        return result;
    }

    public CommentBlock getCommentAtLine(ParserPath parserPath, int startLine, boolean addAbove, boolean addInline) {
        return this.getCommentAtLine(parserPath, startLine, 0, addAbove, startLine, addInline);
    }

    private final CommentBlock getCommentAtLine(ParserPath parserPath, int startLine, int upperLineLimit, boolean addAbove, int endLine, boolean addInline) {
        if (parserPath == null) {
            return null;
        }
        int currentLine = startLine;
        List<VhdlFileInstance> fileInstances = this.fFileInstancesMap.getFileInstances(parserPath);
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        VhdlFileInstance fileInstance = fileInstances.get(0);
        if (fileInstance == null) {
            return null;
        }
        CommentsTable comments = fileInstance.getComments();
        if (comments == null) {
            return null;
        }
        if (!(addAbove &= fCommentsPreferences.getUseAboveComment()) && !(addInline &= fCommentsPreferences.getUseInlineComment())) {
            return null;
        }
        boolean isProtected = false;
        Comment protectedFlag = comments.get(startLine);
        if (Comment.isVhdlComment((Comment)protectedFlag)) {
            isProtected = protectedFlag.isProtected();
        }
        Comment commentInline = null;
        if (addInline) {
            commentInline = comments.get(endLine);
            comments.remove(endLine);
        }
        if (!addAbove) {
            if (commentInline == null || !Comment.isVhdlComment((Comment)commentInline)) {
                return null;
            }
            return new CommentBlock(commentInline.getRawComment(), null, -1, isProtected);
        }
        Comment commentAbove = comments.get(--currentLine);
        while (Comment.isVhdlLibraryClause((Comment)commentAbove) || Comment.isEmptyLine((Comment)commentAbove) && currentLine > upperLineLimit && currentLine > startLine - 1 - fCommentsPreferences.getEmptyLinesAboveToSkip()) {
            commentAbove = comments.get(--currentLine);
        }
        if (!Comment.isVhdlComment((Comment)commentAbove) || commentAbove.isInline()) {
            comments.remove(currentLine);
            if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
                return null;
            }
            return new CommentBlock(commentInline.getRawComment(), null, -1, isProtected);
        }
        if (commentAbove.getKind() == Comment.CommentStyle.ML_KIND || commentAbove.getKind() == Comment.CommentStyle.ML2_KIND) {
            comments.remove(currentLine);
            if (commentInline == null || !Comment.isVhdlComment((Comment)commentInline)) {
                return new CommentBlock(null, commentAbove.getRawComment(), commentAbove.getStartLine(), isProtected);
            }
            return new CommentBlock(commentInline.getRawComment(), commentAbove.getRawComment(), commentAbove.getStartLine(), isProtected);
        }
        StringBuilder result = new StringBuilder("");
        int endCommentLine = currentLine;
        int startCommentLine = currentLine;
        while (commentAbove.getKind() == Comment.CommentStyle.SL_KIND) {
            commentAbove = comments.get(--startCommentLine);
            if (startCommentLine > upperLineLimit && Comment.isComment((Comment)commentAbove) && !commentAbove.isInline() && commentAbove.getKind() == Comment.CommentStyle.SL_KIND) continue;
            ++startCommentLine;
            break;
        }
        int i = startCommentLine;
        while (i < endCommentLine + 1) {
            commentAbove = comments.get(i);
            comments.remove(i);
            result.append(commentAbove.getRawComment()).append('\n');
            ++i;
        }
        if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
            return new CommentBlock(null, result.toString(), startCommentLine, isProtected);
        }
        return new CommentBlock(commentInline.getRawComment(), result.toString(), startCommentLine, isProtected);
    }

    public static String getNonStandardSeverity() {
        return "*** Warning: ";
    }

    public static String getNonStandardMessage(RfNonStandardProblem problem, Object ... arguments) {
        return problem.getID() + problem.name() + ": " + problem.getMessage(arguments);
    }

    public void removeComments() {
        this.fCurrentFileInstance.cleanAllComments(true);
    }

    public RfProject getRfProject() {
        return this.fCurrentFileInstance.getRfProject();
    }

    public void setInterrupt(boolean interupt) {
        this.fInterrupt = interupt;
    }

    public boolean getInterrupt() {
        return this.fInterrupt;
    }

    protected final void setEncryptedFile(String parserPath, boolean encrypted) {
        this.fEncryptedTableMap.put(new ParserPath(parserPath), encrypted);
    }

    public boolean isEncrypted(ParserPath parserPath) {
        if (this.fEncryptedTableMap.containsKey(parserPath)) {
            return this.fEncryptedTableMap.get(parserPath);
        }
        return false;
    }

    protected final void setCustomPragmas(List<CustomPragma> customPragmas) {
        if (customPragmas == null) {
            return;
        }
        this.fStartPragmas = new HashMap<String, CustomPragma>();
        this.fEndPragmas = new HashMap<String, CustomPragma>();
        this.fCustomPragmaFirstIdentifiers = new HashSet<String>();
        for (CustomPragma pragma : customPragmas) {
            if (!pragma.isEnabled() || pragma.isOverriden()) continue;
            this.fStartPragmas.put(pragma.getStartPragma(), pragma);
            this.fEndPragmas.put(pragma.getEndPragma(), pragma);
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier((String)pragma.getStartPragma()));
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier((String)pragma.getEndPragma()));
        }
    }

    protected final String processComment(String comment) {
        if (this.fStartPragmas == null || this.fEndPragmas == null || this.fStartPragmas.isEmpty() || this.fEndPragmas.isEmpty() || comment == null) {
            return null;
        }
        return DVTStringUtil.collapseWhitespaces((String)comment);
    }

    protected final CustomPragma getStartCustomPragma(String processedComment) {
        if (this.fStartPragmas == null || processedComment == null) {
            return null;
        }
        return this.fStartPragmas.get(processedComment);
    }

    protected final CustomPragma getEndCustomPragma(String processedComment) {
        if (this.fEndPragmas == null || processedComment == null) {
            return null;
        }
        return this.fEndPragmas.get(processedComment);
    }

    protected final boolean isCustomPragmaFirstIdentifier(String firstIdentifier) {
        if (this.fCustomPragmaFirstIdentifiers == null || firstIdentifier == null) {
            return false;
        }
        return this.fCustomPragmaFirstIdentifiers.contains(firstIdentifier);
    }

    public void addCustomPragmaUsage(CustomPragmaUsage pragma) {
        this.fCurrentFileInstance.addCustomPragma(pragma);
    }

    protected final void setTranslatePragmas(Set<String> translatePragmas) {
        this.fTranslatePragmas = translatePragmas;
    }

    protected final String getTranslateUsingPragma(String identifier, String comment) {
        if (this.fTranslatePragmas == null) {
            return comment;
        }
        if (this.fTranslatePragmas.contains(identifier)) {
            return comment.substring(identifier.length()).trim();
        }
        return comment;
    }

    protected void setMaxIssuesKindPerFile(int maxNumber) {
        this.MAX_ISSUE_KIND_PER_FILE = maxNumber;
    }

    protected final void setTaskTagsProperties(Set<String> taskNames, boolean caseSensitive, boolean hideTaskName) {
        if (caseSensitive) {
            this.fTaskNames = taskNames;
        } else if (taskNames == null) {
            this.fTaskNames = null;
        } else {
            this.fTaskNames = new HashSet<String>();
            for (String taskName : taskNames) {
                this.fTaskNames.add(taskName.toUpperCase());
            }
        }
        this.fTaskNamesCaseSensitive = caseSensitive;
        this.fHideTaskName = hideTaskName;
    }

    public void collectTaskTag(String firstIdentifier, String comment, int line, int offsetStart, int offsetEnd, ParserPath parserPath) {
        try {
            if (this.fTaskNames == null || firstIdentifier == null) {
                return;
            }
            int commentStartWithNewLine = comment.indexOf(firstIdentifier);
            int index = 0;
            while (index < commentStartWithNewLine) {
                if (comment.charAt(index) == '\n') {
                    ++line;
                    break;
                }
                ++index;
            }
            String commentToScan = comment;
            int commentLength = commentToScan.length();
            int i = 0;
            while (i < commentLength) {
                char ch = commentToScan.charAt(i);
                while (!Character.isJavaIdentifierPart(ch)) {
                    if (ch == '\n') {
                        ++line;
                    }
                    if (i >= commentLength - 1) {
                        return;
                    }
                    ch = commentToScan.charAt(++i);
                }
                StringBuilder possibleTaskTag = new StringBuilder();
                int startIndex = i;
                while (Character.isJavaIdentifierPart(ch)) {
                    possibleTaskTag.append(ch);
                    if (i == commentLength - 1) {
                        this.checkAndExtractPossibleTaskTag(line, parserPath, commentToScan, i, possibleTaskTag, startIndex, offsetStart);
                        return;
                    }
                    ch = commentToScan.charAt(++i);
                }
                i = this.checkAndExtractPossibleTaskTag(line, parserPath, commentToScan, i, possibleTaskTag, startIndex, offsetStart);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int checkAndExtractPossibleTaskTag(int line, ParserPath parserPath, String commentToScan, int currentIndex, StringBuilder possibleTaskTag, int startIndex, int offsetStart) {
        String taskTagCandidate;
        int possLength = possibleTaskTag.length();
        if (possLength >= 1 && !Character.isJavaIdentifierPart(possibleTaskTag.charAt(possLength - 1))) {
            possibleTaskTag = possibleTaskTag.deleteCharAt(possLength - 1);
        }
        String string = taskTagCandidate = this.fTaskNamesCaseSensitive ? possibleTaskTag.toString() : possibleTaskTag.toString().toUpperCase();
        if (this.fTaskNames.contains(taskTagCandidate)) {
            List<TaskInfoWrapper> taskTable;
            String commentToDisplay = commentToScan.substring(startIndex, Math.min(startIndex + 200, commentToScan.length()));
            commentToDisplay = DVTFileUtils.getInstance().cropFirstLine(commentToDisplay, 100);
            int newLineIndex = commentToScan.indexOf(10, currentIndex += commentToDisplay.length() - taskTagCandidate.length() - 1);
            if (newLineIndex > 0) {
                currentIndex = newLineIndex;
            }
            if ((taskTable = this.getTasks(parserPath)).size() < 100) {
                int length = commentToDisplay.length();
                commentToDisplay = DVTFileUtils.getInstance().displayUpperCaseTaskTag(this.fTaskNamesCaseSensitive, this.fHideTaskName, commentToDisplay, taskTagCandidate);
                int taskTagStartOffset = offsetStart + startIndex;
                TaskInfoWrapper taskInfoWrapper = new TaskInfoWrapper(taskTagCandidate, line, taskTagStartOffset, taskTagStartOffset + length, commentToDisplay);
                taskTable.add(taskInfoWrapper);
            }
        }
        return currentIndex;
    }
}

