/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.r2lparser;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;

public class MethodObjectVisitor
implements IHidVisitor<IHidObject> {
    private int documentOffset;
    private int prefixLength;
    private IHidObject found;

    public MethodObjectVisitor(int documentOffset, int prefixLength) {
        this.documentOffset = documentOffset;
        this.prefixLength = prefixLength;
    }

    public boolean visit(IHidObject obj) {
        if (obj instanceof RfHid) {
            IHidObject access = this.testHid((RfHid)obj);
            if (access != null) {
                this.found = access;
            }
            return this.found == null;
        }
        if (obj instanceof RfHidOperator) {
            final ArrayList collected = new ArrayList(4);
            Predicate<IHidObject> cons = new Predicate<IHidObject>(){

                @Override
                public boolean test(IHidObject element) {
                    if (element instanceof RfHidAccess && ((RfHidAccess)element).isMethodCall(false)) {
                        collected.add(((RfHidAccess)element).getParentHid());
                    } else if (element instanceof RfHid && ((RfHid)element).isMethodCall(false)) {
                        collected.add((RfHid)element);
                    }
                    return true;
                }
            };
            HidUtils.flattenToObjects((Predicate)cons, (IHidObject)obj, (Set)HidFlatteningOption.NONE_EXCLUDED);
            if (collected.isEmpty()) {
                return true;
            }
            for (Hid coll : collected) {
                IHidObject methodObj = this.testHid(coll);
                if (methodObj == null) continue;
                this.found = methodObj;
                return false;
            }
        }
        return true;
    }

    private IHidObject testHid(Hid obj) {
        HidOccurrence occurrence;
        if (!obj.isMethodCall(false)) {
            return null;
        }
        if (obj.hasAccesses()) {
            ListContainer accesses = obj.getAccesses();
            for (HidAccess currAccess : accesses) {
                HidOccurrence occurrence2;
                Region region;
                boolean inRegion;
                if (!(currAccess instanceof RfHidAccess) || !((RfHidAccess)currAccess).isMethodCall(false) || !(inRegion = DVTDocumentUtils.regionContains((IRegion)(region = new Region((occurrence2 = ((RfHidAccess)currAccess).getOccurrence()).getOffset(), obj.getName().length())), (int)this.documentOffset))) continue;
                return currAccess;
            }
        }
        if ((occurrence = obj.getOccurrence()) == null) {
            return null;
        }
        Region region = new Region(occurrence.getOffset(), this.prefixLength);
        boolean inRegion = DVTDocumentUtils.regionContains((IRegion)region, (int)this.documentOffset);
        if (inRegion) {
            return obj;
        }
        return null;
    }

    public IHidObject getFound() {
        return this.found;
    }

    public void setFound(IHidObject methodObj) {
        this.found = methodObj;
    }

    public Class<IHidObject> getType() {
        return IHidObject.class;
    }
}

