/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.r2lparser;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;

public class R2LCaseForEnumElement
extends RfNamedElement {
    private static final long serialVersionUID = 1L;
    private static final String SIGNATURE_HEADER_FORMAT = "Insert complete CASE statement for \"{0}\" of type \"{1}\"\n";
    private static final String CASE_FORMAT = "case {0} is\n";
    private static final String WHEN_FORMAT = "{0}{1}when {2} => {3}{0}{1}{1}";
    private static final String COMMENT_FORMAT = "-- TODO: Handle {0} state{1}{1}";
    private static final String END_CASE_FORMAT = "{0}end case;{1}";
    private List<RfEnum> enums;
    private String variableName;
    private String enumType;
    private int cursorPosition = 0;

    public R2LCaseForEnumElement(List<RfEnum> enums, String candidateName, String enumType) {
        super(candidateName);
        this.variableName = candidateName;
        this.enums = enums;
        this.enumType = enumType;
    }

    public List<RfEnum> getEnums() {
        return this.enums;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public String getContextType() {
        return null;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public String getReplacementString(String lineOffset, String lineDelimiter, String tab) {
        String result = String.valueOf(this.variableName) + " is" + lineDelimiter;
        int i = 0;
        while (i < this.enums.size()) {
            result = String.valueOf(result) + MessageFormat.format(WHEN_FORMAT, lineOffset, tab, this.enums.get(i).getName(), lineDelimiter);
            if (i == 0) {
                this.cursorPosition = result.length();
            }
            result = String.valueOf(result) + MessageFormat.format(COMMENT_FORMAT, this.enums.get(i).getName(), lineDelimiter);
            ++i;
        }
        result = String.valueOf(result) + MessageFormat.format(WHEN_FORMAT, lineOffset, tab, "others", lineDelimiter);
        result = String.valueOf(result) + MessageFormat.format(COMMENT_FORMAT, "others", lineDelimiter);
        result = String.valueOf(result) + MessageFormat.format(END_CASE_FORMAT, lineOffset, lineDelimiter);
        return result;
    }

    public String getSignature() {
        String preview = MessageFormat.format(SIGNATURE_HEADER_FORMAT, this.variableName, this.enumType);
        preview = String.valueOf(preview) + MessageFormat.format(CASE_FORMAT, this.variableName);
        for (RfEnum enumerated : this.enums) {
            preview = String.valueOf(preview) + MessageFormat.format(WHEN_FORMAT, "", "\t", enumerated.getName(), "\n");
            preview = String.valueOf(preview) + MessageFormat.format(COMMENT_FORMAT, enumerated.getName(), "\n");
        }
        preview = String.valueOf(preview) + MessageFormat.format(WHEN_FORMAT, "", "\t", "others", "\n");
        preview = String.valueOf(preview) + MessageFormat.format(COMMENT_FORMAT, "others", "\n");
        preview = String.valueOf(preview) + MessageFormat.format(END_CASE_FORMAT, "", "\n");
        return preview;
    }

    @Override
    public String getName() {
        return "CASE " + this.variableName + " : " + this.enumType;
    }

    @Override
    public Image getImage() {
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        ImageDescriptor imageDescriptor = fieldDecoration != null ? ImageDescriptor.createFromImage((Image)fieldDecoration.getImage()) : null;
        Image result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
        return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, imageDescriptor, 1));
    }
}

