/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.r2lparser;

import java.util.Collection;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.util.MaxNofItemsReached;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class R2LFilteredList<E>
extends NullProtectedList<E> {
    private static final long serialVersionUID = 1L;
    private Predicate<? super E> defaultFilter;

    public R2LFilteredList(int initialCapacity) {
        this(false, initialCapacity);
    }

    public R2LFilteredList() {
        this(false);
    }

    public R2LFilteredList(boolean checkDuplicateNamedElement) {
        super(checkDuplicateNamedElement);
    }

    public R2LFilteredList(boolean checkDuplicateNamedElement, int initialCapacity) {
        super(checkDuplicateNamedElement, initialCapacity);
    }

    public R2LFilteredList(Collection<E> values) {
        super(values);
    }

    public R2LFilteredList(boolean checkDuplicateNamedElement, int initialCapacity, Predicate<? super E> defaultFilter) {
        super(checkDuplicateNamedElement, initialCapacity);
        this.defaultFilter = defaultFilter;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) throws MaxNofItemsReached {
        return this.addAll(c, null);
    }

    public boolean addAll(Collection<? extends E> c, Predicate<? super E> filter) throws MaxNofItemsReached {
        if (c == null) {
            return false;
        }
        boolean atLeastOneAddition = false;
        for (E e : c) {
            if (e == null) continue;
            if (this.fMaxNofItemsReached != null && this.fMaxNofItems > 0 && this.size() >= this.fMaxNofItems) {
                throw this.fMaxNofItemsReached;
            }
            if (!this.testDefaultFilter(e) || filter != null && !filter.test(e)) continue;
            if (this.fNamesSet != null) {
                this.fNamesSet.add(e.toString());
            }
            super.add(e);
            atLeastOneAddition = true;
        }
        return atLeastOneAddition;
    }

    @Override
    public boolean add(E e) throws MaxNofItemsReached {
        return this.add(e, null);
    }

    public boolean add(E e, Predicate<? super E> filter) throws MaxNofItemsReached {
        if (e == null) {
            return false;
        }
        if (this.fMaxNofItemsReached != null && this.fMaxNofItems > 0 && this.size() >= this.fMaxNofItems) {
            throw this.fMaxNofItemsReached;
        }
        if (!this.testDefaultFilter(e)) {
            return false;
        }
        if (filter != null && !filter.test(e)) {
            return false;
        }
        if (this.fNamesSet != null) {
            this.fNamesSet.add(e.toString());
        }
        return super.add(e);
    }

    @Override
    public void addAllNoDuplicateNamedElement(Collection<? extends E> c) throws MaxNofItemsReached {
        this.addAllNoDuplicateNamedElement(c, null);
    }

    public void addAllNoDuplicateNamedElement(Collection<? extends E> c, Predicate<? super E> filter) throws MaxNofItemsReached {
        if (c == null) {
            return;
        }
        if (this.fNamesSet == null) {
            return;
        }
        for (E e : c) {
            if (e == null || this.fNamesSet.contains(e.toString())) continue;
            if (this.fMaxNofItemsReached != null && this.fMaxNofItems > 0 && this.size() >= this.fMaxNofItems) {
                throw this.fMaxNofItemsReached;
            }
            if (!this.testDefaultFilter(e) || filter != null && !filter.test(e)) continue;
            this.fNamesSet.add(e.toString());
            super.add(e);
        }
    }

    private boolean testDefaultFilter(E e) {
        if (this.defaultFilter == null) {
            return true;
        }
        return this.defaultFilter.test(e);
    }

    public Predicate<? super E> getDefaultFilter() {
        return this.defaultFilter;
    }
}

