/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.r2lparser;

import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;

public class R2LFilters {
    public static final Predicate<IRfNamedElement> keepFunctions = elem -> elem instanceof RfFunction;
    public static final Predicate<IRfNamedElement> rejectFunctions = keepFunctions.negate();
    public static final Predicate<IRfNamedElement> keepOperatorFunctions = elem -> {
        if (!(elem instanceof RfFunction)) {
            return false;
        }
        RfFunction function = (RfFunction)elem;
        return RfFunction.PREDEFINED_OPERATORS.contains(function.getName().toLowerCase());
    };
    public static final Predicate<IRfNamedElement> rejectOperatorFunctions = keepOperatorFunctions.negate();
    public static final Predicate<IRfNamedElement> keepQuotedFunctions = elem -> {
        if (!(elem instanceof RfFunction)) {
            return false;
        }
        RfFunction function = (RfFunction)elem;
        String functionName = function.getName();
        if (functionName == null) {
            return false;
        }
        return functionName.startsWith("\"");
    };
    public static final Predicate<IRfNamedElement> rejectQuotedFunctions = keepQuotedFunctions.negate();
    public static final Predicate<IRfNamedElement> keepDVTStandardTypes = elem -> {
        String lowerCaseCustomName = elem instanceof RfNamedElement ? ((RfNamedElement)elem).getCustomName().toLowerCase() : "";
        String lowerCaseName = elem.getName().toLowerCase();
        return lowerCaseCustomName.contains("dvt81b441bd_") || lowerCaseName.contains("dvt81b441bd_");
    };
    public static final Predicate<IRfNamedElement> rejectDVTStandardTypes = keepDVTStandardTypes.negate();
    private static final int DEFAULT_MAX_SIZE = 50;

    public static IRfElementFilter toFilter(final Predicate<IRfNamedElement> condition) {
        return new IRfElementFilter(){

            public boolean allowEnumElement() {
                return true;
            }

            public int resultMaxSize() {
                return 50;
            }

            public boolean validElement(IRfNamedElement candidate) {
                return condition.test(candidate);
            }
        };
    }
}

