/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.r2lparser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVUnit;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.r2lparser.R2LFilters;
import ro.amiq.vhdldt.r2lparser.R2LResultContainer;
import ro.amiq.vhdldt.r2lparser.R2LScopeContainer;

public abstract class R2LManager {
    public static final int UNDEF_ACCESS = -1;
    public static final int DOT_ACCESS = 0;
    public static final int COLON_ACCESS = 1;
    public static final int ARGUMENT_ACCESS = 4;
    public static final int FUNCTION_NAME = 1;
    public static final int RETURN_NAME = 2;
    public static final int PACKAGE_INSTANTIATION = 0;
    public static final int FUNCTION_INSTANTIATION = 1;
    public static final int PROCEDURE_INSTANTIATION = 2;
    protected IRfScope fInitialScope;
    protected IDocument fDocument;
    protected int fScopeOffset;
    protected int fDocumentOffset;
    protected int fDocumentLine;
    protected RfProject fRfProject;
    protected boolean fIgnoreCase;
    protected boolean fHasParams = false;
    protected RfFileDef fFileDef;
    private static final Pattern TO_DOWNTO = Pattern.compile("\\W(down)?to\\W", 2);

    public R2LManager(RfProject rfProject, IRfScope initialScope, IResource file, IDocument document, int documentOffset, int scopeOffset) {
        try {
            this.fIgnoreCase = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.ignore_case");
            this.fFileDef = rfProject.getFile(file);
            this.fInitialScope = initialScope;
            this.fDocument = document;
            this.fScopeOffset = scopeOffset;
            this.fDocumentOffset = documentOffset;
            this.fRfProject = rfProject;
            this.fDocumentLine = this.fDocument.getLineOfOffset(documentOffset) + 1;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public abstract R2LResultContainer getProposals();

    public abstract List<RfWNamedElementAndScope> getElements();

    public R2LScopeContainer getScope(R2LScopeContainer scopeContainer, int accessKind, String name, List<String> selects) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            if (accessKind == 4) {
                if (scopeContainer == null) {
                    scopeContainer = new R2LScopeContainer(this.fInitialScope);
                    scopeContainer.path = new ArrayList<String>();
                } else {
                    scopeContainer.scope = this.fInitialScope;
                }
            } else {
                return null;
            }
        }
        R2LScopeContainer result = new R2LScopeContainer(scopeContainer);
        if (this.isNumber(name)) {
            result.isNumber = true;
            return result;
        }
        result.scope = null;
        if (selects != null) {
            this.fHasParams = true;
        }
        NullProtectedList<RfNamedElement> candidates = new NullProtectedList<RfNamedElement>();
        Map<String, IRfNamedElement> genericMap = null;
        IRfScope scope = null;
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (scopeElement == null) {
            scopeElement = this.fInitialScope;
        }
        if (!(scopeElement instanceof IRfScope)) {
            if (scopeElement instanceof IRfLibraryElement) {
                IRfElementFilter iRfElementFilter = R2LFilters.toFilter(candidate -> candidate instanceof IRfPackageElement);
                scopeElement.getElementsWithPrefix(candidates, name, 1, 1, false, IRfNamedElement.AccessModifier.SHOW_PUBLIC, iRfElementFilter);
            } else if (scopeElement instanceof IRfDesignElement) {
                candidates.addAll(((IRfDesignElement)scopeElement).getLocalInstancesWithPrefix(name, 1));
            }
        } else {
            IRfNamedElement scopeTmp;
            scope = (IRfScope)scopeElement;
            RfNamedElement rfNamedElement = this.fInitialScope.getNamedElement();
            if (rfNamedElement != null) {
                genericMap = rfNamedElement.getResolvedGenericMap(true);
            }
            if (scopeContainer.genericMap != null && !scopeContainer.genericMap.isEmpty()) {
                genericMap = scopeContainer.genericMap;
            }
            if (scopeContainer.path == null || scopeContainer.path.isEmpty() || accessKind == 4) {
                IRfLibraryElement library;
                RfNamedElement tempScope = scope.getNamedElement();
                if (scope instanceof RfFileDef) {
                    tempScope = ((RfFileDef)scope).getEnclosingLibrary();
                }
                if (tempScope != null && (library = tempScope.getLibraryAndWork(name)) != null) {
                    result.scope = library;
                    return result;
                }
            }
            if (rfNamedElement instanceof RfInstance && (scopeTmp = ((RfInstance)rfNamedElement).getAssociatedType()) instanceof IRfScope) {
                scope = (IRfScope)scopeTmp;
            }
            candidates.addAll(scope.getPackagesWithPrefix(name, 1));
            candidates.addAll(scope.getVariablesWithPrefix(name, 1, false));
            candidates.addAll(scope.getBlocksWithPrefix(name, 1, false));
            candidates.addAll(scope.getComponentsWithPrefix(name, 1, false));
            candidates.addAll(scope.getEnumsWithPrefix(name, 1));
            candidates.addAll(scope.getProcessesWithPrefix(name, 1));
            candidates.addAll(scope.getFunctionsWithPrefix(name, 1, false));
            candidates.addAll(scope.getConfigurationsWithPrefix(name, 1));
            candidates.addAll(scope.getPortsWithPrefix(name, 1, false));
            candidates.addAll(scope.getArchitecturesWithPrefix(name, 1));
            candidates.addAll(scope.getEntitiesWithPrefix(name, 1));
            candidates.addAll(scope.getInstancesWithPrefix(name, 1, false));
            candidates.addAll(scope.getVUnitsWithPrefix(name, 1));
            candidates.addAll(scope.getDesignsWithPrefix(name, 1));
            candidates.addAll(scope.getTypesWithPrefix(name, 1, false));
            if (candidates.isEmpty()) {
                candidates.addAll(this.fRfProject.getMixedLangProjectParent().getLibrariesWithPrefix((IRfSingleLangProject)this.fRfProject, name, 9));
            }
            if (candidates.isEmpty()) {
                if (scope instanceof RfLibrary) {
                    Iterator iterator;
                    RfLibrary workLib;
                    List scopeCandidates = this.fRfProject.getMixedLangProjectParent().getLibrariesWithPrefix((IRfSingleLangProject)this.fRfProject, scope.getName(), 1);
                    String defLib = "work";
                    if (scopeContainer.path != null && !scopeContainer.path.isEmpty() && defLib.equalsIgnoreCase(scopeContainer.path.get(0)) && scopeElement instanceof RfLibrary && !defLib.equalsIgnoreCase(scopeElement.getName()) && (workLib = ((RfLibrary)scopeElement).getLibraryWithPrefix(defLib, 9)) != null) {
                        scopeCandidates.add(workLib);
                    }
                    if ((iterator = scopeCandidates.iterator()).hasNext()) {
                        IRfLibraryElement scopeCandidate = (IRfLibraryElement)iterator.next();
                        IRfPackageElement candidate2 = scopeCandidate.getPackageWithPrefix(name, 1);
                        if (candidate2 != null) {
                            result.scope = candidate2;
                        }
                        return result;
                    }
                }
                return null;
            }
        }
        for (IRfNamedElement iRfNamedElement : candidates) {
            if (iRfNamedElement instanceof RfType || iRfNamedElement instanceof IRfLibraryElement || iRfNamedElement instanceof IRfPackageElement || iRfNamedElement instanceof RfVUnit) {
                result.scope = iRfNamedElement;
                break;
            }
            IRfNamedElement associatedType = null;
            if (iRfNamedElement instanceof IRfDesignElement) {
                associatedType = iRfNamedElement;
            } else if (iRfNamedElement instanceof IRfInstanceElement) {
                associatedType = ((IRfInstanceElement)iRfNamedElement).getGenericDesign(null);
            } else if (iRfNamedElement instanceof RfAssociatedType) {
                associatedType = ((RfAssociatedType)iRfNamedElement).getAssociatedType();
                genericMap = RfNamedElement.updateGenericMap(associatedType, genericMap, true);
            } else if (scope != null) {
                String typeName;
                String string = typeName = iRfNamedElement instanceof RfAssociatedType ? ((RfAssociatedType)iRfNamedElement).getAssociatedTypeName() : null;
                if (typeName == null || (associatedType = scope.getTypeWithPrefix(typeName, 1, false)) == null) continue;
            }
            HashSet<IRfNamedElement> visited = new HashSet<IRfNamedElement>();
            while (associatedType instanceof RfType && (((RfType)associatedType).isAccess() || ((RfType)associatedType).isSubtype() || ((RfType)associatedType).isGeneric()) || associatedType instanceof IRfTypeAliasElement) {
                if (visited.contains(associatedType)) {
                    return null;
                }
                visited.add(associatedType);
                associatedType = associatedType instanceof IRfTypeAliasElement ? ((IRfTypeAliasElement)associatedType).getTranslatedType() : ((IRfAssociatedType)associatedType).getAssociatedTypeWithGenericMap(genericMap);
                genericMap = RfNamedElement.updateGenericMap(associatedType, genericMap, true);
            }
            result.scope = associatedType;
            result.genericMap = genericMap;
            if (selects == null) break;
            for (String select : selects) {
                if (select == null || TO_DOWNTO.matcher(select).find() || !(result.scope instanceof RfAssociatedType) && !(result.scope instanceof RfListType)) continue;
                result.scope = ((IRfAssociatedType)result.scope).getAssociatedType();
                if (!(result.scope instanceof RfType) || !((RfType)result.scope).isAccess() && !((RfType)result.scope).isSubtype()) continue;
                result.scope = ((RfType)result.scope).getAssociatedType();
            }
        }
        return result;
    }

    public R2LScopeContainer getOtherLanguageScope(R2LScopeContainer scopeContainer, String name, String[] params) {
        IRfLibraryElement candidate;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        R2LScopeContainer result = new R2LScopeContainer(scopeContainer);
        if (this.isNumber(name)) {
            result.isNumber = true;
            return result;
        }
        result.scope = null;
        if (params != null) {
            this.fHasParams = true;
        }
        if ((candidate = this.fRfProject.getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)this.fRfProject, name, 1)) == null) {
            return null;
        }
        result.scope = candidate;
        return result;
    }

    protected boolean isNumber(String name) {
        if (name.length() > 2 && name.charAt(0) == '\'') {
            name = name.substring(2);
        }
        return DVTStringUtil.isNumber((String)name);
    }

    public abstract IRfNamedElement[] getEnumCandidates(R2LScopeContainer var1, List<String> var2, String var3);

    public abstract IRfNamedElement[] getEnumCandidates(R2LScopeContainer var1, String var2);

    public abstract IRfNamedElement[] getTypeCandidates(R2LScopeContainer var1, String var2, String var3);

    public abstract IRfNamedElement[] getExprCandidates(R2LScopeContainer var1, R2LScopeContainer var2, int var3, String var4, boolean var5);

    public abstract IRfNamedElement[] getUseCandidates(R2LScopeContainer var1, String var2, boolean var3, boolean var4);

    public abstract RfNamedElement[] getSeverityCandidates(R2LScopeContainer var1, String var2);

    public abstract RfNamedElement[] getAttributesCandidates(String var1);

    public abstract RfNamedElement[] getEndCandidates(R2LScopeContainer var1, String var2);

    public abstract IRfNamedElement[] getMappingCandidates(R2LScopeContainer var1, String var2, String var3, List<String> var4, boolean var5);

    public abstract IRfNamedElement[] getFuncArgCandidates(R2LScopeContainer var1, String var2, String var3);

    public abstract IRfNamedElement[] getPackageInstantiationCandidates(R2LScopeContainer var1, int var2, String var3);

    public abstract IRfNamedElement[] getEntityCandidates(R2LScopeContainer var1, String var2);

    public abstract IRfNamedElement[] getCaseCandidates(R2LScopeContainer var1, int var2, String var3);

    public abstract IRfNamedElement[] getEntityOrComponentCandidates(R2LScopeContainer var1, String var2, boolean var3);
}

