/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.r2lparser;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.r2lparser.R2LToken;

public class R2LTokenizer
implements TokenStream {
    private IDocumentExtension3 fDocument;
    private int fInitialOffset;
    private DVTCharacterScanner fScanner;
    private boolean fFirstToken = true;
    private Map<String, Integer> fTokensMap = new HashMap<String, Integer>();
    private boolean fIsMethodProposal;
    private boolean fIsFollowedByGT;
    private boolean fIgnoreWhen;
    private boolean fIgnoreReturn;
    private boolean fStopTokenizer;
    private char fCharAtLeftOfStartOfset;
    private int fIsRightOrLeftPort = -1;

    public R2LTokenizer(IDocument document, int offset, boolean enableLeftScan) {
        this.fDocument = (IDocumentExtension3)document;
        this.fInitialOffset = this.adjustTooltipOffset(document, enableLeftScan, offset);
        if (this.fInitialOffset < 0) {
            return;
        }
        this.fScanner = new DVTCharacterScanner(100, document, Math.max(0, this.fInitialOffset - 1), false);
        this.fStopTokenizer = false;
        this.fTokensMap.put("if", 110);
        this.fTokensMap.put("elsif", 111);
        this.fTokensMap.put("when", 112);
        this.fTokensMap.put("not", 115);
        this.fTokensMap.put("is", 118);
        this.fTokensMap.put("case", 120);
        this.fTokensMap.put("end", 119);
        this.fTokensMap.put("in", 114);
        this.fTokensMap.put("inout", 114);
        this.fTokensMap.put("out", 114);
        this.fTokensMap.put("use", 121);
        this.fTokensMap.put("context", 121);
        this.fTokensMap.put("return", 123);
        this.fTokensMap.put("of", 125);
        this.fTokensMap.put("severity", 127);
        this.fTokensMap.put("function", 124);
        this.fTokensMap.put("port", 130);
        this.fTokensMap.put("generic", 130);
        this.fTokensMap.put("map", 129);
        this.fTokensMap.put("body", 131);
        this.fTokensMap.put("range", 133);
        this.fTokensMap.put("to", 134);
        this.fTokensMap.put("downto", 134);
        this.fTokensMap.put("new", 135);
        this.fTokensMap.put("package", 136);
        this.fTokensMap.put("procedure", 137);
        this.fTokensMap.put("entity", 128);
        this.fTokensMap.put("architecture", 128);
        this.fTokensMap.put("component", 128);
        this.fTokensMap.put("configuration", 128);
        this.fTokensMap.put("type", 128);
        this.fTokensMap.put("subtype", 128);
        this.fTokensMap.put("record", 138);
        this.fTokensMap.put("for", 138);
        this.fTokensMap.put("process", 138);
        this.fTokensMap.put("block", 138);
        this.fTokensMap.put("loop", 138);
        this.fTokensMap.put("generate", 138);
        this.fTokensMap.put("protected", 138);
    }

    public boolean getIsMethodProposal() {
        return this.fIsMethodProposal;
    }

    private int adjustTooltipOffset(IDocument document, boolean enableLeftScan, int offset) {
        block18: {
            this.fCharAtLeftOfStartOfset = (char)(offset > 0 ? (int)document.get(offset - 1, 1).charAt(0) : 32);
            this.fScanner = new DVTCharacterScanner(20, document, offset, true);
            String content = this.fDocument.getContentType("__vhdl_partitioning", this.fScanner.getOffset(), true);
            if (content.equals("__dftl_partition_content_type") || content.equals("__vhdl_psl_code")) break block18;
            return -1;
        }
        try {
            int mark = offset;
            char ch = '0';
            while (ch != '\uffff') {
                if (enableLeftScan) {
                    mark = this.mark();
                }
                if (!Character.isJavaIdentifierPart(ch = this.readChar())) break;
            }
            while (Character.isWhitespace(ch) && ch != '\uffff') {
                ch = this.readChar();
            }
            while (ch != '\uffff') {
                if (ch == '(') {
                    this.fIsMethodProposal = true;
                    int nested = 1;
                    while (ch != '\uffff') {
                        ch = this.readChar();
                        if (ch == ')') {
                            if (--nested != 0) continue;
                            ch = this.readChar();
                            break;
                        }
                        if (ch != 40) continue;
                        ++nested;
                    }
                } else if (ch == ')') {
                    ch = this.readChar();
                }
                while ((Character.isWhitespace(ch) || ch == ')') && ch != '\uffff') {
                    ch = this.readChar();
                }
                if (ch == '=' && this.readChar() == '>') {
                    this.fIsFollowedByGT = true;
                    this.fIsRightOrLeftPort = 0;
                    break;
                }
                if (ch == ',' || ch == ';' || ch == 'P' || ch == 'G' || ch == ')' || ch == 'p' || ch == 'g') {
                    this.fIsRightOrLeftPort = 1;
                }
                if (ch != '(') break;
            }
            while (Character.isWhitespace(ch) && ch != '\uffff') {
                ch = this.readChar();
            }
            if (ch == '=' && this.readChar() == '>') {
                this.fIsFollowedByGT = true;
            }
            if (!enableLeftScan) {
                return offset;
            }
            return mark;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return offset;
        }
    }

    public boolean isFollowedByGT() {
        return this.fIsFollowedByGT;
    }

    private char readChar() {
        try {
            while (this.fScanner.getOffset() > 0 && this.fScanner.getOffset() <= ((IDocument)this.fDocument).getLength()) {
                String content;
                if (this.fDocument.getDocumentPartitioner("__vhdl_partitioning") != null && !(content = this.fDocument.getContentType("__vhdl_partitioning", this.fScanner.getOffset() - 1, false)).equals("__dftl_partition_content_type") && !content.equals("__vhdl_psl_code")) {
                    this.fScanner.read();
                    continue;
                }
                char ch = (char)this.fScanner.read();
                return ch;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return '\uffff';
        }
        return '\uffff';
    }

    public Token nextToken() throws TokenStreamException {
        if (this.fInitialOffset < 0) {
            return new R2LToken(1, "");
        }
        Token result = this.internalNextToken();
        this.fFirstToken = false;
        if (this.fStopTokenizer) {
            return new R2LToken(1, "");
        }
        if (result != null && result.getText() != null && result.getText().length() > 20000) {
            this.fStopTokenizer = true;
        }
        return result;
    }

    private Token internalNextToken() throws TokenStreamException {
        try {
            int nested;
            char ch;
            boolean startsWithWS = false;
            boolean idStartsWithWS = false;
            DVTStringBuilder charBuff = new DVTStringBuilder();
            boolean evaluateAsNonIdToken = !this.fFirstToken || !Character.isJavaIdentifierPart(this.fCharAtLeftOfStartOfset);
            do {
                ch = this.readChar();
                if (this.fFirstToken && Character.isWhitespace(ch)) {
                    startsWithWS = true;
                }
                if (!startsWithWS || !Character.isJavaIdentifierPart(ch)) continue;
                idStartsWithWS = true;
            } while (Character.isWhitespace(ch));
            if (ch == '.') {
                return new R2LToken(101, ".");
            }
            if (ch == ':') {
                return new R2LToken(102, ":");
            }
            if (ch == '\'') {
                return new R2LToken(126, "'");
            }
            if (Character.isJavaIdentifierPart(ch)) {
                int offset = this.mark();
                do {
                    charBuff.prepend(ch);
                    offset = this.mark();
                } while (Character.isJavaIdentifierPart(ch = this.readChar()));
                if (ch == '\'') {
                    this.rewind(offset);
                    return new R2LToken(idStartsWithWS ? 113 : 103, charBuff.toString());
                }
                this.rewind(offset);
                String text = charBuff.toString().toLowerCase();
                if (this.fTokensMap.containsKey(text) && evaluateAsNonIdToken) {
                    if (!this.fIgnoreWhen && text.equals("when")) {
                        ArrayList<String> values = new ArrayList<String>();
                        this.fIgnoreWhen = true;
                        int nested2 = 0;
                        offset = this.mark();
                        boolean evalNextCase = false;
                        block4: do {
                            evalNextCase = false;
                            R2LToken token = null;
                            String prevTok = null;
                            while ((token = (R2LToken)this.nextToken()) != null && token.getType() != 120) {
                                if (this.mark() == 0) break block4;
                                if (prevTok != null && token.getType() == 112 && nested2 == 0) {
                                    values.add(prevTok);
                                }
                                if (token.getType() == 118) {
                                    offset = this.mark();
                                }
                                prevTok = token.getText();
                            }
                            if (nested2 > 0 && token != null && token.getType() == 120) {
                                --nested2;
                                evalNextCase = true;
                            }
                            if ((token = (R2LToken)this.nextToken()) == null || token.getType() != 119) continue;
                            ++nested2;
                        } while (nested2 > 0 || evalNextCase);
                        this.rewind(offset);
                        this.fIgnoreWhen = false;
                        return new R2LToken(122, DVTStringUtil.join(values, (String)","));
                    }
                    if (!this.fIgnoreReturn && text.equals("return")) {
                        this.fIgnoreReturn = true;
                        int nested3 = 0;
                        offset = this.mark();
                        boolean isDecl = true;
                        String prevTok = null;
                        block6: do {
                            R2LToken token = null;
                            while ((token = (R2LToken)this.nextToken()) != null && token.getType() != 124) {
                                if (this.mark() == 0) break block6;
                                if (token.getType() == 123 && nested3 == 0) {
                                    isDecl = false;
                                }
                                if (token.getType() != 118 || nested3 != 0) continue;
                                offset = this.mark();
                            }
                            if (nested3 > 0 && token != null && token.getType() == 124) {
                                --nested3;
                            }
                            if ((token = (R2LToken)this.nextToken()) == null || token.getType() != 119) continue;
                            ++nested3;
                        } while (nested3 > 0);
                        this.rewind(offset);
                        prevTok = this.nextToken().getText();
                        this.fIgnoreReturn = false;
                        if (!isDecl) {
                            return new R2LToken(123, prevTok);
                        }
                        return new R2LToken(123, null);
                    }
                    return new R2LToken(this.fTokensMap.get(text), text);
                }
                return new R2LToken(idStartsWithWS ? 113 : 103, charBuff.toString());
            }
            if (ch == '=') {
                int offset = this.mark();
                do {
                    charBuff.prepend(ch);
                    offset = this.mark();
                } while ((ch = this.readChar()) == '=' || ch == '<' || ch == ':' || ch == '/');
                this.rewind(offset);
                return new R2LToken(104, charBuff.toString());
            }
            if (ch == '>') {
                int mark = this.mark();
                if (this.readChar() != '=') {
                    this.rewind(mark);
                } else {
                    return new R2LToken(104, "=>");
                }
            }
            if (ch == ',') {
                return new R2LToken(107, ",");
            }
            if (ch == ']') {
                nested = 0;
                boolean ended = false;
                do {
                    charBuff.prepend(ch);
                    ch = this.readChar();
                    if (this.mark() == 0) {
                        return new R2LToken(100, "" + ch);
                    }
                    if (ch == '[' && nested < 0) {
                        ++nested;
                        continue;
                    }
                    if (ch == '[' && nested == 0) {
                        ended = true;
                        continue;
                    }
                    if (ch != ']') continue;
                    --nested;
                } while (ch != '[' || !ended);
                charBuff.prepend(ch);
                return new R2LToken(105, charBuff.toString());
            }
            if (ch == ')') {
                nested = 0;
                boolean ended = false;
                do {
                    charBuff.prepend(ch);
                    ch = this.readChar();
                    if (this.mark() == 0) {
                        return new R2LToken(100, "" + ch);
                    }
                    if (ch == '(' && nested < 0) {
                        ++nested;
                        continue;
                    }
                    if (ch == '(' && nested == 0) {
                        ended = true;
                        continue;
                    }
                    if (ch != ')') continue;
                    --nested;
                } while (ch != '(' || !ended);
                charBuff.prepend(ch);
                return new R2LToken(106, charBuff.toString());
            }
            if (ch == '(') {
                return new R2LToken(109, charBuff.toString());
            }
            return new R2LToken(100, "" + ch);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new R2LToken(1, "");
        }
    }

    protected int mark() {
        return this.fScanner.getOffset();
    }

    protected void rewind(int offset) {
        if (offset == -1) {
            offset = this.fInitialOffset;
            this.fFirstToken = true;
        }
        while (this.fScanner.getOffset() < offset) {
            this.fScanner.unread();
        }
        if (this.fScanner.getOffset() == this.fInitialOffset) {
            this.fFirstToken = true;
        }
    }

    public int isRightOrLeftPort() {
        return this.fIsRightOrLeftPort;
    }
}

