/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.r2lparser;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.HidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfGeneratesContainer;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPredefinedAttribute;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVUnit;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.r2lparser.R2LAttribute;
import ro.amiq.vhdldt.r2lparser.R2LManager;
import ro.amiq.vhdldt.r2lparser.R2LParser;
import ro.amiq.vhdldt.r2lparser.R2LResultContainer;
import ro.amiq.vhdldt.r2lparser.R2LScopeContainer;
import ro.amiq.vhdldt.r2lparser.R2LTokenizer;
import ro.amiq.vhdldt.r2lparser.R2LWalker;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class R2LTooltipManager
extends R2LManager {
    public R2LTooltipManager(RfProject rfProject, IRfScope initialScope, IResource file, IDocument document, int documentOffset) {
        super(rfProject, initialScope, file, document, documentOffset, documentOffset);
    }

    @Override
    public R2LResultContainer getProposals() {
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RfWNamedElementAndScope> getElements() {
        try {
            List<String> path;
            NamedElementHidPair[] hidProposals;
            if (this.fInitialScope == null) {
                return null;
            }
            if (this.fDocumentOffset <= 0 || this.fDocument.getLength() <= this.fDocumentOffset - 1) {
                return null;
            }
            if (!BuildConfigManager.isDisableNewHyperlinkTooltipEngine((IProject)this.fRfProject.getProject()) && (hidProposals = this.getHidProposals()) != null && hidProposals.length > 0) {
                ArrayList<RfWNamedElementAndScope> allElements = new ArrayList<RfWNamedElementAndScope>(hidProposals.length);
                NamedElementHidPair[] namedElementHidPairArray = hidProposals;
                int n = hidProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    NamedElementHidPair namedElementHidWrapper = namedElementHidPairArray[n2];
                    if (namedElementHidWrapper != null && namedElementHidWrapper.getNamedElement() != null) {
                        allElements.add(new RfWNamedElementAndScope(namedElementHidWrapper.getNamedElement(), this.fInitialScope, namedElementHidWrapper.getHid()));
                    }
                    ++n2;
                }
                return allElements;
            }
            if (!Character.isJavaIdentifierPart(this.fDocument.getChar(this.fDocumentOffset - 1))) {
                if (this.fDocumentOffset == this.fDocument.getLength() || !Character.isJavaIdentifierPart(this.fDocument.getChar(this.fDocumentOffset))) {
                    return null;
                }
                ++this.fDocumentOffset;
            }
            R2LResultContainer result = null;
            R2LScopeContainer scopeContainer = new R2LScopeContainer(this.fInitialScope);
            R2LWalker walker = new R2LWalker(this);
            R2LTokenizer lexer = new R2LTokenizer(this.fDocument, this.fDocumentOffset, true);
            R2LParser parser = new R2LParser(lexer, true);
            parser.rules();
            AST pAST = parser.getAST();
            if (pAST != null) {
                result = walker.rules(pAST, scopeContainer);
            }
            if (result == null || !result.isNumber && !result.hasProposals() && result.allowProposals()) {
                path = result == null ? null : result.path;
                String prefix = result == null || result.prefix == null ? "" : result.prefix;
                result = new R2LResultContainer();
                result.candidates = this.getExprCandidates(scopeContainer, null, 0, prefix, true);
                result.prefix = prefix;
                result.path = path;
            }
            if (!result.isNumber && !result.hasProposals()) {
                path = result.path;
                result = new R2LResultContainer();
                result.candidates = null;
                result.prefix = "";
                result.path = path;
            }
            result.initialScope = this.fInitialScope;
            ArrayList<String> instancePath = new ArrayList<String>();
            if (result.path != null) {
                instancePath.addAll(result.path);
            }
            if (result.prefix != null) {
                instancePath.add(result.prefix);
            }
            if (result.candidates != null && result.candidates.length != 0) {
                ArrayList<RfWNamedElementAndScope> allElements = new ArrayList<RfWNamedElementAndScope>();
                IRfNamedElement[] iRfNamedElementArray = result.candidates;
                int n = result.candidates.length;
                int n3 = 0;
                while (n3 < n) {
                    IRfNamedElement candidate = iRfNamedElementArray[n3];
                    allElements.add(new RfWNamedElementAndScope(candidate, result.initialScope, null));
                    ++n3;
                }
                return allElements;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private NamedElementHidPair[] getHidProposals() {
        RfNamedElement namedElement = this.fInitialScope.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        TooltipHidVisitor visitor = new TooltipHidVisitor();
        if (!(namedElement.getEnclosingScope() instanceof RfLibrary) && namedElement.getEnclosingScope() != null) {
            namedElement = namedElement.getEnclosingScope();
        }
        namedElement.visitHidObject(this.fRfProject, (IHidVisitor<?>)visitor);
        return visitor.getResult();
    }

    public RfNamedElement[] getEnumCandidates(R2LScopeContainer scopeContainer, List<String> enums, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scope = scopeContainer.scope;
        if (!(scope instanceof IRfScope)) {
            return null;
        }
        RfEnum candidate = ((IRfScope)scope).getEnumWithPrefix(prefix, 1);
        if (candidate == null) {
            return null;
        }
        return new RfNamedElement[]{candidate};
    }

    public RfNamedElement[] getEnumCandidates(R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scope = scopeContainer.scope;
        if (!(scope instanceof IRfScope)) {
            return null;
        }
        RfEnum candidate = ((IRfScope)scope).getEnumWithPrefix(prefix, 1);
        if (candidate == null) {
            return null;
        }
        return new RfNamedElement[]{candidate};
    }

    @Override
    public IRfNamedElement[] getTypeCandidates(R2LScopeContainer scopeContainer, String prefix, String typeKind) {
        IRfNamedElement design;
        boolean local;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        RfNamedElement candidate = null;
        IRfScopeElement scopeElement = scopeContainer.scope;
        RfNamedElement scopeNamedElement = scopeElement instanceof RfDefElement ? ((RfDefElement)scopeElement).getNamedElement() : (RfNamedElement)scopeElement;
        boolean bl = local = scopeContainer.path != null && !scopeContainer.path.isEmpty();
        if ((scopeNamedElement instanceof RfPackageBody || scopeNamedElement instanceof RfTypeBody || scopeNamedElement instanceof IRfEntityComplement || scopeNamedElement instanceof RfEntity) && prefix.equals(scopeNamedElement.getName())) {
            candidate = scopeNamedElement;
        }
        if (candidate == null && scopeNamedElement instanceof IRfInstanceElement && (design = ((IRfInstanceElement)scopeNamedElement).getSpecializedDesign(null)) != null && prefix.equals(design.getName())) {
            return new IRfNamedElement[]{design};
        }
        if (candidate == null) {
            candidate = scopeNamedElement.getMember(prefix, DVTRfUtils.MEMBERS_TYPES, null, !local, false, false, true, false);
        }
        if (candidate == null) {
            candidate = scopeNamedElement.getOtherLangMemberWithPrefix(prefix, 9);
        }
        if (candidate == null) {
            candidate = this.fRfProject.getMixedLangProjectParent().getDesignWithPrefix((IRfSingleLangProject)this.fRfProject, prefix, 9);
        }
        return new IRfNamedElement[]{candidate};
    }

    @Override
    public IRfNamedElement[] getEntityOrComponentCandidates(R2LScopeContainer scopeContainer, String prefix, boolean isComponent) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (scopeElement instanceof RfDefElement) {
            RfNamedElement candidate = ((RfDefElement)scopeElement).getNamedElement();
            if (!isComponent && candidate instanceof RfEntity && candidate.getName().equalsIgnoreCase(prefix)) {
                return new RfNamedElement[]{candidate};
            }
            if (candidate.getName().equalsIgnoreCase(prefix)) {
                return new RfNamedElement[]{candidate};
            }
        }
        return null;
    }

    @Override
    public IRfNamedElement[] getExprCandidates(R2LScopeContainer rightScopeContainer, R2LScopeContainer leftScopeContainer, int accessKind, String prefix, boolean isEqual) {
        IRfNamedElement[] iRfNamedElementArray;
        if (rightScopeContainer == null || rightScopeContainer.scope == null) {
            return null;
        }
        Object candidate = null;
        IRfScopeElement scopeElement = rightScopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            if (scopeElement instanceof IRfDesignElement) {
                candidate = ((IRfDesignElement)scopeElement).getInstanceWithPrefix(prefix, 1);
            }
            if (candidate == null && scopeElement != null) {
                candidate = scopeElement.getSignalWithPrefix(prefix, 9);
            }
        } else {
            boolean local;
            RfNamedElement namedElement;
            IRfScope scope = (IRfScope)scopeElement;
            if (leftScopeContainer != null && leftScopeContainer.scope != null && leftScopeContainer.scope instanceof IRfScope && (isEqual || rightScopeContainer.path == null || rightScopeContainer.path.isEmpty())) {
                RfNamedElement enclosingScope;
                RfNamedElement scopeNamedElement = ((IRfScope)leftScopeContainer.scope).getNamedElement();
                if (scopeNamedElement instanceof RfScalarType && (enclosingScope = ((RfScalarType)scopeNamedElement).getEnclosingScope()) != null) {
                    candidate = enclosingScope.getLocalEnum(prefix, scopeNamedElement.getName(), false);
                }
                if (candidate == null) {
                    candidate = ((IRfScope)leftScopeContainer.scope).getEnumWithPrefix(prefix, 1);
                }
            }
            RfNamedElement scopeNamedElement = namedElement = scope.getNamedElement();
            if (candidate == null && scopeNamedElement instanceof RfAlias && (((RfAlias)scopeNamedElement).isPackageInstatiation() || ((RfAlias)scopeNamedElement).isSubprogramInstantiation())) {
                IRfNamedElement instantiatedElement = ((RfAlias)scopeNamedElement).getAssociatedType();
                if (instantiatedElement instanceof RfNamedElement && (candidate = ((RfNamedElement)instantiatedElement).getTypeWithPrefix(prefix, 1, true)) != null) {
                    return new IRfNamedElement[]{candidate};
                }
            } else if (candidate == null && scopeNamedElement instanceof RfVUnit && (candidate = scope.getSignalWithPrefix(prefix, 1)) == null) {
                candidate = scope.getDesignWithPrefix(prefix, 1);
            }
            boolean bl = local = rightScopeContainer.path != null && !rightScopeContainer.path.isEmpty();
            if (namedElement instanceof RfComponent && !(namedElement instanceof RfEntity)) {
                candidate = scope.getPortWithPrefix(prefix, 1, local);
                if (candidate == null) {
                    candidate = scope.getComponentWithPrefix(prefix, 1, local);
                }
                if (candidate == null) {
                    candidate = scope.getTypeWithPrefix(prefix, 1, local);
                }
                if (candidate == null) {
                    candidate = scope.getVariableWithPrefix(prefix, 1, local);
                }
            } else if (candidate == null && isEqual) {
                candidate = scope.getVariableWithPrefix(prefix, 1, local);
                if (candidate == null) {
                    candidate = scope.getPortWithPrefix(prefix, 1, local);
                }
                if (candidate == null) {
                    if (scopeNamedElement instanceof RfFunction && prefix.equals(scopeNamedElement.getName()) && ((RfDefElement)scope).getStartOffset() <= this.fDocumentOffset && this.fDocumentOffset <= ((RfDefElement)scope).getEndOffset()) {
                        List<RfNamedElement> candidates = Collections.singletonList(scopeNamedElement);
                        return candidates.toArray(new IRfNamedElement[candidates.size()]);
                    }
                    List<RfFunction> candidates = scope.getFunctionsWithPrefix(prefix, 1, local);
                    if ((candidates = this.filterDuplicateMethods(candidates)) != null && !candidates.isEmpty()) {
                        return candidates.toArray(new IRfNamedElement[candidates.size()]);
                    }
                }
                if (candidate == null) {
                    candidate = scope.getTypeWithPrefix(prefix, 1, local);
                }
                if (candidate == null) {
                    candidate = scope.getComponentWithPrefix(prefix, 1, local);
                }
                if (candidate == null) {
                    candidate = scope.getEntityWithPrefix(prefix, 1);
                }
                if (candidate == null) {
                    candidate = scope.getArchitectureWithPrefix(prefix, 1);
                }
                if (candidate == null) {
                    candidate = scope.getPackageWithPrefix(prefix, 1);
                }
                if (candidate == null) {
                    candidate = scope.getLibraryWithPrefix(prefix, 1);
                }
                if (candidate == null) {
                    candidate = scope.getConfigurationWithPrefix(prefix, 1);
                }
                if (candidate == null && !prefix.isEmpty()) {
                    candidate = scope.getSequentialStatementWithPrefix(prefix, 1);
                }
                if (candidate == null) {
                    candidate = namedElement instanceof RfInstance ? ((RfInstance)namedElement).getEnclosingScope().getInstanceWithPrefix(prefix, 1, local) : scope.getInstanceWithPrefix(prefix, 1, local);
                }
                if (candidate == null) {
                    candidate = scope.getBlockWithPrefix(prefix, 1, local);
                }
                if (candidate == null) {
                    candidate = scope.getProcessWithPrefix(prefix, 1);
                }
                if (candidate == null) {
                    candidate = scope.getVUnitWithPrefix(prefix, 1);
                }
                if (candidate == null) {
                    candidate = scope.getPropertySequenceWithPrefix(prefix, 1, false);
                }
                if (candidate == null) {
                    candidate = scope.getEnumWithPrefix(prefix, 1);
                }
                if (candidate == null && scope.getNamedElement() != null) {
                    candidate = scope.getNamedElement().semanticGetUsedRecordElement(new HashSet<IRfNamedElement>(), prefix);
                }
                if (candidate == null) {
                    candidate = scope.getOtherLangMemberWithPrefix(prefix, 9);
                }
                if (candidate == null) {
                    candidate = this.fRfProject.getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)this.fRfProject, prefix, 1);
                }
            }
        }
        if (candidate == null) {
            iRfNamedElementArray = null;
        } else {
            IRfNamedElement[] iRfNamedElementArray2 = new IRfNamedElement[1];
            iRfNamedElementArray = iRfNamedElementArray2;
            iRfNamedElementArray2[0] = candidate;
        }
        return iRfNamedElementArray;
    }

    private List<RfFunction> filterDuplicateMethods(List<RfFunction> candidates) {
        if (candidates == null) {
            return null;
        }
        ArrayList<RfFunction> result = new ArrayList<RfFunction>();
        ArrayList<String> methodWithBodySignatures = new ArrayList<String>();
        LinkedHashMap<String, RfFunction> methodWithNoBodyByName = new LinkedHashMap<String, RfFunction>();
        for (RfFunction rfFunction : candidates) {
            String methodFullSignature = rfFunction.getFullName(false);
            int bodyInfoIndex = methodFullSignature.indexOf("@b:");
            if (bodyInfoIndex < 0) continue;
            boolean hasBody = "true".equalsIgnoreCase(methodFullSignature.substring(bodyInfoIndex + "@b:".length()));
            String methodSigWithoutBody = methodFullSignature.substring(0, bodyInfoIndex);
            if (hasBody) {
                result.add(rfFunction);
                methodWithBodySignatures.add(methodSigWithoutBody);
                continue;
            }
            methodWithNoBodyByName.put(methodSigWithoutBody, rfFunction);
        }
        for (Map.Entry entry : methodWithNoBodyByName.entrySet()) {
            String name = (String)entry.getKey();
            if (methodWithBodySignatures.contains(name)) continue;
            result.add((RfFunction)entry.getValue());
        }
        return result;
    }

    @Override
    public IRfNamedElement[] getUseCandidates(R2LScopeContainer scopeContainer, String prefix, boolean isUse, boolean isContext) {
        IRfNamedElement[] iRfNamedElementArray;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        RfNamedElement candidate = null;
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (scopeElement instanceof IRfScope) {
            IRfScope scope = (IRfScope)scopeElement;
            if (scopeContainer.path == null || scopeContainer.path.isEmpty()) {
                candidate = scope.getLibraryWithPrefix(prefix, 1);
            }
            if (candidate == null) {
                if (scope instanceof RfLibrary) {
                    candidate = this.internalGetUseCandidates((RfLibrary)scope, prefix, isUse);
                } else if (scope instanceof RfPackage) {
                    candidate = scope.getVariableWithPrefix(prefix, 1, true);
                    if (candidate == null) {
                        candidate = scope.getTypeWithPrefix(prefix, 1, true);
                    }
                    if (candidate == null) {
                        candidate = scope.getComponentWithPrefix(prefix, 1, true);
                    }
                    if (candidate == null) {
                        candidate = scope.getFunctionWithPrefix(prefix, 1, true);
                    }
                    if (candidate == null) {
                        candidate = scope.getEntityWithPrefix(prefix, 1);
                    }
                } else if (scope instanceof RfEntity) {
                    candidate = scope.getArchitectureWithPrefix(prefix, 1);
                } else if (scope instanceof RfType) {
                    candidate = scope.getVariableWithPrefix(prefix, 1, true);
                }
            }
        }
        R2LScopeContainer initialScopeContainer = scopeContainer;
        if (candidate == null) {
            if (scopeElement instanceof IRfScope && ((IRfScope)scopeElement).getNamedElement() != null) {
                scopeContainer = this.getOtherLanguageScope(scopeContainer, ((IRfScope)scopeElement).getNamedElement().getName(), null);
            }
            if (scopeContainer != null && scopeContainer.scope instanceof IRfLibraryElement) {
                if (isUse) {
                    candidate = ((IRfLibraryElement)scopeContainer.scope).getPackageWithPrefix(prefix, 9);
                }
                if (candidate == null) {
                    candidate = ((IRfLibraryElement)scopeContainer.scope).getDesignWithPrefix(prefix, 9);
                }
                if (!isUse && candidate == null) {
                    candidate = ((IRfLibraryElement)scopeContainer.scope).getPackageWithPrefix(prefix, 9);
                }
            } else if (scopeContainer != null && scopeContainer.scope instanceof IRfPackageElement) {
                HashMap resultMap = new HashMap(1);
                ((IRfPackageElement)scopeContainer.scope).getMembersWithPrefix(resultMap, prefix, true, 9);
                candidate = resultMap.isEmpty() ? null : (IRfNamedElement)resultMap.values().iterator().next();
            }
        }
        String defLib = "work";
        if (candidate == null && initialScopeContainer.path != null && !initialScopeContainer.path.isEmpty() && defLib.equalsIgnoreCase(initialScopeContainer.path.get(0)) && scopeElement instanceof RfLibrary && !defLib.equalsIgnoreCase(scopeElement.getName())) {
            scopeElement = ((RfLibrary)scopeElement).getLibraryWithPrefix(defLib, 9);
            candidate = this.internalGetUseCandidates((RfLibrary)scopeElement, prefix, isUse);
        }
        if (candidate == null) {
            iRfNamedElementArray = null;
        } else {
            IRfNamedElement[] iRfNamedElementArray2 = new IRfNamedElement[1];
            iRfNamedElementArray = iRfNamedElementArray2;
            iRfNamedElementArray2[0] = candidate;
        }
        return iRfNamedElementArray;
    }

    private IRfNamedElement internalGetUseCandidates(RfLibrary scope, String prefix, boolean isUse) {
        if (scope == null) {
            return null;
        }
        RfNamedElement candidate = null;
        candidate = scope.getPackageWithPrefix(prefix, 1);
        if (candidate == null) {
            candidate = scope.getContextWithPrefix(prefix, 1);
        }
        if (candidate == null) {
            candidate = scope.getEntityWithPrefix(prefix, 1);
        }
        if (candidate == null) {
            candidate = scope.getConfigurationWithPrefix(prefix, 1);
        }
        if (candidate == null) {
            candidate = scope.getVariableWithPrefix(prefix, 1, true);
        }
        return candidate;
    }

    @Override
    public RfNamedElement[] getSeverityCandidates(R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        IRfScope scope = (IRfScope)scopeElement;
        List<RfType> types = scope.getTypesWithPrefix("severity_level", 1, false);
        for (RfNamedElement rfNamedElement : types) {
            RfEnum result = rfNamedElement.getEnumWithPrefix(prefix, 1);
            if (result == null) continue;
            return new RfNamedElement[]{result};
        }
        RfVariable rfVariable = scope.getVariableWithPrefix(prefix, 1, false);
        if (rfVariable != null) {
            return new RfNamedElement[]{rfVariable};
        }
        RfFunction rfFunction = scope.getFunctionWithPrefix(prefix, 1, false);
        return new RfNamedElement[]{rfFunction};
    }

    @Override
    public RfNamedElement[] getAttributesCandidates(String prefix) {
        boolean isInteger = Pattern.matches("\\d+", prefix);
        if (isInteger) {
            return null;
        }
        String[] attributes = PrefConst.getVhdlAttributes();
        int length = prefix == null ? 0 : prefix.length();
        int i = 0;
        while (i < attributes.length) {
            String attribute = attributes[i].substring(1).toUpperCase();
            if (attribute.regionMatches(true, 0, prefix, 0, length)) {
                return new RfNamedElement[]{new R2LAttribute(attribute)};
            }
            ++i;
        }
        return null;
    }

    @Override
    public RfNamedElement[] getEndCandidates(R2LScopeContainer scopeContainer, String prefix) {
        RfNamedElement candidate;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (scopeElement instanceof RfDefElement && (candidate = ((RfDefElement)scopeElement).getNamedElement()) != null && candidate.getName().equalsIgnoreCase(prefix)) {
            return new RfNamedElement[]{candidate};
        }
        return null;
    }

    @Override
    public IRfNamedElement[] getMappingCandidates(R2LScopeContainer scopeContainer, String prefix, String genericOrPort, List<String> ports, boolean isHierarchical) {
        IRfNamedElement instantiatedElement;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        if (prefix == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        IRfScope scope = (IRfScope)scopeElement;
        IRfDesignElement designScope = null;
        RfNamedElement scopeNamedElement = scope.getNamedElement();
        if (scopeNamedElement instanceof RfInstance) {
            IRfDesignElement component = ((RfInstance)scopeNamedElement).getVHDLPreElaborationDesign();
            if (component != null) {
                if (component instanceof IRfDesignElement) {
                    designScope = component;
                } else if (component instanceof IRfScope) {
                    scope = (IRfScope)component;
                }
            }
        } else if (scopeNamedElement instanceof RfAlias && (((RfAlias)scopeNamedElement).isPackageInstatiation() || ((RfAlias)scopeNamedElement).isSubprogramInstantiation()) && (instantiatedElement = ((RfAlias)scopeNamedElement).getAssociatedType()) instanceof RfNamedElement) {
            scope = (RfNamedElement)instantiatedElement;
        }
        Object candidate = null;
        if ("port".equals(genericOrPort)) {
            candidate = designScope != null ? (isHierarchical ? designScope.getSignalWithPrefix(prefix, 1) : designScope.getPortWithPrefix(prefix, 1)) : (isHierarchical ? scope.getVariableWithPrefix(prefix, 1, false) : scope.getPortWithPrefix(prefix, 1, false));
        } else if (designScope != null) {
            candidate = isHierarchical ? designScope.getSignalWithPrefix(prefix, 1) : designScope.getParameterWithPrefix(prefix, 1);
        } else {
            candidate = scope.getVariableWithPrefix(prefix, 1, false);
            if (candidate == null) {
                candidate = scope.getTypeWithPrefix(prefix, 1, false);
            }
        }
        if (candidate == null) {
            return null;
        }
        return new IRfNamedElement[]{candidate};
    }

    @Override
    public IRfNamedElement[] getFuncArgCandidates(R2LScopeContainer scopeContainer, String funcName, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        IRfScope scope = (IRfScope)scopeElement;
        RfVariable candidate = null;
        RfFunctionsHolder functionHolder = scope.getFunctionHolderWithPrefix(funcName, 1, false);
        if (functionHolder == null) {
            return null;
        }
        List<RfFunction> functions = functionHolder.getLocalMembers(RfFunction.class);
        if (functions == null || functions.isEmpty()) {
            return null;
        }
        for (RfFunction function : functions) {
            candidate = function.getVariableWithPrefix(prefix, 1, true);
            if (candidate == null) continue;
            return new IRfNamedElement[]{candidate};
        }
        return null;
    }

    @Override
    public IRfNamedElement[] getPackageInstantiationCandidates(R2LScopeContainer scopeContainer, int kind, String prefix) {
        IRfNamedElement[] iRfNamedElementArray;
        boolean local;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        IRfScope scope = (IRfScope)scopeElement;
        RfNamedElement candidate = null;
        boolean bl = local = scopeContainer.path != null && !scopeContainer.path.isEmpty();
        if (kind == 1 || kind == 2) {
            candidate = scope.getFunctionWithPrefix(prefix, 1, local);
        }
        if (candidate == null) {
            candidate = scope.getPackageWithPrefix(prefix, 1);
        }
        if (candidate == null) {
            candidate = scope.getLibraryWithPrefix(prefix, 1);
        }
        if (candidate == null) {
            candidate = this.fRfProject.getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)this.fRfProject, prefix, 1);
        }
        if (candidate == null) {
            iRfNamedElementArray = null;
        } else {
            IRfNamedElement[] iRfNamedElementArray2 = new IRfNamedElement[1];
            iRfNamedElementArray = iRfNamedElementArray2;
            iRfNamedElementArray2[0] = candidate;
        }
        return iRfNamedElementArray;
    }

    @Override
    public IRfNamedElement[] getEntityCandidates(R2LScopeContainer scopeContainer, String prefix) {
        IRfNamedElement[] iRfNamedElementArray;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        RfNamedElement candidate = ((IRfScope)scopeElement).getEntityWithPrefix(prefix, 9);
        if (candidate == null) {
            candidate = ((IRfScope)scopeElement).getLibraryWithPrefix(prefix, 9);
        }
        if (candidate == null) {
            iRfNamedElementArray = null;
        } else {
            IRfNamedElement[] iRfNamedElementArray2 = new IRfNamedElement[1];
            iRfNamedElementArray = iRfNamedElementArray2;
            iRfNamedElementArray2[0] = candidate;
        }
        return iRfNamedElementArray;
    }

    @Override
    public IRfNamedElement[] getCaseCandidates(R2LScopeContainer rightScopeContainer, int accessKind, String prefix) {
        return this.getExprCandidates(rightScopeContainer, null, accessKind, prefix, true);
    }

    private static class NamedElementHidPair {
        private IRfNamedElement namedElement;
        private Hid hid;

        public NamedElementHidPair(IRfNamedElement namedElement, Hid hid) {
            this.namedElement = namedElement;
            this.hid = hid.upwardsCopy(true);
        }

        public IRfNamedElement getNamedElement() {
            return this.namedElement;
        }

        public Hid getHid() {
            return this.hid;
        }
    }

    private class TooltipHidVisitor
    extends HidVisitor {
        private NamedElementHidPair[] result;
        private ParserPath parserPath;

        public TooltipHidVisitor() {
            super(null);
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath != null && R2LTooltipManager.this.fFileDef != null && parserPath.equals((Object)R2LTooltipManager.this.fFileDef.getParserPath()) ? parserPath : null;
        }

        public boolean visit(Hid hid) {
            if (this.parserPath == null) {
                return true;
            }
            HidOccurrence occurrence = hid.getOccurrence();
            if (occurrence == null) {
                return true;
            }
            int startOffset = occurrence.getOffset();
            if (startOffset <= R2LTooltipManager.this.fDocumentOffset && startOffset + hid.getName().length() >= R2LTooltipManager.this.fDocumentOffset) {
                IRfNamedElement element = hid.getElement();
                this.result = new NamedElementHidPair[1];
                if (element != null && !(element instanceof RfPredefinedAttribute) && element.hasNoDefs(false)) {
                    element = null;
                }
                this.result[0] = new NamedElementHidPair(element, hid);
                return false;
            }
            if (hid.getElement() instanceof RfGeneratesContainer && hid.hasAccesses()) {
                for (HidAccess hidAccess : hid.getAccesses()) {
                    if (!hidAccess.isSelect()) continue;
                    List selects = hidAccess.getSelects();
                    for (IHidObject select : selects) {
                        if (!HidUtils.isHid((IHidObject)select) || this.visit((Hid)select)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        public NamedElementHidPair[] getResult() {
            return this.result;
        }
    }
}

