/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.netlist.utils.NLFilterSet;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.fsm.convert.FSMConverter;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IAlwaysBlockWrapper;
import ro.amiq.dvt.specador.templates.IArchitectureWrapper;
import ro.amiq.dvt.specador.templates.IComponentWrapper;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.specador.ComponentWrapper;
import ro.amiq.vhdldt.specador.FunctionWrapper;
import ro.amiq.vhdldt.specador.MemberWrapper;
import ro.amiq.vhdldt.specador.ProcessWrapper;
import ro.amiq.vhdldt.specador.SpecadorVhdlLinkResolver;
import ro.amiq.vhdldt.specador.Wrapper;

public class ArchitectureWrapper
extends Wrapper
implements IArchitectureWrapper {
    RfArchitecture architecture;
    List<ELInstance> instancesFromMemory = new LinkedList<ELInstance>();

    public ArchitectureWrapper(SpecadorModel model, RfArchitecture architecture) {
        super(model, architecture);
        this.architecture = architecture;
        this.instancesFromMemory = model.getElaboratedInstances((IRfNamedElement)architecture);
    }

    @Override
    public String getKind() {
        return RfKind.of(this.architecture).getName();
    }

    public List<IFreeMarkerWrapper> getTypes() {
        List<RfType> types = this.architecture.getLocalMembers(RfType.class);
        if (types == null || types.isEmpty()) {
            return Collections.emptyList();
        }
        return types.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)t)).map(t -> new MemberWrapper(this.getModel(), (RfNamedElement)t)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getFunctions() {
        List<RfFunction> functions = this.architecture.getFunctionsWithPrefix("", 2, true);
        if (functions == null || functions.isEmpty()) {
            return Collections.emptyList();
        }
        return functions.stream().filter(f -> f.isFunction() && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)f)).map(f -> new FunctionWrapper(this.getModel(), (RfFunction)f)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getProcedures() {
        List<RfFunction> functions = this.architecture.getFunctionsWithPrefix("", 2, true);
        if (functions == null || functions.isEmpty()) {
            return Collections.emptyList();
        }
        return functions.stream().filter(f -> f.isTask() && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)f)).map(f -> new FunctionWrapper(this.getModel(), (RfFunction)f)).collect(Collectors.toList());
    }

    public List<IComponentWrapper> getComponents() {
        List<RfComponent> components = this.architecture.getComponentsWithPrefix("", 2, true);
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        return components.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)t)).map(c -> new ComponentWrapper(this.getModel(), (RfComponent)c)).collect(Collectors.toList());
    }

    public List<IAlwaysBlockWrapper> getProcesses() {
        Collection<RfProcess> processes = this.architecture.getAllLocalProcesses();
        if (processes == null || processes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<IAlwaysBlockWrapper> result = new LinkedList<IAlwaysBlockWrapper>();
        int parallelism = 4;
        int timeout = 200;
        Map variablesWithModels = FSMConverter.convert((IRfNamedElement)this.architecture, (int)parallelism, (long)timeout, (IProgressMonitor)new NullProgressMonitor());
        for (RfProcess process : processes) {
            Map.Entry fsmData = LanguageContributor.get((LanguageKind)process.getLanguageKind()).getFSMModelForBlock((IRfActionBlockElement)process, variablesWithModels);
            if (process.isAnonymous() && !this.getModel().isExportUnnamedAlwaysBlocks() || (process.isAnonymous() || process.getComment().isEmpty()) && fsmData == null) continue;
            if (fsmData != null) {
                result.add(new ProcessWrapper(this.getModel(), process, (IRfFieldElement)fsmData.getKey(), (IFSMModel)fsmData.getValue()));
                continue;
            }
            result.add(new ProcessWrapper(this.getModel(), process, null, null));
        }
        return result;
    }

    public String getEntityName() {
        return this.architecture.getEntityName();
    }

    public String getEntityID() {
        RfEntity entity = this.architecture.getEntity();
        if (entity == null) {
            return "";
        }
        return SpecadorVhdlLinkResolver.getInstance().getID(entity);
    }

    public void generateFSMDiagrams(File location, IProgressMonitor progressMonitor) {
        long startTime = System.nanoTime();
        Map newFSMDiagrams = SpecadorSVGDiagramFactory.newFSMDiagrams((IRfNamedElement)this.architecture, (String)"", (IProgressMonitor)new NullProgressMonitor(), (SpecadorModel)this.getModel());
        if (!this.getModel().isExportUnnamedAlwaysBlocks()) {
            List variableNames = this.getProcesses().stream().filter(p -> p.containsFSMDiagram()).map(p -> p.getFSMDiagramVariableName()).collect(Collectors.toList());
            for (String FSMVariable : newFSMDiagrams.keySet()) {
                if (variableNames.contains(FSMVariable)) continue;
                newFSMDiagrams.remove(FSMVariable);
            }
        }
        if (newFSMDiagrams.isEmpty()) {
            return;
        }
        location.mkdirs();
        long duration = (System.nanoTime() - startTime) / (long)newFSMDiagrams.entrySet().size();
        for (Map.Entry diagram : newFSMDiagrams.entrySet()) {
            String variableName = (String)diagram.getKey();
            String svgDiagram = (String)((DVTPair)diagram.getValue()).getKey();
            File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.fsmDiagramFileName, (Object[])new Object[]{this.architecture.getEntityName(), variableName}));
            progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), file.getName()}));
            if (progressMonitor instanceof SpecadorProgressMonitor) {
                ((SpecadorProgressMonitor)progressMonitor).overwriteDuration(duration);
            }
            FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svgDiagram, (IProgressMonitor)progressMonitor, (int)0);
        }
    }

    public Map<String, List<IDesignInstanceWrapper>> getInstances(List<IRfDesignElement> topDesigns) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getModel().getProject());
        if (elManager == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<IDesignInstanceWrapper>> result = new LinkedHashMap<String, List<IDesignInstanceWrapper>>();
        IELMemory memory = elManager.getMemory();
        for (ELInstance instance : this.instancesFromMemory) {
            String[] pathElements = instance.getHierarchyPath().toString().split("\\.");
            ElementPath elementPath = ElementPath.EMPTY_PATH;
            String[] stringArray = pathElements;
            int n = pathElements.length;
            int n2 = 0;
            while (n2 < n) {
                IRfNamedElement parent;
                ElementPath elaborationForm;
                IRfNamedElement binding;
                String pathElement = stringArray[n2];
                if (pathElement != null && !"$root".equals(pathElement) && (binding = memory.bindingFor(elaborationForm = (elementPath = ElementPath.join((ElementPath)elementPath, (String)pathElement)), false)) instanceof IRfDesignElement && (parent = memory.bindingFor(elementPath.removeLastSegment(), false)) instanceof IRfDesignElement) {
                    if (topDesigns.contains(parent)) {
                        result.put("top", new LinkedList());
                        ((List)result.get("top")).add(LanguageContributor.get((LanguageKind)parent.getLanguageKind()).getInstance((IRfDesignElement)parent, elaborationForm, elaborationForm.getName()));
                    }
                    if (!result.containsKey(SpecadorVhdlLinkResolver.getInstance().getID(parent))) {
                        result.put(SpecadorVhdlLinkResolver.getInstance().getID(parent), new LinkedList());
                    }
                    if (!(DesignUtils.isBlock((Object)binding) && ((List)result.get(SpecadorVhdlLinkResolver.getInstance().getID(parent))).stream().anyMatch(ins -> ins.getName().equals(binding.getName())) || !((List)result.get(SpecadorVhdlLinkResolver.getInstance().getID(parent))).stream().allMatch(el -> !el.getInstanceName().equals(elaborationForm.lastSegment())))) {
                        ((List)result.get(SpecadorVhdlLinkResolver.getInstance().getID(parent))).add(LanguageContributor.get((LanguageKind)binding.getLanguageKind()).getInstance((IRfDesignElement)binding, elaborationForm, elaborationForm.getName()));
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private RfEntity getEntity() {
        return (RfEntity)this.architecture.getEnclosingScope();
    }

    public boolean generateSchematicDiagram(File location, IProgressMonitor progressMonitor, NLFilterSet filters) {
        if (!this.getModel().getDesignSchematicDiagram() || this.getModel().isForPDF()) {
            return false;
        }
        if (!this.hasSubInstances()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"schematic", String.valueOf(this.getLibraryName()) + "-" + this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newSchematicDiagram((IRfNamedElement)this.architecture, (String)"", (boolean)true, (LanguageKind)LanguageKind.VHDL, (NLFilterSet)filters);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public boolean generateSubInstancesDiagram(File location, IProgressMonitor progressMonitor, NLFilterSet filters) {
        if (!this.getModel().getDesignSubInstancesDiagram() || this.getModel().isForPDF()) {
            return false;
        }
        if (!this.hasSubInstances()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"subinstances", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newSubInstancesDiagram((IRfNamedElement)this.architecture, (String)"", (boolean)true, (LanguageKind)LanguageKind.VHDL, (NLFilterSet)filters);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public boolean generateFlowDiagram(File location, IProgressMonitor progressMonitor, NLFilterSet filters) {
        if (!this.getModel().getDesignFlowDiagram()) {
            return false;
        }
        if (!this.hasSubInstances()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"flow", String.valueOf(this.getLibraryName()) + "-" + this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newFlowDiagram((IRfNamedElement)this.architecture, (String)"", (boolean)true, (LanguageKind)LanguageKind.VHDL, (NLFilterSet)filters);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        this.addLinksToAPI(segments, insertions, this.getFunctions(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getProcedures(), codeLocation);
        this.addLinksToPage(segments, insertions, this.getComponents(), codeLocation);
        this.addLinksToProcesses(segments, insertions, this.getProcesses(), codeLocation);
    }

    private void addLinksToProcesses(List<String> segments, List<String> insertions, List<IAlwaysBlockWrapper> processes, File codeLocation) {
        block0: for (IFreeMarkerWrapper iFreeMarkerWrapper : processes) {
            int currentLength = 0;
            int startOffset = iFreeMarkerWrapper.getOffset();
            for (String segment : segments) {
                if (startOffset - currentLength > segment.length()) {
                    currentLength += segment.length();
                    continue;
                }
                int index = segments.indexOf(segment);
                segments.remove(index);
                segments.add(index, segment.substring(0, startOffset - currentLength));
                segments.add(index + 1, segment.substring(startOffset - currentLength));
                insertions.add(index, SpecadorConstants.getMessage((String)SpecadorConstants.linkToCodeWithAnchor, (Object[])new Object[]{this.getDocumentationLocation(codeLocation), SpecadorConstants.getMessage((String)SpecadorConstants.elementID, (Object[])new Object[]{iFreeMarkerWrapper.getKind(), processes.indexOf(iFreeMarkerWrapper)})}));
                continue block0;
            }
        }
    }

    @Override
    public String getFullPath() {
        return String.valueOf(super.getFullPath()) + this.getEntityName() + File.separator;
    }

    public List<ELInstance> getInstancesFromMemory() {
        return this.instancesFromMemory;
    }

    public IRfDesignElement getDesignElement() {
        return this.architecture;
    }
}

