/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IComponentWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.specador.GenericWrapper;
import ro.amiq.vhdldt.specador.PortWrapper;
import ro.amiq.vhdldt.specador.Wrapper;

public class ComponentWrapper
extends Wrapper
implements IComponentWrapper {
    RfComponent component;

    public ComponentWrapper(SpecadorModel model, RfComponent component) {
        super(model, component);
        this.component = component;
    }

    public String getEnclosingScope() {
        RfNamedElement enclosingScope = this.component.getEnclosingScope();
        if (enclosingScope != null) {
            return String.valueOf(enclosingScope instanceof RfArchitecture ? String.valueOf(((RfArchitecture)enclosingScope).getEntityName()) + "/" : "") + enclosingScope.getName();
        }
        return "";
    }

    public List<IFreeMarkerWrapper> getGenerics() {
        List<? extends RfNamedElement> generics = this.component.getLocalParameters();
        if (generics == null || generics.isEmpty()) {
            return Collections.emptyList();
        }
        return generics.stream().filter(g -> g instanceof RfVariable && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)g)).map(g -> new GenericWrapper(this.getModel(), (RfVariable)g)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getPorts() {
        List<? extends IRfPortElement> ports = this.component.getPortsWithPrefix("", 2);
        if (ports == null || ports.isEmpty()) {
            return Collections.emptyList();
        }
        return ports.stream().filter(p -> p instanceof RfPort && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)p)).map(p -> new PortWrapper(this.getModel(), (RfPort)p)).collect(Collectors.toList());
    }

    @Override
    public String getFullPath() {
        if (this.namedElement.getEnclosingScope() instanceof RfArchitecture) {
            RfArchitecture architecture = (RfArchitecture)this.namedElement.getEnclosingScope();
            return String.valueOf(super.getFullPath()) + architecture.getEntityName() + File.separator + architecture.getName() + File.separator;
        }
        return String.valueOf(super.getFullPath()) + this.namedElement.getEnclosingPackageName() + File.separator;
    }

    public boolean generateBlockDiagram(File location, IProgressMonitor progressMonitor) {
        if (this.getPorts().isEmpty() && this.getGenerics().isEmpty()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"block", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newBlockDiagram2((IRfNamedElement)this.component, (String)"", (LanguageKind)LanguageKind.VHDL);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }
}

