/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.specador.templates.ISpecadorContributor;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.specador.ArchitectureWrapper;
import ro.amiq.vhdldt.specador.ComponentWrapper;
import ro.amiq.vhdldt.specador.EntityWrapper;
import ro.amiq.vhdldt.specador.InstanceWrapper;
import ro.amiq.vhdldt.specador.LibraryWrapper;
import ro.amiq.vhdldt.specador.SpecadorVhdlLinkResolver;

public class Contributor
implements ISpecadorContributor {
    private SpecadorModel model;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public String getHyperlink(IRfNamedElement namedElement) {
        if (!(namedElement instanceof RfNamedElement)) {
            return "";
        }
        if (namedElement instanceof RfBlock && !(namedElement instanceof RfArchitecture)) {
            return "";
        }
        RfNamedElement element = (RfNamedElement)namedElement;
        if (this.shouldFilter(element)) {
            return "";
        }
        String link = SpecadorVhdlLinkResolver.getInstance().getLinkToElement(element, ".html", "#");
        if (link.isEmpty()) {
            return "";
        }
        return link;
    }

    public List<ILibraryWrapper> getLibraries(SpecadorModel model) {
        if (!model.hasVhdlNature()) {
            return Collections.emptyList();
        }
        return this.getLibraries(RfManager.getInstance().getRfProject(model.getProject()));
    }

    public List<ILibraryWrapper> getLibraries(RfMixedLangProject rfMixedLangProject) {
        RfProject project = (RfProject)rfMixedLangProject.getSingleLangProject(LanguageKind.VHDL.NATURE_ID);
        return this.getLibraries(project);
    }

    private List<ILibraryWrapper> getLibraries(RfProject project) {
        return project.getLibraries().stream().filter(l -> !l.getName().equals("non-top-files") && !this.shouldFilter((IRfNamedElement)l)).map(l -> new LibraryWrapper(this.getModel(), (RfLibrary)l)).collect(Collectors.toList());
    }

    public List<ILibraryWrapper> getSelectedLibraries(SpecadorModel model) {
        if (!model.hasVhdlNature() || !model.isExportVhdlLibraries()) {
            return Collections.emptyList();
        }
        return this.getLibraries(model).stream().filter(lib -> model.getVhdlSelectedLibraryNames().contains(lib.getName())).collect(Collectors.toList());
    }

    public String getDesignTopFile(IRfDesignElement top) {
        if (!(top instanceof RfArchitecture)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("libraries").append(File.separator).append(this.getLibraryName((IRfNamedElement)top)).append(File.separator);
        result.append(((RfArchitecture)top).getEntityName()).append(File.separator).append(top.getName());
        return result.toString();
    }

    public String getLibraryName(IRfNamedElement element) {
        if (element.getEnclosingLibrary() == null) {
            return "work-vhdl";
        }
        return String.valueOf(element.getEnclosingLibrary().getName()) + "-vhdl";
    }

    public boolean isPublic(IRfNamedElement namedElement) {
        return true;
    }

    public boolean isFilteredByName(IRfNamedElement namedElement) {
        StringMatcher[] namePatterns = this.getModel().getNamePatterns();
        if (namePatterns == null) {
            return false;
        }
        RfNamedElement element = (RfNamedElement)namedElement;
        StringMatcher[] stringMatcherArray = namePatterns;
        int n = namePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            StringMatcher matcher = stringMatcherArray[n2];
            if (matcher.match(element.getName().toLowerCase()) || matcher.match(element.getFullNameLabel().toLowerCase())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IDesignInstanceWrapper getInstance(IRfDesignElement namedElement, ElementPath elementpath, String name) {
        return new InstanceWrapper(this.getModel(), namedElement, elementpath, name);
    }

    public String getKind(IRfNamedElement element) {
        return RfKind.of(element).getName().replace(" ", "-");
    }

    public String getURL(IRfNamedElement element) {
        RfNamedElement namedElement = (RfNamedElement)element;
        SpecadorModel model = this.getModel();
        if (model == null) {
            return "";
        }
        StringBuilder url = new StringBuilder(File.separator);
        url.append(model.getOutputFolderName()).append(File.separator);
        url.append("libraries/");
        url.append(namedElement.getEnclosingLibrary() == null ? "work" : namedElement.getEnclosingLibrary().getName()).append("/");
        if (namedElement instanceof RfArchitecture) {
            url.append(((RfArchitecture)namedElement).getEntityName()).append("/");
        }
        return url.toString();
    }

    public IFreeMarkerWrapper getWrapper(IRfNamedElement namedElement) {
        if (namedElement instanceof RfArchitecture) {
            return new ArchitectureWrapper(this.getModel(), (RfArchitecture)namedElement);
        }
        if (namedElement instanceof RfEntity) {
            return new EntityWrapper(this.getModel(), (RfNamedElement)namedElement);
        }
        if (namedElement instanceof RfComponent) {
            return new ComponentWrapper(this.getModel(), (RfComponent)namedElement);
        }
        return null;
    }

    public boolean isValidForHTMLPreview(IRfNamedElement namedElement) {
        return namedElement instanceof RfEntity || namedElement instanceof RfArchitecture || namedElement instanceof RfComponent;
    }

    public void addSpecadorPreviewListenerToBuildListeners() {
        BuildEventManager.getInstance().registerListener((IBuildEventManagerListener)SpecadorPreviewListener.INSTANCE);
    }

    public void removeSpecadorPreviewListenerFromBuildListeners() {
        BuildEventManager.getInstance().unregisterListener((IBuildEventManagerListener)SpecadorPreviewListener.INSTANCE);
    }

    public String getFullPath(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return "";
        }
        String file = SpecadorVhdlLinkResolver.getInstance().getLinkToElement((RfNamedElement)element, ".rst", "#");
        if (file.isEmpty()) {
            return "";
        }
        if (file.contains("#")) {
            file = file.substring(0, file.indexOf("#"));
        }
        return String.valueOf(this.getModel().getLocation()) + File.separator + "source" + File.separator + file;
    }

    public String getFullNameLabel(IRfNamedElement element) {
        return Integer.toHexString(Objects.hashCode(element.getFullNameLabel()));
    }

    public SpecadorModel getModel() {
        return this.model;
    }

    public void setModel(SpecadorModel model) {
        SpecadorVhdlLinkResolver.getInstance().setModel(model);
        this.model = model;
    }
}

