/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IAlwaysBlockWrapper;
import ro.amiq.dvt.specador.templates.IArchitectureWrapper;
import ro.amiq.dvt.specador.templates.IComponentWrapper;
import ro.amiq.dvt.specador.templates.IEntityWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.specador.ArchitectureWrapper;
import ro.amiq.vhdldt.specador.FunctionWrapper;
import ro.amiq.vhdldt.specador.GenericWrapper;
import ro.amiq.vhdldt.specador.MemberWrapper;
import ro.amiq.vhdldt.specador.PortWrapper;
import ro.amiq.vhdldt.specador.Wrapper;

public class EntityWrapper
extends Wrapper
implements IEntityWrapper {
    RfEntity entity;

    EntityWrapper(SpecadorModel model, RfNamedElement namedElement) {
        super(model, namedElement);
        this.entity = (RfEntity)namedElement;
    }

    private boolean filterArchitecture(ArchitectureWrapper architectureWrapper, List<IRfDesignElement> topDesigns) {
        List<IFreeMarkerWrapper> types = architectureWrapper.getTypes();
        List<IFreeMarkerWrapper> functions = architectureWrapper.getFunctions();
        List<IFreeMarkerWrapper> procedures = architectureWrapper.getProcedures();
        List<IAlwaysBlockWrapper> processes = architectureWrapper.getProcesses();
        List<IComponentWrapper> components = architectureWrapper.getComponents();
        Map instances = topDesigns.isEmpty() ? Collections.emptyMap() : architectureWrapper.getInstances(topDesigns);
        Map subInstances = topDesigns.isEmpty() ? Collections.emptyMap() : architectureWrapper.getSubInstances();
        return !types.isEmpty() || !functions.isEmpty() || !procedures.isEmpty() || !processes.isEmpty() || !components.isEmpty() || !instances.isEmpty() || !subInstances.isEmpty();
    }

    public List<IArchitectureWrapper> getArchitectures(List<IRfDesignElement> topDesigns) {
        List<RfArchitecture> architectures = this.entity.getLocalMembers(RfArchitecture.class);
        if (architectures == null || architectures.isEmpty()) {
            return Collections.emptyList();
        }
        return architectures.stream().filter(element -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)element)).map(a -> new ArchitectureWrapper(this.getModel(), (RfArchitecture)a)).filter(aw -> this.filterArchitecture((ArchitectureWrapper)aw, topDesigns)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getConfigurations() {
        List<RfConfiguration> configurations = this.entity.getConfigurationsWithPrefix("", 2);
        if (configurations == null || configurations.isEmpty()) {
            return Collections.emptyList();
        }
        return configurations.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)t)).map(c -> new MemberWrapper(this.getModel(), (RfNamedElement)c)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getGenerics() {
        List<? extends RfNamedElement> generics = this.entity.getLocalParameters();
        if (generics == null || generics.isEmpty()) {
            return Collections.emptyList();
        }
        return generics.stream().filter(g -> g instanceof RfVariable && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)g)).map(g -> new GenericWrapper(this.getModel(), (RfVariable)g)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getPorts() {
        List<? extends IRfPortElement> ports = this.entity.getPortsWithPrefix("", 2);
        if (ports == null || ports.isEmpty()) {
            return Collections.emptyList();
        }
        return ports.stream().filter(p -> p instanceof RfPort && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)p)).map(p -> new PortWrapper(this.getModel(), (RfPort)p)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getTypes() {
        List<RfType> types = this.entity.getLocalMembers(RfType.class);
        if (types == null || types.isEmpty()) {
            return Collections.emptyList();
        }
        return types.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)t)).map(t -> new MemberWrapper(this.getModel(), (RfNamedElement)t)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getFunctions() {
        List functions = this.entity.getFunctionsWithPrefix("", 2, true).stream().filter(f -> f.isFunction()).collect(Collectors.toList());
        if (functions == null || functions.isEmpty()) {
            return Collections.emptyList();
        }
        return functions.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)t)).map(f -> new FunctionWrapper(this.getModel(), (RfFunction)f)).collect(Collectors.toList());
    }

    @Override
    public String getKind() {
        return RfKind.of(this.entity).getName();
    }

    public List<IFreeMarkerWrapper> getProcedures() {
        List procedures = this.entity.getFunctionsWithPrefix("", 2, true).stream().filter(f -> f.isTask()).collect(Collectors.toList());
        if (procedures == null || procedures.isEmpty()) {
            return Collections.emptyList();
        }
        return procedures.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)t)).map(f -> new FunctionWrapper(this.getModel(), (RfFunction)f)).collect(Collectors.toList());
    }

    public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        this.addLinksToAPI(segments, insertions, this.getFunctions(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getProcedures(), codeLocation);
    }

    public boolean generateBlockDiagram(File location, IProgressMonitor progressMonitor) {
        if (this.getPorts().isEmpty() && this.getGenerics().isEmpty()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"block", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newBlockDiagram2((IRfNamedElement)this.entity, (String)"", (LanguageKind)LanguageKind.VHDL);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }
}

