/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.specador.Wrapper;

public class FSMRowWrapper
extends Wrapper {
    FSMTransitionTableRow row;
    RfProcess process;

    FSMRowWrapper(SpecadorModel model, FSMTransitionTableRow row, RfProcess process) {
        super(model, null);
        this.row = row;
        this.process = process;
    }

    public int getTransitionIndex() {
        return this.row.getTransitionIndex();
    }

    public String getCurrentState() {
        if (this.getModel().isForPDF()) {
            return this.formatSpecialCharacters(this.row.getCurrentState().getNiceID());
        }
        return this.formatSpecialCharacters(this.row.getCurrentState().getNiceID().replace("`", "\\`"));
    }

    public String getNextState() {
        if (this.getModel().isForPDF()) {
            return this.formatSpecialCharacters(this.row.getNextState().getNiceID());
        }
        return this.formatSpecialCharacters(this.row.getNextState().getNiceID().replace("`", "\\`"));
    }

    public String getCondition() {
        if (this.getModel().isForPDF()) {
            return this.formatSpecialCharacters(this.row.getCondition().toString());
        }
        return this.formatSpecialCharacters(this.row.getCondition().toString().replace("`", "\\`"));
    }

    @Override
    public String getKind() {
        return "";
    }

    public List<SpecadorCommentWrapper> getTransitionComment() {
        Set markers = this.row.getTransition().getMarkers();
        RfFileDef fileDef = this.process.getFile();
        if (fileDef == null) {
            return Collections.emptyList();
        }
        return LanguageContributor.get((LanguageKind)this.process.getLanguageKind()).getTransitionComment(markers, fileDef.getParserPath(), this.process.getRfProject().getProject(), "__vhdl_partitioning", "__vhdl_sl_comment", "__vhdl_ml_comment", (IFreeMarkerWrapper)this);
    }
}

