/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.specador.VariableWrapper;
import ro.amiq.vhdldt.specador.Wrapper;

public class FunctionWrapper
extends Wrapper {
    RfFunction function;

    FunctionWrapper(SpecadorModel model, RfFunction function) {
        super(model, function);
        this.function = function;
    }

    public List<VariableWrapper> getFunctionArgumentsList() {
        ArrayList<VariableWrapper> result = new ArrayList<VariableWrapper>();
        List<RfVariable> arguments = this.function.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return result;
        }
        arguments.stream().forEach(a -> {
            boolean bl = result.add(new VariableWrapper(this.getModel(), (RfVariable)a));
        });
        return result;
    }

    public String getReturnTypeName() {
        IRfNamedElement returnType = this.function.getAssociatedType();
        if (returnType != null) {
            return this.function.getAssociatedType().getName();
        }
        return "";
    }

    public String getLinkToReturnType() {
        return this.getLinkToRef(this.function.getAssociatedType());
    }

    public String getQualifiers() {
        StringBuilder result = new StringBuilder();
        if (this.function.isVirtual()) {
            result.append("virtual ");
        }
        return result.toString() == null ? "" : result.toString();
    }

    @Override
    public String getFullPath() {
        if (this.function.getEnclosingScope() instanceof RfArchitecture) {
            RfArchitecture architecture = (RfArchitecture)this.namedElement.getEnclosingScope();
            return String.valueOf(super.getFullPath()) + architecture.getEntityName() + File.separator;
        }
        return super.getFullPath();
    }

    public List<String> getFunctionArguments() {
        return this.getFunctionArgumentsList().stream().map(argument -> argument.getName()).collect(Collectors.toList());
    }
}

