/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.IndexConstraint;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.specador.ComponentWrapper;
import ro.amiq.vhdldt.specador.SpecadorVhdlLinkResolver;
import ro.amiq.vhdldt.specador.Wrapper;

public class GenericWrapper
extends Wrapper {
    RfVariable generic;

    public GenericWrapper(SpecadorModel model, RfVariable generic) {
        super(model, generic);
        this.generic = generic;
    }

    public String getSimpleTypeUrl() {
        return SpecadorVhdlLinkResolver.getInstance().getLinkToRef(this.generic.getAssociatedType());
    }

    public String getSimpleTypeName() {
        return this.formatSpecialCharacters(this.generic.getAssociatedTypeName());
    }

    public List<List<String>> getTypeWithUrls() {
        List<IndexConstraint> elementConstraints = this.generic.getDataType().getElementConstraints();
        ArrayList<List<String>> constraintsListWithUrls = new ArrayList<List<String>>();
        for (IndexConstraint elementConstraint : elementConstraints) {
            IHidObject constraint = elementConstraint.getHidObject();
            ArrayList<String> constraintUrls = new ArrayList<String>();
            if (constraint instanceof RfHid) {
                RfHid hidConstraint = (RfHid)constraint;
                String constraintName = hidConstraint.getName();
                if ("range".equalsIgnoreCase(constraintName)) {
                    Hid parentHid = hidConstraint.getParentHid();
                    String url = this.getUrlFromHid(parentHid);
                    constraintUrls.add(this.formatSpecialCharacters(parentHid.getName()));
                    constraintUrls.add(url);
                    constraintUrls.add(" \\' range");
                    constraintUrls.add("");
                } else {
                    constraintUrls.add(this.formatSpecialCharacters(constraint.toString()));
                    constraintUrls.add("");
                }
            } else if (constraint instanceof RfHidOperator) {
                constraintUrls.addAll(this.getOperatorWithUrls((RfHidOperator)constraint));
            } else {
                constraintUrls.add(this.formatSpecialCharacters(constraint.toString()));
                constraintUrls.add("");
            }
            constraintsListWithUrls.add(constraintUrls);
        }
        return constraintsListWithUrls;
    }

    private List<String> getOperatorWithUrls(RfHidOperator operator) {
        ArrayList<String> operatorWithUrls = new ArrayList<String>();
        Set hids = HidUtils.flattenToHids((IHidObject)operator, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
        String operatorText = operator.toString().replace("[", "").replace("]", "");
        String[] splitOperatorText = DVTStringUtil.split((String)" ", (String)operatorText);
        int i = 0;
        while (i < splitOperatorText.length) {
            String element = splitOperatorText[i];
            String url = "";
            for (IHid hid : hids) {
                if (!(hid instanceof Hid) || !element.equals(hid.getName())) continue;
                url = this.getUrlFromHid((Hid)hid);
                break;
            }
            operatorWithUrls.add(this.formatSpecialCharacters(element));
            operatorWithUrls.add(url);
            ++i;
        }
        return operatorWithUrls;
    }

    private String getUrlFromHid(Hid hid) {
        if (!(hid instanceof RfHid)) {
            return "";
        }
        IRfNamedElement namedElement = ((RfHid)hid).getElement();
        if (!(namedElement instanceof RfNamedElement) || namedElement.isPredefined()) {
            return "";
        }
        String url = SpecadorVhdlLinkResolver.getInstance().getID(namedElement);
        if (url == null) {
            return "";
        }
        return url;
    }

    public String getInitialValue() {
        return this.generic.getInitialValue(false) == null ? "" : this.formatSpecialCharacters(this.generic.getInitialValue(false)).replace("\"", "\\\"").replace("'", "\\'");
    }

    public List<String> getInitialValueWithUrls() {
        ArrayList<String> elementsWithUrls = new ArrayList<String>();
        if (this.getInitialValue().isEmpty()) {
            return elementsWithUrls;
        }
        List<IHidOperator> operators = this.generic.getEnclosingScope().getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_EXPRESSION}, true);
        for (IHidOperator op : operators) {
            RfHidOperator operator;
            IHidObject lhValue;
            if (!(op instanceof RfHidOperator) || !((lhValue = (operator = (RfHidOperator)op).getLHValue()) instanceof RfHidImplicit) || !((RfHidImplicit)lhValue).getName().equals(this.generic.getName())) continue;
            IHidObject rhValue = operator.getFirstRHValue();
            if (rhValue instanceof RfHid) {
                RfHid rhValueHid = (RfHid)rhValue;
                elementsWithUrls.add(this.formatSpecialCharacters(rhValueHid.getName()));
                elementsWithUrls.add(this.getUrlFromHid(rhValueHid));
                break;
            }
            if (rhValue instanceof RfHidOperator) {
                elementsWithUrls.addAll(this.getOperatorWithUrls((RfHidOperator)rhValue));
                break;
            }
            elementsWithUrls.add(this.getInitialValue());
            elementsWithUrls.add("");
            break;
        }
        return elementsWithUrls;
    }

    @Override
    public String getFullPath() {
        if (this.generic.getEnclosingScope() instanceof RfComponent && !(this.generic.getEnclosingScope() instanceof RfEntity)) {
            return new ComponentWrapper(this.getModel(), (RfComponent)this.generic.getEnclosingScope()).getFullPath();
        }
        return super.getFullPath();
    }
}

