/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.specador.SpecadorVhdlLinkResolver;
import ro.amiq.vhdldt.specador.Wrapper;

public class InstanceWrapper
extends Wrapper
implements IDesignInstanceWrapper {
    IRfDesignElement designElement;
    ElementPath elementPath;
    String instanceName;

    public InstanceWrapper(SpecadorModel model, IRfDesignElement namedElement, ElementPath elementpath, String name) {
        super(model, (RfNamedElement)namedElement);
        this.designElement = namedElement;
        this.elementPath = elementpath;
        this.instanceName = name;
    }

    public String getInstanceName() {
        if (this.elementPath == null) {
            return "";
        }
        if (DesignUtils.isBlock((Object)this.designElement)) {
            return this.designElement.getName();
        }
        return this.instanceName;
    }

    public boolean hasHyperlink() {
        return this.getModel().getVhdlSelectedLibraryNames().contains(this.getLibraryName()) && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)this.designElement);
    }

    public String getEntityName() {
        return this.designElement instanceof RfArchitecture ? ((RfArchitecture)this.designElement).getEntityName() : "";
    }

    @Override
    public String getLibraryName() {
        return this.designElement.getEnclosingLibrary() != null ? this.designElement.getEnclosingLibrary().getName() : "work";
    }

    public String getEntityID() {
        return this.designElement instanceof RfArchitecture ? SpecadorVhdlLinkResolver.getInstance().getID(((RfArchitecture)this.designElement).getEntity()) : "";
    }

    public String getInstanceParams() {
        if (!this.getModel().isExportInstanceParameters()) {
            return "";
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getModel().getProject());
        if (elManager == null) {
            return "";
        }
        ELInstance elInstance = elManager.getMemory().instanceFor(this.elementPath.toElaborationForm());
        if (elInstance == null) {
            return "";
        }
        IRfNamedElement binding = elInstance.getBinding(false);
        if (!(binding instanceof RfArchitecture)) {
            return "";
        }
        ELParamValues paramValues = elInstance.getParamValues();
        if (paramValues == null) {
            return "";
        }
        if (((RfArchitecture)binding).getEntity() == null) {
            return "";
        }
        List<? extends RfNamedElement> generics = ((RfArchitecture)binding).getEntity().getLocalParameters();
        if (generics == null || generics.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < generics.size()) {
            String genericName = generics.get(i).getName();
            for (Map.Entry entry : paramValues.getEntries().entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(genericName) || entry.getValue() == null) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((String)entry.getKey()).append(" => ").append(((IELParamValue)entry.getValue()).intValue());
                break;
            }
            ++i;
        }
        return "(" + sb.toString().trim() + ")";
    }

    public boolean isBlock() {
        return this.designElement instanceof RfBlock && !(this.designElement instanceof RfArchitecture);
    }

    public boolean isComponent() {
        return this.designElement instanceof RfComponent;
    }

    public String getEnclosingScopeName() {
        if (!this.isComponent()) {
            return "";
        }
        RfNamedElement enclosingScope = ((RfComponent)this.designElement).getEnclosingScope();
        if (enclosingScope != null) {
            return String.valueOf(enclosingScope instanceof RfArchitecture ? String.valueOf(((RfArchitecture)enclosingScope).getEntityName()) + "/" : "") + enclosingScope.getName();
        }
        return "";
    }

    public String getExpression() {
        if (!this.isBlock()) {
            return "";
        }
        RfBlock block = (RfBlock)this.designElement;
        if (block.isIfGenerate()) {
            return "";
        }
        return block.getExpression() == null ? "" : block.getExpression();
    }
}

