/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IComponentWrapper;
import ro.amiq.dvt.specador.templates.IEntityWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.specador.templates.IPackageWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.specador.EntityWrapper;
import ro.amiq.vhdldt.specador.PackageWrapper;
import ro.amiq.vhdldt.specador.Wrapper;

public class LibraryWrapper
extends Wrapper
implements ILibraryWrapper {
    RfLibrary library;

    LibraryWrapper(SpecadorModel model, RfLibrary library) {
        super(model, library);
        this.library = library;
    }

    public String getFileName() {
        return LanguageContributor.get((LanguageKind)LanguageKind.VHDL).getLibraryName((IRfNamedElement)this.library);
    }

    public List<IEntityWrapper> getEntities(SpecadorModel model) {
        if (!model.hasVhdlNature() || !model.getVhdlLibrariesWithEntities().contains(this.getName())) {
            return Collections.emptyList();
        }
        List<RfEntity> entities = this.library.getLocalMembers(RfEntity.class);
        if (entities == null || entities.isEmpty()) {
            return Collections.emptyList();
        }
        List<IEntityWrapper> entityWrappers = entities.stream().filter(element -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)element)).map(e -> new EntityWrapper(this.getModel(), (RfNamedElement)e)).collect(Collectors.toList());
        return entityWrappers;
    }

    public boolean hasEntities(boolean hasNature) {
        if (!hasNature) {
            return false;
        }
        List<RfEntity> entities = this.library.getLocalMembers(RfEntity.class);
        return entities != null && !entities.isEmpty();
    }

    @Override
    public String getKind() {
        return RfKind.of(this.library).getName();
    }

    private boolean filterPackage(PackageWrapper packageWrapper) {
        List<IFreeMarkerWrapper> types = packageWrapper.getTypes();
        List<IFreeMarkerWrapper> functions = packageWrapper.getFunctions();
        List<IFreeMarkerWrapper> procedures = packageWrapper.getProcedures();
        List<IComponentWrapper> components = packageWrapper.getComponents();
        return !types.isEmpty() || !functions.isEmpty() || !procedures.isEmpty() || !components.isEmpty();
    }

    public List<IPackageWrapper> getPackages(SpecadorModel model) {
        if (!model.hasVhdlNature() || !model.getVhdlLibrariesWithPackages().containsKey(this.getName())) {
            return Collections.emptyList();
        }
        List<RfPackage> packages = this.library.getLocalMembers(RfPackage.class);
        if (packages == null || packages.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet unique = new HashSet();
        List<IPackageWrapper> packageWrappers = packages.stream().filter(pkg -> unique.add(pkg.getName()) && ((Set)model.getVhdlLibrariesWithPackages().get(this.getName())).contains(pkg.getName()) && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)pkg)).map(p -> new PackageWrapper(this.getModel(), (RfPackage)p)).filter(pw -> this.filterPackage((PackageWrapper)pw)).collect(Collectors.toList());
        return packageWrappers;
    }

    public List<String> getPackageNames(boolean hasNature) {
        if (!hasNature) {
            return Collections.emptyList();
        }
        List<RfPackage> packages = this.library.getLocalMembers(RfPackage.class);
        if (packages == null || packages.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet unique = new HashSet();
        return packages.stream().filter(pkg -> unique.add(pkg.getName()) && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)pkg)).map(p -> p.getName()).collect(Collectors.toList());
    }

    @Override
    public String getLibraryName() {
        return this.library.getName();
    }
}

