/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IComponentWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IPackageWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.specador.ComponentWrapper;
import ro.amiq.vhdldt.specador.FunctionWrapper;
import ro.amiq.vhdldt.specador.MemberWrapper;
import ro.amiq.vhdldt.specador.VariableWrapper;
import ro.amiq.vhdldt.specador.Wrapper;

public class PackageWrapper
extends Wrapper
implements IPackageWrapper {
    RfPackage pkg;

    PackageWrapper(SpecadorModel model, RfPackage pkg) {
        super(model, pkg);
        this.pkg = pkg;
    }

    public List<IFreeMarkerWrapper> getConstants() {
        List<RfVariable> variables = this.pkg.getLocalMembers(RfVariable.class);
        if (variables == null || variables.isEmpty()) {
            return Collections.emptyList();
        }
        return variables.stream().filter(v -> v.isConstant()).map(c -> new VariableWrapper(this.getModel(), (RfVariable)c)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getTypes() {
        List<RfType> types = this.pkg.getLocalMembers(RfType.class);
        if (types == null || types.isEmpty()) {
            return Collections.emptyList();
        }
        return types.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)t)).map(t -> new MemberWrapper(this.getModel(), (RfNamedElement)t)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getFunctions() {
        List<RfFunction> functions = this.pkg.getFunctionsWithPrefix("", 2, true);
        if (functions == null || functions.isEmpty()) {
            return Collections.emptyList();
        }
        return functions.stream().filter(f -> f.isFunction() && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)f)).map(f -> new FunctionWrapper(this.getModel(), (RfFunction)f)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getProcedures() {
        List<RfFunction> functions = this.pkg.getFunctionsWithPrefix("", 2, true);
        if (functions == null || functions.isEmpty()) {
            return Collections.emptyList();
        }
        return functions.stream().filter(f -> f.isTask() && !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)f)).map(f -> new FunctionWrapper(this.getModel(), (RfFunction)f)).collect(Collectors.toList());
    }

    public List<IComponentWrapper> getComponents() {
        List<RfComponent> components = this.pkg.getComponentsWithPrefix("", 2, true);
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        return components.stream().filter(element -> !LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)element)).map(c -> new ComponentWrapper(this.getModel(), (RfComponent)c)).collect(Collectors.toList());
    }

    public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        this.addLinksToPage(segments, insertions, this.getComponents(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getFunctions(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getProcedures(), codeLocation);
    }

    public String getPackageName() {
        return this.getName();
    }
}

