/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramBatch;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableData;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.fsm.utils.FSMDiagramProcessors;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.templates.IAlwaysBlockWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.specador.FSMRowWrapper;
import ro.amiq.vhdldt.specador.Wrapper;

public class ProcessWrapper
extends Wrapper
implements IAlwaysBlockWrapper {
    RfProcess process;
    IRfFieldElement fsmVariable;
    IFSMModel fsmModel;

    ProcessWrapper(SpecadorModel model, RfProcess process, IRfFieldElement fsmVariable, IFSMModel fsmModel) {
        super(model, process);
        this.process = process;
        this.fsmVariable = fsmVariable;
        this.fsmModel = fsmModel;
    }

    @Override
    public String getKind() {
        return RfKind.of(this.process).getName();
    }

    public String getName() {
        if (this.process.isAnonymous()) {
            return "process";
        }
        return this.process.getName();
    }

    public String getSensitivityList() {
        StringBuilder result = new StringBuilder();
        List<IRfNamedElement> sensitivityListSignals = this.process.getSensitivityListSignals();
        for (IRfNamedElement signal : sensitivityListSignals) {
            result.append(signal.getName());
            if (sensitivityListSignals.indexOf(signal) >= sensitivityListSignals.size() - 1) continue;
            result.append(" or ");
        }
        return result.toString();
    }

    public boolean containsFSMDiagram() {
        return this.fsmVariable != null && this.getModel().getFSMDiagrams();
    }

    public Set<String> getCommonExpressions() {
        if (!this.getModel().getFSMFilterCommonExpressionsInConditions()) {
            return Collections.emptySet();
        }
        return FSMDiagramProcessors.computeCommonExpressions((FSMModel)((FSMModel)this.fsmModel), (DProgressMonitor)DProgressMonitor.wrap((IProgressMonitor)new NullProgressMonitor(), null, null));
    }

    public List<FSMRowWrapper> getRows() {
        FSMDiagramBatch fsmDiagramBatch = new FSMDiagramBatch((IRfNamedElement)this.fsmVariable, this.fsmVariable.getName(), (FSMModel)this.fsmModel, new FSMTransitionTableData(), FSMDiagramConfiguration.getDefault());
        SpecadorSVGDiagramFactory.exportDiagram((DDiagram)fsmDiagramBatch, (String)"", (boolean)false, null);
        return fsmDiagramBatch.getFSMTransitionTable().getRows().stream().map(row -> new FSMRowWrapper(this.getModel(), (FSMTransitionTableRow)row, this.process)).collect(Collectors.toList());
    }

    public String getFSMDiagramVariableName() {
        return this.fsmVariable.getName();
    }

    public String getFSMDiagramName() {
        return SpecadorConstants.getMessage((String)SpecadorConstants.fsmDiagramFileName, (Object[])new Object[]{this.process.getEnclosingScope(RfEntity.class) != null ? this.process.getEnclosingScope(RfEntity.class).getName() : "", this.fsmVariable.getName()});
    }

    @Override
    public String getFullPath() {
        RfArchitecture architecture = (RfArchitecture)this.namedElement.getEnclosingScope();
        return String.valueOf(super.getFullPath()) + architecture.getEntityName() + File.separator;
    }

    public String getType() {
        return this.getName();
    }
}

