/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.fsm.convert.FSMConverter;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.utils.VHDLLinkResolver;

public class SpecadorVhdlLinkResolver
extends VHDLLinkResolver {
    private static SpecadorVhdlLinkResolver instance;
    private SpecadorModel model;

    public static SpecadorVhdlLinkResolver getInstance() {
        if (instance == null) {
            instance = new SpecadorVhdlLinkResolver();
        }
        return instance;
    }

    public void setModel(SpecadorModel model) {
        this.model = model;
    }

    public String linkInternalDocumentation(IRfNamedElement element, String linkElementName, String label, ITextEditor editor) {
        Collection<IRfNamedElement> candidates;
        Object[] parsedLink;
        int indexOfPackageDelimiter;
        boolean isAbsolutePath = false;
        String packageName = "";
        String originalLinkElementName = label;
        if (linkElementName.contains("#")) {
            linkElementName = linkElementName.substring(0, linkElementName.indexOf("#")).trim();
        }
        if ((indexOfPackageDelimiter = linkElementName.indexOf("::")) > 0 && !(packageName = linkElementName.substring(0, indexOfPackageDelimiter)).isEmpty() && !packageName.contains(".")) {
            linkElementName = linkElementName.substring(indexOfPackageDelimiter + 2);
            isAbsolutePath = true;
        }
        if (CommentUtils.getInstance().containsUnpermittedPatterns(linkElementName)) {
            return "";
        }
        boolean startsLikeAMacro = linkElementName.contains("`");
        if (startsLikeAMacro) {
            linkElementName = linkElementName.substring(1);
        }
        if ((parsedLink = DVTStringUtil.split((Pattern)CommentConstants.LINK_SPLIT_PATTERN, (String)DVTStringUtil.unescapeXMLString((String)linkElementName, (boolean)true))).length == 0 || startsLikeAMacro && parsedLink.length > 1) {
            return "";
        }
        parsedLink = CommentUtils.getInstance().cleanArray((String[])parsedLink);
        Collection<IRfNamedElement> collection = candidates = isAbsolutePath ? this.getPackageCandidates(packageName, this.model.getProject()) : this.getInitialCandidates(element, null);
        if ((candidates == null || candidates.isEmpty()) && isAbsolutePath) {
            candidates = this.getInitialCandidates(element, null);
            parsedLink = (String[])ArrayUtils.add((Object[])parsedLink, (int)0, (Object)packageName);
            isAbsolutePath = false;
        }
        if (candidates == null) {
            candidates = new ArrayList<IRfNamedElement>();
        }
        if (!isAbsolutePath) {
            candidates.add(element);
        }
        try {
            IRfNamedElement foundElement = this.solveHyperlinkForAllCandidates(element, candidates, (String[])parsedLink, System.currentTimeMillis() + 500L);
            if (foundElement != null) {
                return this.createLinkToElement(element, foundElement, originalLinkElementName);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (linkElementName.endsWith("s")) {
            return this.linkInternalDocumentation(element, linkElementName.substring(0, linkElementName.length() - 1), originalLinkElementName, editor);
        }
        return "";
    }

    protected String createLinkToElement(IRfNamedElement commentOrigin, IRfNamedElement element, String elementName) {
        if (!(element instanceof RfNamedElement) || !this.isInsideDocumentedLibrary((RfNamedElement)element)) {
            return elementName;
        }
        if (this.model.isForPDF()) {
            return "[" + elementName.replace("_", "\\\\_") + "](" + this.getID(element) + ")";
        }
        String extension = ".html";
        String anchor = "#";
        String link = this.getLinkToElement((RfNamedElement)element, extension, anchor);
        if (link.isEmpty()) {
            return "";
        }
        return CommentUtils.getInstance().wrapIntoA(link, elementName, true);
    }

    public String getLinkToRef(IRfNamedElement type) {
        if (type == null || type.isPredefined()) {
            return "";
        }
        if ((type instanceof RfEntity || type instanceof RfType || type instanceof RfArchitecture) && this.isInsideDocumentedLibrary((RfNamedElement)type) && !type.isPredefined()) {
            return this.getID(type);
        }
        return "";
    }

    public String getKind(IRfNamedElement element) {
        return LanguageContributor.get((LanguageKind)element.getLanguageKind()).getKind(element);
    }

    private String getFullNameLabel(IRfNamedElement element) {
        return LanguageContributor.get((LanguageKind)element.getLanguageKind()).getFullNameLabel(element);
    }

    protected String getID(IRfNamedElement element) {
        return SpecadorConstants.getMessage((String)SpecadorConstants.elementID, (Object[])new Object[]{this.getKind(element), this.getFullNameLabel(element)});
    }

    public String getLinkToType(RfNamedElement element, String extension, String anchor) {
        if (element == null || element.isPredefined() || !this.isInsideDocumentedLibrary(element)) {
            return "";
        }
        if (element instanceof RfLibrary) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{element.getName(), String.valueOf(element.getName()) + extension, anchor, this.getID(element)});
        }
        String enclosingLibraryName = "libraries/" + LanguageContributor.get((LanguageKind)LanguageKind.VHDL).getLibraryName((IRfNamedElement)element);
        if (element instanceof RfEntity || element instanceof RfPackage) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{enclosingLibraryName, String.valueOf(element.getName()) + extension, anchor, this.getID(element)});
        }
        if (element instanceof RfComponent) {
            RfNamedElement enclosingScope = element.getEnclosingScope();
            if (enclosingScope == null) {
                return "";
            }
            String enclosingScopeLocation = String.valueOf(enclosingScope instanceof RfArchitecture ? String.valueOf(((RfArchitecture)enclosingScope).getEntityName()) + File.separator : "") + enclosingScope.getName();
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(enclosingLibraryName) + "/" + enclosingScopeLocation, String.valueOf(element.getName()) + extension, anchor, this.getID(element)});
        }
        if (element instanceof RfArchitecture) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(enclosingLibraryName) + "/" + ((RfArchitecture)element).getEntityName(), String.valueOf(element.getName()) + extension, anchor, this.getID(element)});
        }
        if (element instanceof RfType || element instanceof RfVariable) {
            String scopeName;
            RfNamedElement scope = element.getEnclosingScope();
            String string = scopeName = scope == null ? "work" : scope.getName();
            if (scope instanceof RfEntity || scope instanceof RfPackage) {
                return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{enclosingLibraryName, String.valueOf(scopeName) + extension, anchor, this.getID(element)});
            }
            if (scope instanceof RfArchitecture) {
                return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(enclosingLibraryName) + "/" + ((RfArchitecture)scope).getEntityName(), String.valueOf(scopeName) + extension, anchor, this.getID(element)});
            }
        }
        return "";
    }

    private String getProcessID(RfProcess process) {
        RfArchitecture architecture = (RfArchitecture)process.getEnclosingScope();
        Collection<RfProcess> processes = architecture.getAllLocalProcesses();
        if (processes == null || processes.isEmpty()) {
            return "";
        }
        int index = 0;
        int parallelism = 4;
        int timeout = 200;
        Map variablesWithModels = FSMConverter.convert((IRfNamedElement)architecture, (int)parallelism, (long)timeout, (IProgressMonitor)new NullProgressMonitor());
        for (RfProcess proc : processes) {
            Map.Entry fsmData = LanguageContributor.get((LanguageKind)process.getLanguageKind()).getFSMModelForBlock((IRfActionBlockElement)proc, variablesWithModels);
            if ((proc.isAnonymous() || proc.getComment().isEmpty()) && fsmData == null) continue;
            if (proc.equals(process)) {
                return "process-" + index;
            }
            ++index;
        }
        return "";
    }

    public String getLinkToElement(RfNamedElement element, String extension, String anchor) {
        String link = this.getLinkToType(element, extension, anchor);
        if (!link.isEmpty()) {
            return link;
        }
        RfNamedElement enclosingScope = element.getEnclosingScope();
        String enclosingLibraryName = "libraries/" + LanguageContributor.get((LanguageKind)LanguageKind.VHDL).getLibraryName((IRfNamedElement)element);
        if (enclosingScope instanceof RfEntity || enclosingScope instanceof RfPackage) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{enclosingLibraryName, String.valueOf(enclosingScope.getName()) + extension, anchor, this.getID(element)});
        }
        if (enclosingScope instanceof RfComponent) {
            RfNamedElement componentEnclosingScope = enclosingScope.getEnclosingScope();
            if (componentEnclosingScope == null) {
                return "";
            }
            String enclosingScopeLocation = String.valueOf(componentEnclosingScope instanceof RfArchitecture ? String.valueOf(((RfArchitecture)componentEnclosingScope).getEntityName()) + File.separator : "") + componentEnclosingScope.getName();
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(enclosingLibraryName) + "/" + enclosingScopeLocation, String.valueOf(enclosingScope.getName()) + extension, anchor, this.getID(element)});
        }
        if (enclosingScope instanceof RfArchitecture) {
            if (element instanceof RfProcess) {
                return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(enclosingLibraryName) + "/" + ((RfArchitecture)enclosingScope).getEntityName(), String.valueOf(enclosingScope.getName()) + extension, anchor, this.getProcessID((RfProcess)element)});
            }
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(enclosingLibraryName) + "/" + ((RfArchitecture)enclosingScope).getEntityName(), String.valueOf(enclosingScope.getName()) + extension, anchor, this.getID(element)});
        }
        return "";
    }

    private boolean isInsideDocumentedLibrary(RfNamedElement element) {
        if (LanguageContributor.get((LanguageKind)LanguageKind.VHDL).shouldFilter((IRfNamedElement)element)) {
            return false;
        }
        RfLibrary library = element.getEnclosingLibrary();
        if (library == null || library.getName().isEmpty()) {
            return this.model.isExportVhdlLibraries();
        }
        if (element instanceof RfEntity || element.getEnclosingScope(RfEntity.class) != null || element instanceof RfArchitecture || element.getEnclosingScope(RfArchitecture.class) != null) {
            return this.model.getVhdlLibrariesWithEntities().contains(library.getName());
        }
        RfPackage packageScope = element.getEnclosingScope(RfPackage.class);
        if (element instanceof RfPackage || packageScope != null) {
            String packageName;
            String string = packageName = element instanceof RfPackage ? element.getName() : "";
            if (packageScope != null) {
                packageName = packageScope.getName();
            }
            return this.model.getVhdlLibrariesWithPackages().containsKey(library.getName()) && ((Set)this.model.getVhdlLibrariesWithPackages().get(library.getName())).contains(packageName);
        }
        return this.model.getVhdlSelectedLibraryNames().contains(library.getName());
    }
}

