/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.specador.ComponentWrapper;
import ro.amiq.vhdldt.specador.Wrapper;

public class VariableWrapper
extends Wrapper {
    RfVariable variable;

    VariableWrapper(SpecadorModel model, RfVariable variable) {
        super(model, variable);
        this.variable = variable;
    }

    public String getInitialValue() {
        return this.variable.getInitialValue(false) != null ? this.formatSpecialCharacters(this.variable.getInitialValue(false)).replace("\"", "\\\"").replace("'", "\\'") : "";
    }

    public String getLinkToRefType() {
        return this.getLinkToRef(this.variable.getAssociatedType());
    }

    public String getAssociatedTypeName() {
        return this.variable.getAssociatedTypeName() == null ? "" : this.variable.getAssociatedTypeName().replace("wire logic", "wire").replace("var", "");
    }

    public String getLinkToParent() {
        if (this.getLinkToRef(this.variable.getEnclosingScope()).equals("")) {
            return "";
        }
        return this.getID();
    }

    @Override
    public String getFullPath() {
        if (this.namedElement.getEnclosingScope() instanceof RfFunction) {
            return new ComponentWrapper(this.getModel(), (RfComponent)this.namedElement.getEnclosingScope()).getFullPath();
        }
        return super.getFullPath();
    }

    public List<SpecadorCommentWrapper> getComment(CommentBlock commentBlock) {
        if (commentBlock != null && !commentBlock.isEmpty()) {
            return super.getComment(commentBlock);
        }
        String commentFromEnclosingScope = this.variable.getComment();
        if (commentFromEnclosingScope == null || commentFromEnclosingScope.isEmpty()) {
            return Collections.emptyList();
        }
        return super.getComment(new CommentBlock(commentFromEnclosingScope, "", false));
    }
}

