/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.specador;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.specador.ArchitectureWrapper;
import ro.amiq.vhdldt.specador.ComponentWrapper;
import ro.amiq.vhdldt.specador.EntityWrapper;
import ro.amiq.vhdldt.specador.FunctionWrapper;
import ro.amiq.vhdldt.specador.PackageWrapper;
import ro.amiq.vhdldt.specador.SpecadorVhdlLinkResolver;

abstract class Wrapper
implements IFreeMarkerWrapper {
    protected final RfNamedElement namedElement;
    protected final SpecadorModel model;
    final Comparator<Wrapper> alphabeticComparator = (o1, o2) -> o1.getName().compareTo(o2.getName());

    public SpecadorModel getModel() {
        return this.model;
    }

    Wrapper(SpecadorModel model, RfNamedElement namedElement) {
        this.namedElement = namedElement;
        this.model = model;
    }

    public IRfNamedElement getNamedElement() {
        return this.namedElement;
    }

    public ICommentLinkResolver getLinker() {
        return SpecadorVhdlLinkResolver.getInstance();
    }

    public CommentBlock getCommentBlock() {
        return this.namedElement.getCommentBlock();
    }

    public String createFileReferenceContent(File codeLocation) {
        LinkedList<Wrapper> list = new LinkedList<Wrapper>();
        RfFileDef fileDef = this.namedElement.getFile();
        if (fileDef == null) {
            return "";
        }
        ParserPath parserPath = fileDef.getParserPath();
        Collection<RfDefElement> children = fileDef.getChildren();
        for (RfDefElement child : children) {
            RfNamedElement element = child.getNamedElement();
            if (element instanceof RfEntity) {
                list.add(new EntityWrapper(this.getModel(), element));
                continue;
            }
            if (element instanceof RfFunction) {
                list.add(new FunctionWrapper(this.getModel(), (RfFunction)element));
                continue;
            }
            if (element instanceof RfArchitecture) {
                list.add(new ArchitectureWrapper(this.getModel(), (RfArchitecture)element));
                continue;
            }
            if (element instanceof RfComponent) {
                list.add(new ComponentWrapper(this.getModel(), (RfComponent)element));
                continue;
            }
            if (!(element instanceof RfPackage)) continue;
            list.add(new PackageWrapper(this.getModel(), (RfPackage)element));
        }
        IPath fileLocation = Path.fromOSString((String)parserPath.toString());
        String sourceCodeFileContent = this.readSourceCodeFileForExporting(fileLocation.toFile());
        LinkedList<String> segments = new LinkedList<String>();
        LinkedList insertions = new LinkedList();
        segments.add(sourceCodeFileContent);
        this.addLinksToPage(segments, insertions, list, codeLocation);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < insertions.size()) {
            sb.append(StringEscapeUtils.escapeHtml((String)((String)segments.get(i)))).append((String)insertions.get(i));
            ++i;
        }
        sb.append(StringEscapeUtils.escapeHtml((String)((String)segments.get(segments.size() - 1))));
        return sb.toString();
    }

    public String getKind() {
        return RfKind.of(this.namedElement).getName().replace(" ", "-");
    }

    protected String getLinkToRef(IRfNamedElement element) {
        return SpecadorVhdlLinkResolver.getInstance().getLinkToRef(element);
    }

    public String getLanguageKind() {
        return "VHDL";
    }

    public String getLibraryName() {
        return this.namedElement.getEnclosingLibrary() != null ? this.namedElement.getEnclosingLibrary().getName() : "work";
    }

    public String getFullPath() {
        return String.valueOf(super.getFullPath()) + "libraries" + File.separator + LanguageContributor.get((LanguageKind)LanguageKind.VHDL).getLibraryName(this.getNamedElement()) + File.separator;
    }
}

