/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.statistics.FileInfo;
import ro.amiq.dvt.statistics.Info;
import ro.amiq.dvt.statistics.Metric;
import ro.amiq.dvt.statistics.RelevantInfo;
import ro.amiq.dvt.statistics.StatisticsUtilProviderBase;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.parser.VhdlFileInstance;

public class StatisticsUtilProvider
extends StatisticsUtilProviderBase {
    private VhdlInfo architecturesInfo;
    private VhdlInfo entitiesInfo;
    private VhdlInfo configurationsInfo;
    private VhdlInfo componentsInfo;
    private VhdlInfo functionsInfo;
    private VhdlInfo proceduresInfo;
    private VhdlInfo packagesInfo;

    public void clean() {
        super.clean();
        this.architecturesInfo = null;
        this.entitiesInfo = null;
        this.configurationsInfo = null;
        this.componentsInfo = null;
        this.functionsInfo = null;
        this.proceduresInfo = null;
        this.packagesInfo = null;
    }

    public void init() {
        super.init();
        this.architecturesInfo = new VhdlArchitectureInfo();
        this.entitiesInfo = new VhdlEntityInfo();
        this.configurationsInfo = new VhdlConfigurationInfo();
        this.componentsInfo = new VhdlComponentInfo();
        this.functionsInfo = new VhdlFunctionInfo();
        this.proceduresInfo = new VhdlProcedureInfo();
        this.packagesInfo = new VhdlPackageInfo();
    }

    protected void collectSpecificStatistics(IProject project, IProgressMonitor progressMonitor) {
        VhdlInfo elementInfo;
        super.collectSpecificStatistics(project, progressMonitor);
        RfProject rfProject = (RfProject)this.getRfProject(project);
        if (!this.setCurrentTask("Collecting type statistics ...", true)) {
            return;
        }
        List<RfNamedElement> allTypes = rfProject.getAllDeclarationScopes(true);
        for (RfNamedElement rfType : allTypes) {
            if (!this.setCurrentTask("Collecting type statistics for " + rfType.getSignature() + " ...", false)) {
                return;
            }
            if (this.isFiltered(rfType) || rfType.isPredefined()) continue;
            if (rfType instanceof RfArchitecture) {
                RfArchitecture rfClass = (RfArchitecture)rfType;
                VhdlInfo elementInfo2 = this.computeElementInfo(rfClass);
                this.architecturesInfo.update(elementInfo2);
                continue;
            }
            if (rfType instanceof RfEntity) {
                elementInfo = this.computeElementInfo(rfType);
                this.entitiesInfo.update(elementInfo);
                continue;
            }
            if (rfType instanceof RfConfiguration) {
                elementInfo = this.computeElementInfo(rfType);
                this.configurationsInfo.update(elementInfo);
                continue;
            }
            if (!(rfType instanceof RfPackage)) continue;
            elementInfo = this.computeElementInfo(rfType);
            this.packagesInfo.update(elementInfo);
        }
        for (RfNamedElement i : rfProject.getAllComponents()) {
            if (this.isFiltered(i) || i.isPredefined()) continue;
            elementInfo = this.computeElementInfo(i);
            this.componentsInfo.update(elementInfo);
        }
        for (RfNamedElement i : rfProject.getAllFunctions(false)) {
            if (this.isFiltered(i) || i.isPredefined()) continue;
            elementInfo = this.computeElementInfo(i);
            this.functionsInfo.update(elementInfo);
        }
        for (RfNamedElement i : rfProject.getAllFunctions(true)) {
            if (this.isFiltered(i) || i.isPredefined()) continue;
            elementInfo = this.computeElementInfo(i);
            this.proceduresInfo.update(elementInfo);
        }
        this.addSeparator();
        this.createAndAddMetric("Nof Architectures", this.architecturesInfo.counter);
        this.createAndAddMetric("Nof Entities", this.entitiesInfo.counter);
        this.createAndAddMetric("Nof Configurations", this.configurationsInfo.counter);
        this.createAndAddMetric("Nof Components", this.componentsInfo.counter);
        this.createAndAddMetric("Nof Functions", this.functionsInfo.counter);
        this.createAndAddMetric("Nof Procedures", this.proceduresInfo.counter);
        this.createAndAddMetric("Nof Packages", this.packagesInfo.counter);
        if (this.architecturesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.architecturesInfo);
        }
        if (this.entitiesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.entitiesInfo);
        }
        if (this.configurationsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.configurationsInfo);
        }
        if (this.componentsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.componentsInfo);
        }
        if (this.functionsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.functionsInfo);
        }
        if (this.proceduresInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.proceduresInfo);
        }
        if (this.packagesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.packagesInfo);
        }
        this.fProgressMonitor = null;
    }

    protected boolean isFiltered(Object o) {
        if (o instanceof RfNamedElement) {
            Collection<? extends RfDefElement> defs = ((RfNamedElement)o).getDeclarations();
            if (defs != null && !defs.isEmpty()) {
                for (RfDefElement rfDefElement : defs) {
                    if (!this.fSpm.isFiltered(rfDefElement.getDefFile().getParserPath().path)) continue;
                    return true;
                }
            }
        } else if (o instanceof String) {
            return this.fSpm.isFiltered((String)o);
        }
        return false;
    }

    protected FileInfo computeFileInfo(String fileName) {
        FileInfo result;
        block18: {
            result = new FileInfo(fileName);
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(fileName));
                    String line = null;
                    boolean inComment = false;
                    while ((line = in.readLine()) != null) {
                        ++result.totalNofLines;
                        if ((line = line.trim()).startsWith("/*")) {
                            inComment = true;
                        }
                        if (line.contains("*/")) {
                            inComment = false;
                        }
                        if (line.startsWith("--")) {
                            ++result.commentNofLines;
                            continue;
                        }
                        if (line.length() == 0) {
                            ++result.emptyNofLines;
                            continue;
                        }
                        if (inComment) {
                            ++result.commentNofLines;
                            continue;
                        }
                        ++result.codeNofLines;
                        result.codeNofChars += line.length();
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (in == null) break block18;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private VhdlInfo computeElementInfo(RfNamedElement rfNamedElement) {
        VhdlInfo result = new VhdlInfo(rfNamedElement.getName());
        RfDefElement declaration = rfNamedElement.getDeclaration();
        if (declaration != null) {
            result.nofDefinitionLines.counter = declaration.getEndLine() - declaration.getStartLine() + 1;
        }
        return result;
    }

    public String getNature() {
        return "ro.amiq.vhdldt.VhdlNature";
    }

    protected String heading() {
        return "VHDL statistics";
    }

    protected IRfSingleLangProject getRfProject(IProject project) {
        return RfManager.getInstance().getRfProject(project);
    }

    protected List<ParserPath> getCompiledParserPaths(IRfSingleLangProject rfProject) {
        RfProject vhdlRfProject = (RfProject)rfProject;
        List<VhdlFileInstance> allCompiledFiles = vhdlRfProject.getFiles();
        return allCompiledFiles.stream().map(x -> x.getParserPath()).distinct().collect(Collectors.toList());
    }

    private static class VhdlArchitectureInfo
    extends VhdlInfo {
        public VhdlArchitectureInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Architectures Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class VhdlComponentInfo
    extends VhdlInfo {
        public VhdlComponentInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Components Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class VhdlConfigurationInfo
    extends VhdlInfo {
        public VhdlConfigurationInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Configurations Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class VhdlEntityInfo
    extends VhdlInfo {
        public VhdlEntityInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Entities Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class VhdlFunctionInfo
    extends VhdlInfo {
        public VhdlFunctionInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Functions Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class VhdlInfo
    extends Info {
        public RelevantInfo nofDefinitionLines;

        protected VhdlInfo(String elementName) {
            this.nofDefinitionLines = new RelevantInfo(elementName);
        }

        public void update(VhdlInfo info) {
            ++this.counter;
            this.nofDefinitionLines.update(info.nofDefinitionLines);
        }
    }

    private static class VhdlPackageInfo
    extends VhdlInfo {
        public VhdlPackageInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Packages Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class VhdlProcedureInfo
    extends VhdlInfo {
        public VhdlProcedureInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Procedures Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }
}

