/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.test;

import antlr.Token;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IOutlineTreeViewProvider;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.model.reflection.views.CompileOrderViewLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.VhdlEditorMessages;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRenameRefactorAction;
import ro.amiq.vhdldt.ui.refactor.rename.VhdlRenameDelegate;
import ro.amiq.vhdldt.ui.refactor.rename.VhdlRenameRefactorInfo;

@ForTestingOrDebuggingOnly
public class TestHelper
extends ro.amiq.dvt.test.TestHelper {
    private static TestHelper instance = new TestHelper();
    @ProductSafe
    public static IncrementalDeltaContainer fIncrementalDeltaContainer;
    public static IOutlineTreeViewProvider wrp;
    public static TypesViewLabelProvider wrp2;
    public static CompileOrderViewLabelProvider wrp6;
    private static List<Identifier> fIdentifiers;

    @ProductSafe
    public static final TestHelper getInstance() {
        return instance;
    }

    public TestHelper() {
        this.fPreferenceStore = VhdlPlugin.getDefault().getPreferenceStore();
    }

    public Object getTypesRoot() {
        return ro.amiq.dvt.test.TestHelper.getInstance().getTypesRoot();
    }

    public static int getOutlineItemsNumber() {
        Object[] roots = TestHelper.getOutlineData();
        if (roots != null && roots.length > 0) {
            return TestHelper.getOutlineItemsNumber(roots);
        }
        return 0;
    }

    private static int getOutlineItemsNumber(Object[] roots) {
        int count = roots.length;
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            Object[] children = TestHelper.getChildren(root);
            if (children != null && children.length > 0) {
                count += TestHelper.getOutlineItemsNumber(children);
            }
            ++n2;
        }
        return count;
    }

    static IOutlineTreeViewProvider getUIRfOutlineTreeViewProvider() {
        DVTLazyOutlinePage pssOutlinePage;
        ILabelProvider tmp;
        if (wrp == null && (tmp = (pssOutlinePage = (DVTLazyOutlinePage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getAdapter(IContentOutlinePage.class)).getLabelProvider()) instanceof IOutlineTreeViewProvider) {
            wrp = (IOutlineTreeViewProvider)tmp;
        }
        return wrp;
    }

    public String getText(Object wrapper) {
        return TestHelper.getUIRfOutlineTreeViewProvider().getText(wrapper);
    }

    public Image getImage(Object wrapper) {
        return TestHelper.getUIRfOutlineTreeViewProvider().getImage(wrapper);
    }

    public static Object[] getChildren(Object wrapper) {
        return TestHelper.getUIRfOutlineTreeViewProvider().getChildren(wrapper);
    }

    static TypesViewLabelProvider getUIRfTypesTreeViewProvider() {
        if (wrp2 == null) {
            wrp2 = new TypesViewLabelProvider();
        }
        return wrp2;
    }

    public String getTypesText(Object wrapper) {
        return TestHelper.getUIRfTypesTreeViewProvider().getText(wrapper);
    }

    public Image getTypesImage(Object wrapper) {
        return TestHelper.getUIRfTypesTreeViewProvider().getImage(wrapper);
    }

    public static Object[] getTypesChildren(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        IDVTElementWrapper wrapper2 = (IDVTElementWrapper)wrapper;
        if (wrapper2.hasChildren()) {
            return wrapper2.getChildren().toArray();
        }
        return null;
    }

    public static Object[] getDesignHierarchyChildren(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        IDVTElementWrapper wrapper2 = (IDVTElementWrapper)wrapper;
        if (wrapper2.hasChildren()) {
            return wrapper2.getChildren().toArray();
        }
        return null;
    }

    public static Image getImageByFieldName(String fieldName, Object with) {
        if (with instanceof IDVTElementWrapper) {
            Object element = ((IDVTElementWrapper)with).getRfElement();
            if (element instanceof IRfNamedElement) {
                return ((IRfNamedElement)element).testGetImage(fieldName);
            }
            if (element instanceof IRfDefElement) {
                return ((IRfDefElement)element).getNamedElement().testGetImage(fieldName);
            }
        }
        return null;
    }

    protected List<String> getFieldNameByDescriptor(Field[] fields, ImageDescriptor descriptor) {
        ArrayList<String> matches = new ArrayList<String>();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field != null && (field.getModifiers() & 1) != 0 && field.getType() == ImageDescriptor.class && field.get(null) == descriptor) {
                    matches.add(field.getName());
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        return matches;
    }

    public List<String> getImageDescriptors(Image image) {
        ArrayList<String> results = new ArrayList<String>();
        List descriptors = DVTImages.imageCache.getImageDescriptors(image);
        for (ImageDescriptor descriptor : descriptors) {
            results.addAll(this.getFieldNameByDescriptor(DVTImages.class.getDeclaredFields(), descriptor));
        }
        if (results.isEmpty()) {
            results.add("IMAGE_WAS_NOT_LOADED");
        }
        return results;
    }

    public static String getFieldNameByImage(Image image, String targetDescriptorName) {
        List<String> descriptorNames = TestHelper.getInstance().getImageDescriptors(image);
        String result = null;
        if (targetDescriptorName.equals("") && !descriptorNames.isEmpty()) {
            return descriptorNames.get(0);
        }
        for (String descriptorName : descriptorNames) {
            if (!targetDescriptorName.equals(descriptorName)) continue;
            result = descriptorName;
        }
        if (result == null) {
            result = "IMAGE_WAS_NOT_LOADED";
        }
        return result;
    }

    public int getCurrentLine() {
        DVTEditor editor = (DVTEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return editor.testGetCurrentLine();
    }

    public static void addNameConvention(String kind, String name, String description, String match, String pattern, boolean enabled, IProject project) throws IOException, CoreException {
        TestHelper.addNameConvention((String)"VHDL", (String)kind, (String)name, (String)description, (String)match, (String)pattern, (boolean)enabled, (IProject)project);
    }

    static CompileOrderViewLabelProvider getLoadOrderViewProvider() {
        if (wrp6 == null) {
            wrp6 = new CompileOrderViewLabelProvider();
        }
        return wrp6;
    }

    public static String getLoadOrderName(Object wrapper) {
        return TestHelper.getLoadOrderViewProvider().getText(wrapper);
    }

    public static Object[] getCompileOrderChildren(Object wrapper) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper instanceof IDVTElementWrapper && ((IDVTElementWrapper)wrapper).getChildren() != null) {
            return ((IDVTElementWrapper)wrapper).getChildren().toArray();
        }
        return null;
    }

    public static IDVTProject getVhdlProject(IProject iProject) {
        return VhdlModelManager.getInstance().getVhdlModel().getVhdlProject(iProject);
    }

    @ProductSafe
    public static void collectToken(Token token) {
        if (fIdentifiers == null) {
            return;
        }
        fIdentifiers.add(new Identifier(token));
    }

    public static void clearIdentifiers() {
        fIdentifiers.clear();
    }

    public static void initIdentifiers() {
        fIdentifiers = new ArrayList<Identifier>();
    }

    public static List<Identifier> getIdentifiers() {
        return fIdentifiers;
    }

    public static String doubleClick(int dbClickLineNo, int dbClickOffset, int refStartLineNo, int refStartOffset, int refEndLineNo, int refEndOffset) {
        int actualEndOffset;
        int actualEndLineNo;
        int actualStartOffset;
        int actualStartLineNo;
        block3: {
            try {
                VhdlEditor editor = (VhdlEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                int dbCLickOffset = TestHelper.getInstance().computeOffset(editor, dbClickLineNo - 1, dbClickOffset - 1);
                VhdlSourceViewerConfiguration sourceViewerConfiguration = editor.testGetSourceViewerConfiguration();
                ISourceViewer sourceViewer = editor.testGetSourceViewer();
                ITextDoubleClickStrategy doubleClickStrategy = sourceViewerConfiguration.getDoubleClickStrategy(sourceViewer, "__dftl_partition_content_type");
                editor.selectAndReveal(dbCLickOffset, 1);
                doubleClickStrategy.doubleClicked((ITextViewer)sourceViewer);
                Point selectedRange = sourceViewer.getSelectedRange();
                actualStartLineNo = document.getLineOfOffset(selectedRange.x) + 1;
                actualStartOffset = selectedRange.x - document.getLineOffset(actualStartLineNo - 1);
                actualEndLineNo = document.getLineOfOffset(selectedRange.x + selectedRange.y) + 1;
                actualEndOffset = selectedRange.x + selectedRange.y - document.getLineOffset(actualEndLineNo - 1);
                int refStartOffsetInDoc = TestHelper.getInstance().computeOffset(editor, refStartLineNo - 1, refStartOffset - 1);
                int refLength = TestHelper.getInstance().computeLengthInDocument(editor, refStartLineNo - 1, refStartOffset - 1, refEndLineNo - 1, refEndOffset - 1);
                if (selectedRange.x != refStartOffsetInDoc || selectedRange.y != refLength) break block3;
                return "";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return "Mismatch for double click at  [" + dbClickLineNo + ", " + dbClickOffset + "] :\n" + "Selection reference was : start [" + refStartLineNo + ", " + refStartOffset + "], end [" + refEndLineNo + ", " + refEndOffset + "]\n" + "Actual  selection was    : start [" + actualStartLineNo + ", " + actualStartOffset + "], end [" + actualEndLineNo + ", " + actualEndOffset + "]\n";
    }

    public static int selectText(int startLineNo, int startLineCol, int endLineNo, int endLineCol) {
        int selectedTextLength = 0;
        VhdlEditor editor = (VhdlEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        int startSelOffset = TestHelper.getInstance().computeOffset(editor, startLineNo - 1, startLineCol - 1);
        int endSelOffset = TestHelper.getInstance().computeOffset(editor, endLineNo - 1, endLineCol - 1);
        selectedTextLength = endSelOffset - startSelOffset;
        editor.selectAndReveal(startSelOffset, selectedTextLength);
        return selectedTextLength;
    }

    public static boolean hasArchitecture(IProject project, String architecture) {
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        List<RfNamedElement> architectures = rfProj.getAllArchitectures();
        for (RfNamedElement arch : architectures) {
            if (!arch.getName().equals(architecture)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasArchitectureField(IProject project, String architecture, String signal, String signalType) {
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        List<RfNamedElement> architectures = rfProj.getAllArchitectures();
        RfNamedElement rfArch = null;
        for (RfNamedElement arch : architectures) {
            if (!arch.getName().equals(architecture)) continue;
            rfArch = (RfArchitecture)arch;
            break;
        }
        if (rfArch == null) {
            return false;
        }
        Collection<? extends IRfNamedElement> signals = rfArch.getAllSignals();
        for (IRfNamedElement iRfNamedElement : signals) {
            if (!iRfNamedElement.getName().equals(signal)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEntity(IProject project, String entity) {
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        List<RfNamedElement> entities = rfProj.getAllEntities();
        for (RfNamedElement ent : entities) {
            if (!ent.getName().equals(entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEntityPort(IProject project, String entity, String port, String portDir, String portType) {
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        RfNamedElement rfEntity = null;
        List<RfNamedElement> entities = rfProj.getAllEntities();
        for (RfNamedElement ent : entities) {
            if (!ent.getName().equals(entity)) continue;
            rfEntity = (RfEntity)ent;
            break;
        }
        if (rfEntity == null) {
            return false;
        }
        List<RfPort> ports = rfEntity.getPortsWithPrefix("", 2, true);
        for (RfPort rfPort : ports) {
            if (!port.equals(rfPort.getName()) || !portDir.equals(rfPort.getDirection()) || !portType.equals(rfPort.getAssociatedTypeName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasComponent(IProject project, String architecture, String component) {
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        List<RfNamedElement> components = rfProj.getAllComponents();
        for (RfNamedElement comp : components) {
            RfNamedElement arch;
            if (!comp.getName().equals(component) || !(arch = comp.getEnclosingScope()).getName().equals(architecture)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasComponentPort(IProject project, String architecture, String component, String port, String portDir, String portType) {
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        List<RfNamedElement> components = rfProj.getAllComponents();
        RfNamedElement rfComp = null;
        for (RfNamedElement comp : components) {
            RfNamedElement arch;
            if (!comp.getName().equals(component) || !(arch = comp.getEnclosingScope()).getName().equals(architecture)) continue;
            rfComp = (RfComponent)comp;
            break;
        }
        if (rfComp == null) {
            return false;
        }
        List<RfPort> ports = rfComp.getPortsWithPrefix("", 2, true);
        for (RfPort rfPort : ports) {
            if (!port.equals(rfPort.getName()) || !portDir.equals(rfPort.getDirection()) || !portType.equals(rfPort.getAssociatedTypeName())) continue;
            return true;
        }
        return false;
    }

    public static IPreferenceStore getPreferenceStore() {
        return TestHelper.getInstance().fPreferenceStore;
    }

    public static void executeRefactoringRename(DVTEditor editor) {
        VhdlRenameRefactorAction rra = new VhdlRenameRefactorAction(VhdlEditorMessages.getResourceBundle(), "RefactorRename.", editor);
        rra.run();
    }

    public static IStatus checkNewName(IFile file, IDocument document, int offset, String newName, DVTEditor editor) {
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(file, document, offset);
        VhdlRenameRefactorInfo renameInfo = new VhdlRenameRefactorInfo(project, namedElementAndScope, (ITextEditor)editor);
        renameInfo.setNewName(newName);
        VhdlRenameDelegate delegate = new VhdlRenameDelegate(renameInfo, false);
        delegate.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        return delegate.checkNewName();
    }

    public static class Identifier {
        private String text;
        private String filename;
        private int line;
        private int column;

        public Identifier(Token token) {
            this.text = token.getText();
            this.line = token.getLine();
            this.column = token.getColumn();
            this.filename = token.getFilename();
        }

        public String getFilename() {
            return this.filename;
        }

        public String getText() {
            return this.text;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

