/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.preferences.OverlayPreferenceStore;
import ro.amiq.dvt.ui.preferences.theme.IThemePreviewContributor;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlDocumentSetupParticipant;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.VhdlStyle;
import ro.amiq.vhdldt.ui.preferences.VhdlSourcePreviewerUpdater;

public class VhdlThemePreviewContributor
implements IThemePreviewContributor {
    private DVTPreviewSourceViewer fPreviewViewer;
    private IPreferenceStore fPluginStore = VhdlPlugin.getDefault().getPreferenceStore();
    private OverlayPreferenceStore fOverlayStore = new OverlayPreferenceStore(VhdlPlugin.getDefault().getCombinedPreferenceStore(), this.createOverlayStoreKeys());
    private Control previewControl;

    public VhdlThemePreviewContributor() {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    public Control createLanguagePreviewer(Composite parent) {
        VhdlSourceViewerConfiguration configuration = new VhdlSourceViewerConfiguration(null);
        this.fPreviewViewer = new DVTPreviewSourceViewer(parent, 2560);
        this.fPreviewViewer.setPreferenceStore(VhdlPlugin.getDefault().getCombinedPreferenceStore());
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingsPreviewCode.vhd");
        Document document = new Document(content);
        VhdlDocumentSetupParticipant docSetup = new VhdlDocumentSetupParticipant();
        docSetup.setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        VhdlSourcePreviewerUpdater.registerPreviewer((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)this.fOverlayStore);
        this.addAllSemanticPositions((IDocument)document);
        this.previewControl = this.fPreviewViewer.getControl();
        return this.previewControl;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.x_template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.default.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_task.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_pragma.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_hyperlink.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.javadoc_tags.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyword.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.attributes.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.attributes.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.attributes.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.types.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.types.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.types.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.number.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.string.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.PREPROC, "highlight.preproc.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.template_id.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_method.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_method.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_method.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_out_port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_enum_item.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_enum_item.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_enum_item.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_constant.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_signal.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_signal.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_signal.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_record_element.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_record_element.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_record_element.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.end_label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.end_label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.end_label.italic"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuilder buffer;
        block15: {
            buffer = new StringBuilder(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append("\n");
                    }
                }
                catch (IOException io) {
                    DVTLogger.INSTANCE.logError((Throwable)io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private void addAllSemanticPositions(IDocument document) {
        try {
            if (!document.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            } else {
                document.removePositionCategory("SEMANTIC_HIGHLIGHT");
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            }
            HashMap positions = new HashMap();
            DVTHlUtils.addPosition((IDocument)document, (int)52, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)8, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)18, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)23, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)78, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)91, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)118, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)142, (HighlightKind)HighlightKind.RECORD_ELEMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)160, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)200, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)211, (HighlightKind)HighlightKind.VHDL_ENUM_ITEMS, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)218, (HighlightKind)HighlightKind.VHDL_ENUM_ITEMS, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)226, (HighlightKind)HighlightKind.VHDL_ENUM_ITEMS, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)245, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)255, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)271, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)408, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)467, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)422, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)442, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)525, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)635, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)649, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)618, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)702, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)708, (HighlightKind)HighlightKind.ATTRIBUTE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)739, (HighlightKind)HighlightKind.VHDL_ENUM_ITEMS, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)809, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)795, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)552, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)562, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)578, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)610, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)680, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)688, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)752, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)761, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1106, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1089, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)963, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)873, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)883, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)888, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)991, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1003, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1046, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1061, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1074, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1526, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1539, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1170, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1194, (HighlightKind)HighlightKind.SIGNAL, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1209, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1328, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1311, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1389, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1372, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1230, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1259, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1267, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1289, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1350, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1484, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1505, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1514, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1456, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPositionsToDocument((IDocument)document, positions.values());
            DVTHlUtils.notifyListeners((IDocument)document, null);
            this.fPreviewViewer.invalidateTextPresentation();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getLanguage() {
        return "VHDL";
    }

    public OverlayPreferenceStore getOverlayPreferenceStore() {
        return this.fOverlayStore;
    }

    public IPreferenceStore getPluginPreferenceStore() {
        return this.fPluginStore;
    }

    public String getPluginId() {
        return "ro.amiq.vhdldt";
    }

    public void cancelPreview() {
        VhdlStyle.getInstance().updateTokens();
    }

    public Integer getPreviewOrderId() {
        return 1;
    }

    public void updateBackground(Color color) {
        if (this.fPreviewViewer == null) {
            return;
        }
        if (this.fPreviewViewer.getTextWidget() == null) {
            return;
        }
        DVTColorUtil.INSTANCE.setBackground((Control)this.fPreviewViewer.getTextWidget(), color, true);
    }

    public Control getPreviewControl() {
        return this.previewControl;
    }
}

