/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.model.reflection.views.DVTQuickViewersUtil;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.actions.AMenuCommandDelegate;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.waveviewer.AddToWaveMode;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.RfVariableDef;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfGUIReferencesUtils;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.VhdlQuickViewersUtil;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowInstancesAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowInstancesInDesignHierarchyViewAction;
import ro.amiq.vhdldt.ui.search.ReferenceSearchPageInput;

public class MenuCommandDelegate
extends AMenuCommandDelegate {
    public boolean canHandle(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        return wrapper instanceof RfTreeElementWrapper || wrapper instanceof DVTTreeElementWrapper && wrapper.getLanguageKind() == LanguageKind.VHDL || wrapper.getRfElement() instanceof RfTreeElementWrapper || wrapper.getRfElement() instanceof RfVariable || wrapper.getRfElement() instanceof DummyPort;
    }

    public boolean showUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowUsages(namedElement)) {
            return false;
        }
        try {
            IProject project = wrapper.getProject();
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
            ReferenceSearchPageInput input = new ReferenceSearchPageInput(namedElement, false, false, true, FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false), null, -1, null);
            ReferencesInWorkspaceAction.searchReferencesHelper(input, false);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public boolean showLayers(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowLayers(namedElement)) {
            return false;
        }
        VhdlQuickViewersUtil.getInstance().updateLayersView(((RfNamedElement)namedElement).getEnclosingScope(), (RfNamedElement)namedElement, wrapper.getProject(), DVTViewEvent.EventKind.TRIGGER, "context_menu", true, true);
        return true;
    }

    public boolean showDesignHierarchy(IDVTElementWrapper wrapper, String partID) {
        IRfNamedElement namedElement = DesignUtils.toGenericDesignElement((IRfNamedElement)this.getNamedElement(wrapper));
        if (!this.canShowDesignHierarchy(namedElement)) {
            return false;
        }
        DVTQuickViewersUtil.updateNewDesignHierarchyViewer((IRfNamedElement)namedElement);
        return true;
    }

    public boolean showVerificationHierarchy(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showTypeHierarchy(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showDiagram(IDVTElementWrapper wrapper, String partID) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowDiagram(wrapper)) {
            return false;
        }
        if (DesignUtils.getDesignKind((Object)namedElement) != IRfNamedElement.ElementKind.UNKNOWN) {
            return this.showDesignDiagramWithBreadcrumb(wrapper, partID, namedElement);
        }
        if ("ro.amiq.dvt.ui.views.LazyDesignHierarchyView".equals(partID)) {
            if (this.canShowConnectionsDiagram(namedElement)) {
                return this.showConnectionsDiagram(wrapper);
            }
            return false;
        }
        if (namedElement instanceof IRfFieldElement && !(namedElement instanceof IRfInstanceElement)) {
            return this.showFSMDiagram(wrapper, namedElement, RfFunction.class);
        }
        return false;
    }

    public boolean showConnectionsDiagram(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowConnectionsDiagram(namedElement)) {
            return false;
        }
        if (namedElement instanceof IRfPortElement && wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.PORT_INSTANCE) != null) {
            return this.showConnectionsOnPortDiagram(wrapper, (IRfPortElement)namedElement);
        }
        return false;
    }

    public boolean showImports(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean copyInView(IDVTElementWrapper wrapper, String partID) {
        String itemName = "";
        TreeItem item = (TreeItem)wrapper.getItem();
        if (item == null) {
            if (DVTLazyViewUtils.ALL_LAZY_VIEWS.contains(partID)) {
                IViewPart viewById = ViewsUtils.getViewById((String)partID, (boolean)false);
                if (!(viewById instanceof IDVTLazyView)) {
                    return false;
                }
                ILabelProvider labelProvider = ((IDVTLazyView)viewById).getLabelProvider();
                itemName = labelProvider.getText((Object)wrapper);
            } else {
                itemName = "org.eclipse.ui.views.ContentOutline".equals(partID) ? (String)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TO_STRING) : wrapper.getRfElement().toString();
            }
        } else {
            itemName = item.getText();
        }
        Utils.copyToClipboard((String)itemName, (int)3);
        return true;
    }

    public boolean showUVMSequenceTree(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showCallHierarchy(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showPDDefinition(IDVTElementWrapper wrapper) {
        if (!this.canShowPDDefinition(wrapper)) {
            return false;
        }
        IProject project = wrapper.getProject();
        if (project == null) {
            return false;
        }
        DVTPFInfo pdInfo = this.getPDForInstance(wrapper);
        if (pdInfo == null) {
            return false;
        }
        GoToInfo.of((String)pdInfo.getFilePath(), (int)-1, (int)-1, (int)pdInfo.getStartLine(), (String)pdInfo.getPowerDomainName(), (LanguageKind)LanguageKind.PF).open(project, true);
        return true;
    }

    public boolean showSNDiagram(IDVTElementWrapper wrapper) {
        if (!this.canShowSNDiagram(wrapper)) {
            return false;
        }
        IProject project = wrapper.getProject();
        if (project == null) {
            return false;
        }
        DDesignEditorFactory.getInstance().newPowerDomainsDiagram(project, null).openEditor();
        return true;
    }

    public boolean canShowUsages(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        return !(namedElement instanceof DummyPort);
    }

    public boolean canShowLayers(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof IRfPortElement) {
            return false;
        }
        return namedElement instanceof RfEntity || namedElement instanceof RfArchitecture || namedElement instanceof RfFunction;
    }

    public boolean canShowDesignHierarchy(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof IRfPortElement) {
            return false;
        }
        return VhdlQuickViewersUtil.matchTypeForDesignHierarchyViewer(DesignUtils.toGenericDesignElement((IRfNamedElement)namedElement)) != 0;
    }

    public boolean canShowVerificationHierarchy(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowHierarchy(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowDiagram(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (namedElement instanceof IRfFieldElement && !(namedElement instanceof IRfInstanceElement)) {
            return true;
        }
        return DesignUtils.getDesignElement((IRfNamedElement)namedElement, (Object)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH)) != null;
    }

    public boolean canCopyInView(IRfNamedElement namedElement) {
        return true;
    }

    public boolean canShowUVMSequenceTree(IRfNamedElement namedElement) {
        return false;
    }

    public IRfNamedElement getNamedElement(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        Object element = wrapper.getRfElement();
        if (element instanceof RfPackageBody) {
            return ((RfPackageBody)element).getPackage();
        }
        RfWNamedElementAndScope rfElement = (RfWNamedElementAndScope)wrapper.getRfElement(RfWNamedElementAndScope.class);
        if (rfElement != null) {
            return rfElement.getIRfNamedElement();
        }
        return super.getNamedElement(wrapper);
    }

    public boolean canShowImports(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showConstraints(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showEmitters(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowConstraints(IRfNamedElement namedElement, boolean onlyRand) {
        return false;
    }

    public boolean canShowCallHierarchy(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowComponentDiagram(IDVTElementWrapper namedElement) {
        return false;
    }

    public boolean canShowPDDefinition(IDVTElementWrapper wrapper) {
        return this.getPDForInstance(wrapper) != null;
    }

    public boolean canShowSNDiagram(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (namedElement == null || !(namedElement instanceof IRfDesignElement)) {
            return false;
        }
        DVTPFModel pfModel = this.getPfModel(wrapper);
        return pfModel != null && pfModel.hasPowerDomains();
    }

    private DVTPFInfo getPDForInstance(IDVTElementWrapper wrapper) {
        DVTPFModel pfModel = this.getPfModel(wrapper);
        if (pfModel == null || !pfModel.hasPowerDomains()) {
            return null;
        }
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (namedElement == null) {
            return null;
        }
        return pfModel.getPDInfoForInstance(wrapper.getInstancePath());
    }

    private DVTPFModel getPfModel(IDVTElementWrapper wrapper) {
        IProject project = wrapper.getProject();
        if (project == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        return mixedLangProject.getPFModel();
    }

    public boolean showInstances(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!this.canShowInstances(rfElement)) {
            return false;
        }
        ShowInstancesAction.showInstances(rfElement);
        return true;
    }

    public boolean showInstancesInDH(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!this.canShowInstances(rfElement)) {
            return false;
        }
        ShowInstancesInDesignHierarchyViewAction.showInstancesInDHFor(rfElement);
        return true;
    }

    public boolean showAllInstancesInDH(IDVTElementWrapper wrapper) {
        return this.showInstancesInDH(wrapper);
    }

    public boolean canShowConnectionsDiagram(IRfNamedElement namedElement) {
        return namedElement instanceof IRfPortElement;
    }

    public boolean showReadersUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!RfSearchUtils.canBeReadOrWritten((IRfNamedElement)rfElement)) {
            return false;
        }
        IRfSingleLangProject rfProject = rfElement.getRfProject();
        if (rfProject == null) {
            return false;
        }
        VHDLRfGUIReferencesUtils.showReadersUsages(rfElement, rfProject.getProject(), null, -1, null);
        return true;
    }

    public boolean showWritersUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!RfSearchUtils.canBeReadOrWritten((IRfNamedElement)rfElement)) {
            return false;
        }
        IRfSingleLangProject rfProject = rfElement.getRfProject();
        if (rfProject == null) {
            return false;
        }
        VHDLRfGUIReferencesUtils.showWritersUsages(rfElement, rfProject.getProject(), null, -1, null);
        return true;
    }

    public boolean showConnectedTLMPorts(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowConnectedTLMPorts(IRfNamedElement namedElement) {
        return false;
    }

    public boolean showScenarioDiagram(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean canShowScenarioDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showActivityDiagram(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean canShowActivityDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowWaveViewerFieldActions(IDVTElementWrapper wrapper) {
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfVariableDef)) {
            return false;
        }
        IProject project = ((RfVariableDef)element).getRfProject().getProject();
        if (project == null) {
            return false;
        }
        return DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project);
    }

    public boolean addToWaveViewer(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        VhdlEditor vhdlEditor = this.getActiveVhdlEditor();
        if (vhdlEditor == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfVariableDef)) {
            return false;
        }
        int offset = ((RfVariableDef)element).getStartOffset();
        RfWNamedElementAndScope rfElementAndScope = this.getRfElementAndScope(vhdlEditor, offset);
        if (rfElementAndScope == null) {
            return false;
        }
        DVTWaveViewIDEFactory.getInstance().addToWaveFromEditor((IDVTBreadcrumbHost)vhdlEditor, (IRfNamedElementAndScope)rfElementAndScope, offset, AddToWaveMode.SELECTED_SIGNALS);
        return true;
    }

    public boolean addWithDriversToWaveViewer(IDVTElementWrapper wrapper) {
        return this.addWithDriversLoadsToWaveViewer(wrapper, RWKind.WRITE);
    }

    public boolean addWithLoadsToWaveViewer(IDVTElementWrapper wrapper) {
        return this.addWithDriversLoadsToWaveViewer(wrapper, RWKind.READ);
    }

    private boolean addWithDriversLoadsToWaveViewer(IDVTElementWrapper wrapper, RWKind rwKind) {
        if (wrapper == null) {
            return false;
        }
        VhdlEditor vhdlEditor = this.getActiveVhdlEditor();
        if (vhdlEditor == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfVariableDef)) {
            return false;
        }
        int offset = ((RfVariableDef)element).getStartOffset();
        RfWNamedElementAndScope rfElementAndScope = this.getRfElementAndScope(vhdlEditor, offset);
        if (rfElementAndScope == null) {
            return false;
        }
        IProject project = vhdlEditor.getProject();
        if (project == null) {
            return false;
        }
        DVTWaveViewIDEFactory.getInstance().addDriversLoadsToWaveFromEditor((IDVTBreadcrumbHost)vhdlEditor, (IRfNamedElementAndScope)rfElementAndScope, offset, rwKind, project);
        return true;
    }

    public boolean canShowWaveViewerInstanceActions(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (element == null) {
            return false;
        }
        RfNamedElement namedElement = ((RfDefElement)element).getNamedElement();
        if (!(namedElement instanceof RfInstance)) {
            return false;
        }
        IRfNamedElement associatedType = ((RfInstance)namedElement).getAssociatedType();
        boolean isComponent = associatedType instanceof RfComponent;
        boolean isEntity = associatedType instanceof RfEntity;
        boolean isArchitecture = associatedType instanceof RfArchitecture;
        if (!(isComponent || isEntity || isArchitecture)) {
            return false;
        }
        IProject lastSelectedProject = namedElement.getRfProject().getProject();
        if (lastSelectedProject == null) {
            return false;
        }
        return DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(lastSelectedProject);
    }

    public boolean addInstancePortsToWaveViewer(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        VhdlEditor vhdlEditor = this.getActiveVhdlEditor();
        if (vhdlEditor == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfDefElement)) {
            return false;
        }
        int offset = ((RfDefElement)element).getStartOffset();
        RfWNamedElementAndScope rfElementAndScope = this.getRfElementAndScope(vhdlEditor, offset);
        if (rfElementAndScope == null) {
            return false;
        }
        ElementPath elementPath = DVTWaveViewIDEFactory.getInstance().getSignalElementPathInEditor((IRfNamedElementAndScope)rfElementAndScope, (IDVTBreadcrumbHost)vhdlEditor, offset);
        if (elementPath == null) {
            return false;
        }
        RfNamedElement namedElement = ((RfDefElement)element).getNamedElement();
        if (!(namedElement instanceof RfInstance)) {
            return false;
        }
        List ports = DesignUtils.getPorts((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)namedElement), (boolean)false, new HashMap());
        if (ports == null || ports.isEmpty()) {
            return false;
        }
        ArrayList<String> portsNames = new ArrayList<String>();
        for (IRfPortElement port : ports) {
            String portName = port.getName();
            if (portName == null || portName.isEmpty()) continue;
            portsNames.add(portName);
        }
        if (portsNames.isEmpty()) {
            return false;
        }
        WaveDiagramEditor waveEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(vhdlEditor.getProject());
        if (waveEditor == null) {
            return false;
        }
        List signalsWrappers = DVTVCDUtils.getSignalsWrappers((WaveDiagramEditor)waveEditor);
        if (signalsWrappers == null || signalsWrappers.isEmpty()) {
            return false;
        }
        DVTWaveViewIDEFactory.getInstance().addToWave(waveEditor, elementPath, portsNames, signalsWrappers);
        return true;
    }

    public boolean addAllInstanceSignalsToWaveViewer(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        VhdlEditor vhdlEditor = this.getActiveVhdlEditor();
        if (vhdlEditor == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfDefElement)) {
            return false;
        }
        int offset = ((RfDefElement)element).getStartOffset();
        RfWNamedElementAndScope rfElementAndScope = this.getRfElementAndScope(vhdlEditor, offset);
        if (rfElementAndScope == null) {
            return false;
        }
        ElementPath elementPath = DVTWaveViewIDEFactory.getInstance().getSignalElementPathInEditor((IRfNamedElementAndScope)rfElementAndScope, (IDVTBreadcrumbHost)vhdlEditor, offset);
        if (elementPath == null) {
            return false;
        }
        DVTWaveViewIDEFactory.getInstance().addAllSignalsInPathToWave(elementPath);
        return true;
    }

    private VhdlEditor getActiveVhdlEditor() {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (!(activeEditor instanceof VhdlEditor)) {
            return null;
        }
        return (VhdlEditor)activeEditor;
    }

    private RfWNamedElementAndScope getRfElementAndScope(VhdlEditor vhdlEditor, int offset) {
        IFile currentFile = vhdlEditor.getCurrentFile();
        if (currentFile == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getDocument((ITextEditor)vhdlEditor);
        if (document == null) {
            return null;
        }
        return RfUtils.getRfElement(currentFile, document, offset);
    }
}

