/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;

public class ToggleMarkOccurrencesAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public ToggleMarkOccurrencesAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor, 2);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = VhdlPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
                boolean checked = this.fStore.getBoolean("markOccurrences");
                this.valueChanged(checked);
            }
        } else if (this.fStore != null) {
            this.setChecked(false);
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    public void run() {
        boolean checked = this.isChecked();
        this.fStore.setValue("markOccurrences", checked);
    }

    public void update() {
        this.setEnabled(this.getTextEditor() != null);
    }

    private void valueChanged(boolean on) {
        VhdlEditor editor = (VhdlEditor)this.getTextEditor();
        editor.enableOccurrenceAnnotations(on);
        if (this.isChecked() != on) {
            this.setChecked(on);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("markOccurrences")) {
            this.valueChanged(Boolean.parseBoolean(event.getNewValue().toString()));
        }
    }
}

