/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSerializerRepo;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfGeneratesContainer;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.ui.editor.VHDLScopeBreadcrumbUtilsCommon;

public class VHDLScopeBreadcrumbUtils
extends VHDLScopeBreadcrumbUtilsCommon {
    private static VHDLScopeBreadcrumbUtils INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScopeBreadcrumbUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VHDLScopeBreadcrumbUtils();
            }
        }
        return INSTANCE;
    }

    public List<IRfBreadcrumbElement> computeScopeChildren(IRfBreadcrumbElement scope, IProject project, int limit) {
        if (scope == null) {
            return null;
        }
        if (((IRfNamedElement)scope).getSignature().equals("ro.amiq.vhdldt.VhdlNature")) {
            return this.computeValidLibsOrPacks(project);
        }
        if (scope instanceof RfInstance) {
            return DesignUtils.getPorts((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)((IRfNamedElement)scope)), (boolean)false, null);
        }
        if (scope instanceof RfType && ((IRfAssociatedType)scope).getAssociatedType() != null) {
            scope = ((IRfAssociatedType)scope).getAssociatedType();
        }
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        if (scope instanceof RfType && ((RfType)scope).isProtected()) {
            this.computeMethods(result, scope);
            return result;
        }
        if (scope instanceof RfType) {
            List<RfEnum> enums = ((RfType)scope).getEnclosingScope().getLocalMembers(RfEnum.class);
            if (enums != null) {
                Iterator<RfEnum> iterator = enums.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getParentEnumTypeName().equals(scope.getName())) continue;
                    iterator.remove();
                }
            }
            if (enums != null) {
                return enums.stream().filter(element -> !element.isPredefined()).collect(Collectors.toList());
            }
        }
        if (!(scope instanceof IRfScopeElement)) {
            return new ArrayList<IRfBreadcrumbElement>();
        }
        this.computeMethods(result, scope);
        this.computeLibChildren(result, scope);
        return result;
    }

    private void computeLibChildren(List<IRfNamedElement> result, IRfBreadcrumbElement scope) {
        ArrayList<RfPackageBody> packageBodies = new ArrayList<RfPackageBody>();
        ArrayList<IRfNamedElement> configs = new ArrayList<IRfNamedElement>();
        for (IRfNamedElement element : result) {
            if (element instanceof RfPackage && ((RfPackage)element).hasPackageBody()) {
                packageBodies.add(((RfPackage)element).getPackageBody());
                continue;
            }
            if (!(scope instanceof RfLibrary) || !(element instanceof RfConfiguration)) continue;
            configs.add(element);
        }
        result.addAll(packageBodies);
        result.removeAll(configs);
    }

    private void computeMethods(List<IRfNamedElement> result, IRfBreadcrumbElement scope) {
        ((IRfScopeElement)scope).getElementsWithPrefix(result, "", 2, 1, false, null, this.getScopeElementFilter((IRfNamedElement)scope));
        List<RfFunctionsHolder> functionHolders = ((IRfScope)scope).getFunctionHoldersWithPrefix("", 2, true);
        for (RfFunctionsHolder holder : functionHolders) {
            List<RfNamedElement> localMembers;
            if (holder == null || (localMembers = holder.getLocalMembers(RfNamedElement.class)) == null) continue;
            for (RfNamedElement element : localMembers) {
                if (element == null || element.isPredefined() || !scope.equals(element.getEnclosingScope())) continue;
                result.add(element);
            }
        }
    }

    protected List<IRfBreadcrumbElement> computeValidLibsOrPacks(IProject project) {
        ArrayList<IRfBreadcrumbElement> validLibs = new ArrayList<IRfBreadcrumbElement>();
        if (project == null) {
            return validLibs;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return validLibs;
        }
        Collection<RfLibrary> rfLibraries = rfProject.getLibraries();
        if (rfLibraries == null || rfLibraries.isEmpty()) {
            return validLibs;
        }
        ArrayList<RfLibrary> libraries = new ArrayList<RfLibrary>(rfLibraries);
        for (RfLibrary lib : libraries) {
            List<RfNamedElement> members;
            if (lib.isNonTopFilesLibrary() && ((members = rfProject.getLocalTypes(lib, false, false, false)) == null || members.isEmpty()) || lib.isPredefined()) continue;
            validLibs.add((IRfBreadcrumbElement)lib);
        }
        return validLibs;
    }

    private IRfElementFilter getScopeElementFilter(final IRfNamedElement parentScope) {
        return new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (parentScope instanceof RfFunction) {
                    return false;
                }
                if (candidate instanceof RfLibrary && ((RfLibrary)candidate).isPredefined()) {
                    return false;
                }
                if (candidate instanceof RfVariable && ((RfVariable)candidate).isArgument()) {
                    return false;
                }
                if (parentScope instanceof RfArchitecture && candidate.getEnclosingScope() instanceof RfEntity) {
                    return false;
                }
                if (parentScope instanceof RfEntity && candidate.getEnclosingScope() instanceof RfArchitecture) {
                    return false;
                }
                if (parentScope instanceof RfConfiguration && candidate.getEnclosingScope() instanceof RfEntity) {
                    return false;
                }
                if (parentScope instanceof RfEntity && candidate.getEnclosingScope() instanceof RfConfiguration) {
                    return false;
                }
                if (parentScope instanceof RfConfiguration && candidate.getEnclosingScope() instanceof RfArchitecture) {
                    return false;
                }
                if (parentScope instanceof RfArchitecture && candidate.getEnclosingScope() instanceof RfConfiguration) {
                    return false;
                }
                if (candidate instanceof RfEnum && !(parentScope instanceof RfScalarType)) {
                    return false;
                }
                if (candidate instanceof RfFunctionsHolder) {
                    return false;
                }
                return candidate instanceof RfLibrary || candidate instanceof RfPackage || candidate instanceof RfPackageBody || candidate instanceof RfEntity || candidate instanceof RfType || candidate instanceof RfTypeBody || candidate instanceof RfFunction || candidate instanceof RfActionBlock || candidate instanceof RfInstance || candidate instanceof RfEnum || candidate instanceof RfPort || candidate instanceof RfVariable || candidate instanceof RfArchitecture || candidate instanceof RfBlock || candidate instanceof RfGeneratesContainer || candidate instanceof RfComponent || candidate instanceof RfConfiguration;
            }

            public int resultMaxSize() {
                return Integer.MAX_VALUE;
            }

            public boolean allowEnumElement() {
                return false;
            }
        };
    }

    public String getNameAdditionalInfo(IRfBreadcrumbElement element, boolean isForDropDown) {
        if (!isForDropDown) {
            return null;
        }
        if (!(element instanceof RfFunction)) {
            return null;
        }
        boolean isOverloaded = this.isOverloaded((RfFunction)element);
        if (isOverloaded) {
            return this.getFunctionSignatureForBC((RfFunction)element);
        }
        return null;
    }

    private boolean isOverloaded(RfFunction element) {
        boolean isOverloaded = false;
        RfNamedElement enclosingScope = element.getEnclosingScope();
        List<RfFunctionsHolder> functionHolders = enclosingScope.getFunctionHoldersWithPrefix("", 2, true);
        block0: for (RfFunctionsHolder holder : functionHolders) {
            List<RfFunction> localMembers = holder.getLocalMembers(RfFunction.class);
            int noOfFunctions = 0;
            boolean foundFunction = false;
            for (RfFunction member : localMembers) {
                if (member == null) continue;
                ++noOfFunctions;
                if (member.equals(element)) {
                    foundFunction = true;
                }
                if (!foundFunction || noOfFunctions <= 1) continue;
                isOverloaded = true;
                break block0;
            }
        }
        return isOverloaded;
    }

    private String getFunctionSignatureForBC(RfFunction element) {
        String typeName = element.getAssociatedTypeName();
        return String.valueOf(element.getName()) + "(" + (element.hasArguments() ? element.getArgs(true, true, false) : "") + ")" + (typeName == null || typeName.isEmpty() ? "" : " : " + typeName);
    }

    public void openElement(IDVTBreadcrumbHost editor, Object scopeElement) {
        RfInstance instanceFromBreadcrumb = this.getInstanceFromBreadcrumb(editor);
        if (scopeElement instanceof IRfPortElement && instanceFromBreadcrumb != null) {
            DVTRfUtils.goToPortConnectionOrDeclaration((IRfNamedElement)((IRfNamedElement)scopeElement), (DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instanceFromBreadcrumb), null, (boolean)true);
            return;
        }
        DVTRfUtils.goToDeclaration((IRfNamedElement)((IRfNamedElement)scopeElement), (boolean)true);
    }

    private RfInstance getInstanceFromBreadcrumb(IDVTBreadcrumbHost editor) {
        AbstractBreadcrumbViewer breadcrumbViewer = editor.getBreadcrumbViewer(ScopeBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof ScopeBreadcrumbViewer)) {
            return null;
        }
        IRfBreadcrumbElement leafSegment = ((ScopeBreadcrumbViewer)breadcrumbViewer).getInput().getLeafSegment();
        if (!(leafSegment instanceof RfInstance)) {
            return null;
        }
        return (RfInstance)leafSegment;
    }

    public boolean isInsideMacro(Object element) {
        return false;
    }

    public boolean isRootItem(Object element) {
        if (!(element instanceof RfNamedElement)) {
            return false;
        }
        String language = ((IRfNamedElement)element).getSignature();
        return language != null && language.equals("ro.amiq.vhdldt.VhdlNature");
    }

    public boolean isFunction(Object element) {
        return element instanceof RfFunction;
    }

    public Image getImage(Object element) {
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        if (this.isRootItem(element)) {
            return null;
        }
        if (element instanceof RfFunctionsHolder) {
            return ((IRfNamedElement)((RfFunctionsHolder)element).getMembers().toArray()[0]).getImage();
        }
        return ((RfNamedElement)element).getImage();
    }

    public String getText(Object element, boolean isForDropdown) {
        String initialName = super.getText(element, isForDropdown);
        if (element instanceof RfTypeBody) {
            return String.valueOf(initialName) + " [body]";
        }
        return initialName;
    }

    public boolean isLibElement(IRfBreadcrumbElement selectedScope) {
        return selectedScope instanceof IRfLibraryElement;
    }

    public String getLanguageNature() {
        return "ro.amiq.vhdldt.VhdlNature";
    }

    public boolean isMacro(Object element) {
        return false;
    }

    public IRfBreadcrumbElement resolveFunctionHolder(IRfBreadcrumbElement selectedScope) {
        if (!(selectedScope instanceof RfFunctionsHolder)) {
            return selectedScope;
        }
        Collection<RfNamedElement> members = ((RfFunctionsHolder)selectedScope).getMembers();
        for (RfNamedElement member : members) {
            if (member == null) continue;
            return member;
        }
        return selectedScope;
    }

    public boolean isLibOrPackage(Object element) {
        return element instanceof IRfLibraryElement;
    }

    public HistoryItem createHistoryItem(IProject project, IRfNamedElement element) {
        return null;
    }

    protected IRfNamedElement getTypeHierarchyElement(IRfBreadcrumbElement element) {
        return null;
    }

    public IBreadcrumbSerializer getBreadcrumbSerializer() {
        return BreadcrumbSerializerRepo.getSerializer((LanguageKind)LanguageKind.VHDL, ScopeBreadcrumbSerializer.class);
    }

    public boolean copyQNExcludeParent(IRfScopeElement elementParent) {
        return elementParent instanceof RfProject;
    }

    public boolean getShowUnnamedActionBlocks() {
        return false;
    }

    public void setShowUnnamedActionBlocks(boolean value) {
    }

    public String getActionBlockName(IRfActionBlockElement element, boolean isForDropDown) {
        return null;
    }

    public String getAssertExpectName(Object element, boolean showAdditionalInfo) {
        return null;
    }

    public boolean isAnonymousElement(IRfBreadcrumbElement element) {
        return false;
    }

    public boolean isActionBlock(Object element) {
        return false;
    }

    public boolean isAssert(Object element) {
        return false;
    }
}

