/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.vhdldt.ui.editor.VhdlStyle;
import ro.amiq.vhdldt.ui.editor.rules.VhdlAttributesRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlFoldingZoneMarker;
import ro.amiq.vhdldt.ui.editor.rules.VhdlKeyWordRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlNumericRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlPreprocessRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlWhitespaceDetector;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class VhdlCodeScanner
extends DVTBaseScanner {
    private VhdlKeyWordRule fVhdlKeyWordRule;

    public VhdlCodeScanner(VhdlStyle style, int nofLinesFolding) {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new VhdlWhitespaceDetector()));
        rules.add(new VhdlAttributesRule(PrefConst.getVHDLLowercaseAttributes(), style.getToken("highlight.attributes")));
        this.fVhdlKeyWordRule = new VhdlKeyWordRule(PrefConst.getVHDLLowercaseKeywords(), PrefConst.getVHDLLowercaseTypes(), style, nofLinesFolding);
        DVTHlUtils.addListener((IHighlightListener)this.fVhdlKeyWordRule);
        rules.add(this.fVhdlKeyWordRule);
        rules.add(new VhdlPreprocessRule(style.getToken("highlight.preproc")));
        rules.add(new VhdlFoldingZoneMarker(nofLinesFolding));
        rules.add(new VhdlNumericRule(style.getToken("highlight.number")));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setNofLinesFolding(int nofLines) {
        if (this.fRules != null) {
            IRule[] iRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                IRule rule = iRuleArray[n2];
                if (rule instanceof VhdlFoldingZoneMarker) {
                    ((VhdlFoldingZoneMarker)rule).setNofLinesFolding(nofLines);
                }
                if (rule instanceof VhdlKeyWordRule) {
                    ((VhdlKeyWordRule)rule).setNofLinesFolding(nofLines);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        DVTHlUtils.removeListener((IHighlightListener)this.fVhdlKeyWordRule);
        super.dispose();
    }
}

