/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.CopyFileInfoAction;
import ro.amiq.dvt.ui.actions.CopyFileInfoKind;
import ro.amiq.dvt.ui.actions.DVTQuickMenuCreator;
import ro.amiq.dvt.ui.dnd.RfNamedElementTransfer;
import ro.amiq.dvt.ui.editor.DVTContentAssistAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTTextOperationAction;
import ro.amiq.dvt.ui.editor.actions.CopyHierarchyPathAction;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.editor.actions.ToggleMarkOccurrencesAction;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTContentAssistConstants;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationAction;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationContributionItem;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.search.ui.IBaseShowConstraintsAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowEmittersAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowInstancesAction;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfGUIEnclosingScopeUtils;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.views.VhdlQuickViewersUtil;
import ro.amiq.vhdldt.templates.TemplateMessages;
import ro.amiq.vhdldt.ui.actions.OpenDeclarationAction;
import ro.amiq.vhdldt.ui.editor.ToggleCommentAction;
import ro.amiq.vhdldt.ui.editor.VHDLDHBreadcrumbUtils;
import ro.amiq.vhdldt.ui.editor.VHDLScopeBreadcrumbUtils;
import ro.amiq.vhdldt.ui.editor.VhdlDocumentSetupParticipant;
import ro.amiq.vhdldt.ui.editor.VhdlEditorCommon;
import ro.amiq.vhdldt.ui.editor.VhdlEditorMessages;
import ro.amiq.vhdldt.ui.editor.VhdlFileDocumentProvider;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.actions.ReferencesInFileAction;
import ro.amiq.vhdldt.ui.editor.actions.ReferencesInProjectAction;
import ro.amiq.vhdldt.ui.editor.actions.ReferencesInWorkingSetAction;
import ro.amiq.vhdldt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowDiagramAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowInstancesAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowInstancesInDesignHierarchyViewAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowReadersUsagesAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowWritersUsagesAction;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRefactorAddGenericAction;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRefactorAddPortAction;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRefactorConnectInputAction;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRefactorConnectOutputAction;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRefactorExtractToVariableAction;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRenameAcrossDesignHierarchyRefactorAction;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRenameRefactorAction;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlAutoInstanceContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlContentAssistProcessorManager;
import ro.amiq.vhdldt.ui.editor.highlight.VhdlSemanticHighlighter;
import ro.amiq.vhdldt.ui.editor.hover.VhdlHoverSourceInformationPresenter;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfHyperlinkDetector;
import ro.amiq.vhdldt.ui.editor.lazy.outline.VhdlLazyOutlinePage;
import ro.amiq.vhdldt.ui.editor.lazy.outline.VhdlQuickLazyOutlineView;
import ro.amiq.vhdldt.ui.editor.pathmanager.VhdlDesignPathProvider;
import ro.amiq.vhdldt.wave.view.VhdlAddAllSignalsInDVTWaveViewEditorActionHandler;
import ro.amiq.vhdldt.wave.view.VhdlAddDriversToWaveViewTextEditorActionHandler;
import ro.amiq.vhdldt.wave.view.VhdlAddLoadsToWaveViewTextEditorActionHandler;
import ro.amiq.vhdldt.wave.view.VhdlAddPortsInDVTWaveViewEditorActionHandler;
import ro.amiq.vhdldt.wave.view.VhdlAddSignalToWaveViewTextEditorHandler;
import ro.amiq.vhdldt.wave.view.VhdlRevealInDVTWaveViewEditorAction;

public class VhdlEditor
extends VhdlEditorCommon {
    public static final String ID = "ro.amiq.vhdldt.ui.editor.VhdlEditor";
    private static final String TEMPLATE_PROPOSALS = "template_proposals_action";
    public static final String TOGGLE_COMMENT = "ro.amiq.vhdldt.ui.editor.ToggleComment";
    public static final String FORMAT_SOURCE = "ro.amiq.vhdldt.ui.editor.FormatSource";
    public static final String OPEN_HELP_SEARCH = "ro.amiq.vhdldt.ui.editor.OpenHelpSearch";
    public static final String TOGGLE_MARK_OCCURRENCES = "ro.amiq.vhdldt.ui.editor.ToggleMarkOccurrences";
    public static final String DEFINE_FOLDING_REGION = "ro.amiq.vhdldt.ui.editor.DefineFoldingRegion";
    public static final String EXPAND_FIRST_LEVEL = "ro.amiq.vhdldt.ui.editor.ExpandFirstLevel";
    public static final String EXPAND_ALL_LEVELS = "ro.amiq.vhdldt.ui.editor.ExpandAllLevels";
    public static final String COLLAPSE_ALL_LEVELS = "ro.amiq.vhdldt.ui.editor.CollapseAllLevels";
    public static final String FORWARD_END_OF_WORD = "ro.amiq.vhdldt.ui.editor.ForwardEndOfWord";
    public static final String BACKWARD_START_OF_WORD = "ro.amiq.vhdldt.ui.editor.BackwardStartOfWord";
    public static final String GOTO_PAIR_BRACKET = "ro.amiq.vhdldt.ui.editor.GoToPairBracket";
    public static final String TOGGLE_COLLAPSE_LINE = "ro.amiq.vhdldt.ui.editor.ToggleCollapseLine";
    public static final String TOGGLE_EXPAND_SCOPE = "ro.amiq.vhdldt.ui.editor.ToggleExpandScope";
    public static final String SOURCE_SUBMENU = "ro.amiq.vhdldt.ui.editor.SourceSubMenu";
    public static final String ADD_TO_WAVE_VIEW = "ro.amiq.vhdldt.ui.editor.addToWaveView";
    public static final String ADD_PORTS_TO_WAVE_VIEW = "ro.amiq.vhdldt.ui.editor.addPortsToWaveView";
    public static final String ADD_ALL_SIGNALS_TO_WAVE_VIEW = "ro.amiq.vhdldt.ui.editor.addAllSignalsWaveView";
    public static final String ADD_DRIVERS_TO_WAVE_VIEW = "ro.amiq.vhdldt.ui.editor.AddDriversToWave";
    public static final String ADD_LOADS_TO_WAVE_VIEW = "ro.amiq.vhdldt.ui.editor.AddLoadsToWave";
    public static final String REVEAL_IN_WAVE_VIEW = "ro.amiq.vhdldt.ui.editor.RlInWaveView";
    public static final String SHOW_DIAGRAM = "ro.amiq.vhdldt.ui.editor.ShowDiagram";
    public static final String QUICK_OUTLINE = "ro.amiq.vhdldt.ui.editor.QuickOutline";
    public static final String OPEN_DECLARATION = "ro.amiq.vhdldt.ui.editor.OpenDeclaration";
    public static final String REFERENCES_IN_WORKSPACE = "ro.amiq.vhdldt.ui.editor.actions.ReferencesInWorkspace";
    public static final String REFERENCES_IN_PROJECT = "ro.amiq.vhdldt.ui.editor.actions.ReferencesInProject";
    public static final String REFERENCES_IN_FILE = "ro.amiq.vhdldt.ui.editor.actions.ReferencesInFile";
    public static final String REFERENCES_IN_WORKING_SET = "ro.amiq.vhdldt.ui.editor.actions.ReferencesInWorkingSet";
    public static final String REFERENCES_SUBMENU_COMMAND_ID = "ro.amiq.vhdldt.ui.editor.ReferencesSubMenu";
    public static final String REFACTOR_RENAME = "ro.amiq.vhdldt.ui.editor.actions.RefactorRename";
    public static final String REFACTOR_CONNECT_OUTPUT = "ro.amiq.vhdldt.ui.editor.actions.RefactorConnectOutput";
    public static final String REFACTOR_CONNECT_INPUT = "ro.amiq.vhdldt.ui.editor.actions.RefactorConnectInput";
    public static final String REFACTOR_RENAME_ACROSS_DESIGN_HIERARCHY = "ro.amiq.vhdldt.ui.editor.actions.RefactorRenameAcrossDesignHierarchy";
    public static final String REFACTOR_ADD_PORT = "ro.amiq.vhdldt.ui.editor.actions.RefactorAddPort";
    public static final String REFACTOR_ADD_GENERIC = "ro.amiq.vhdldt.ui.editor.actions.RefactorAddGeneric";
    public static final String REFACTOR_EXTRACT_TO_LOCAL_VARIABLE = "ro.amiq.vhdldt.ui.editor.actions.RefactorExtractToLocalVariable";
    public static final String REFACTOR_SUBMENU = "ro.amiq.vhdldt.ui.editor.RefactorSubMenu";
    public static final String SELECT_ENCLOSING_ELEMENT = "ro.amiq.vhdldt.ui.editor.SelectEnclosingElement";
    public static final String RESTORE_LAST_SELECTION = "ro.amiq.vhdldt.ui.editor.RestoreLastSelection";
    public static final String COPY_FULL_PATH = "ro.amiq.vhdldt.ui.editor.CopyFullPath";
    public static final String COPY_FILE_NAME = "ro.amiq.vhdldt.ui.editor.CopyFileName";
    public static final String SHOW_INSTANCES = "ro.amiq.dvt.ui.views.commands.ShowInstances";
    public static final String SHOW_INSTANCES_IN_DH = "ro.amiq.dvt.ui.views.commands.ShowInstancesInDH";
    private static final String COPY_HIERARCHY_PATH = "ro.amiq.vhdldt.ui.editor.CopyHierarchyPath";
    private VhdlLazyOutlinePage fOutlinePage;
    private ShowInstancesAction showInstancesAction;
    private ShowInstancesInDesignHierarchyViewAction showInstancesInDHAction;

    public VhdlEditor() {
        this.createEditorConfiguration();
    }

    protected void createEditorConfiguration() {
        super.createEditorConfiguration(this);
        VhdlPlugin.getDefault().getWorkbench().getDecoratorManager().addListener((ILabelProviderListener)this);
        this.setHelpContextId("ro.amiq.vhdldt.help.editor");
    }

    protected void initializeEditor() {
        this.setDocumentProvider((IDocumentProvider)new VhdlFileDocumentProvider());
        super.initializeEditor();
    }

    public void dispose() {
        try {
            try {
                ProjectionViewer viewer;
                VhdlSourceViewerConfiguration configuration = (VhdlSourceViewerConfiguration)this.getSourceViewerConfiguration();
                if (configuration != null) {
                    configuration.dispose();
                }
                if ((viewer = (ProjectionViewer)this.getSourceViewer()) != null) {
                    viewer.unconfigure();
                    viewer.setProjectionSummary(null);
                }
                DVTAutoIndentDetectionManager.INSTANCE.removeDetectedIndendationDocument(this.getDocument());
                this.disconnectFileFromDocument();
                TextEditorAction action = (TextEditorAction)this.getAction("ToggleMarkOccurrences");
                if (action != null) {
                    action.setEditor(null);
                }
                if ((action = (TextEditorAction)this.getAction("ToggleComment")) != null) {
                    action.setEditor(null);
                }
                if (this.fOutlinePage != null) {
                    this.fOutlinePage.dispose();
                    this.fOutlinePage = null;
                }
                RfUtils.clearCaches();
                this.disposeListeners();
                VhdlDocumentSetupParticipant setupParticipant = (VhdlDocumentSetupParticipant)((VhdlFileDocumentProvider)this.getDocumentProvider()).getDocumentSetupParticipant();
                setupParticipant.disconnect();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void disposeListeners() {
        VhdlPlugin.getDefault().getWorkbench().getDecoratorManager().removeListener((ILabelProviderListener)this);
        if (this.showInstancesAction != null) {
            DVTMixedLangModelManager.getInstance().removeBuildDoneListener((IBuildDoneListener)this.showInstancesAction);
        }
        super.disposeListeners();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setupEditorDropTarget();
    }

    private void setupEditorDropTarget() {
        final StyledText textWidget = this.getSourceViewer().getTextWidget();
        DropTarget dropTarget = (DropTarget)textWidget.getData("DropTarget");
        if (dropTarget == null) {
            dropTarget = new DropTarget((Control)textWidget, 1);
        }
        Transfer[] currentTransfers = dropTarget.getTransfer();
        int currentLength = currentTransfers.length;
        Transfer[] newTransfers = new Transfer[currentLength + 1];
        System.arraycopy(currentTransfers, 0, newTransfers, 0, currentLength);
        newTransfers[currentLength] = RfNamedElementTransfer.getInstance();
        dropTarget.setTransfer(newTransfers);
        dropTarget.addDropListener((DropTargetListener)new StyledTextDropTargetEffect(textWidget){

            public void dragEnter(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.detail = 1;
                event.feedback |= 9;
                super.dragEnter(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.detail = 1;
                event.feedback |= 9;
                super.dragOperationChanged(event);
            }

            public void dragOver(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.feedback |= 9;
                event.detail = 1;
                super.dragOver(event);
            }

            public void drop(DropTargetEvent event) {
                try {
                    VhdlContentAssistProcessorManager contentAssistProcessorManager = (VhdlContentAssistProcessorManager)((VhdlSourceViewerConfiguration)VhdlEditor.this.getSourceViewerConfiguration()).getSourceProcessorManager();
                    int caretOffset = textWidget.getCaretOffset();
                    IFile file = (IFile)VhdlEditor.this.getAdapter(IResource.class);
                    RfDefElement initialScope = VhdlEditor.this.getRfProject().getFile((IResource)file).getScope(caretOffset);
                    VhdlAutoInstanceContentAssistProcessor autoInstanceContentAssistProcessor = null;
                    ITextViewer textViewer = VhdlEditor.this.getTextViewer();
                    for (IContentAssistProcessor i : contentAssistProcessorManager.getProcessors()) {
                        if (!(i instanceof VhdlAutoInstanceContentAssistProcessor)) continue;
                        autoInstanceContentAssistProcessor = (VhdlAutoInstanceContentAssistProcessor)i;
                    }
                    if (RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType) && initialScope instanceof RfDefElement && autoInstanceContentAssistProcessor != null) {
                        IRfNamedElement namedElement = ((IRfNamedElement[])event.data)[0];
                        if (namedElement instanceof IRfDesignElement) {
                            IRfDesignElement payload = (IRfDesignElement)namedElement;
                            autoInstanceContentAssistProcessor.createProposal(textViewer, caretOffset, payload, false, initialScope, null).apply(VhdlEditor.this.getDocument());
                            VhdlEditor.this.getSite().getPage().activate((IWorkbenchPart)VhdlEditor.this);
                        } else {
                            MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)"Operation not supported", (String)("Drag and drop for '" + namedElement.getSignature() + "' is not supported."));
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return;
                }
            }
        });
    }

    public void configureProjectionSupport(ProjectionSupport projectionSupport) {
        projectionSupport.addSummarizableAnnotationType(VhdlProblemCategories.VHDL_SYNTAX.getMarkerId());
        projectionSupport.addSummarizableAnnotationType(VhdlProblemCategories.VHDL_NAME_CHECKING.getMarkerId());
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.bookmark");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.task");
        projectionSupport.addSummarizableAnnotationType("ro.amiq.dvt.ui.occurrences");
        projectionSupport.setHoverControlCreator(shell -> new DVTInformationControl(shell, (DefaultInformationControl.IInformationPresenter)new VhdlHoverSourceInformationPresenter()));
    }

    public void configureSourceViewerConfiguration(ProjectionAnnotationModel annotationModel) {
        VhdlSourceViewerConfiguration configuration = (VhdlSourceViewerConfiguration)this.getSourceViewerConfiguration();
        configuration.setProjectionAnnotationModel(annotationModel);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setMatchingCharacterPainterPreferenceKeys("matchingBracketsVhdlEnable", "matchingBracketsVhdlColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new VhdlLazyOutlinePage(this);
            }
            if (this.fOutlinePage.getEditor() == null) {
                this.fOutlinePage.setEditor(this);
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void doSaveAs() {
        try {
            super.doSaveAs();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        try {
            super.doSetInput(input);
            VhdlDocumentSetupParticipant setupParticipant = (VhdlDocumentSetupParticipant)((VhdlFileDocumentProvider)this.getDocumentProvider()).getDocumentSetupParticipant();
            IDocumentExtension3 extension3 = (IDocumentExtension3)this.getDocument();
            if (extension3.getDocumentPartitioner("__vhdl_partitioning") == null) {
                setupParticipant.setup(this.getDocument());
            }
            this.setPrefStore(VhdlPlugin.getDefault().getPreferenceStore());
            this.connectFileToDocument(false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Image getTitleImage() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        Image image = super.getTitleImage();
        try {
            if (file == null) {
                image = DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE_GRAY);
            } else {
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        image = DVTImages.imageCache.getImage(DVTImages.DESC_VHDL_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
                Image newImage = ProjectColorUtils.transformImage((ImageDescriptor)DVTImages.DESC_VHDL_MODULE_BLACK_TRANSPARENT, (String)file.getProject().getName());
                image = newImage == null ? image : newImage;
            }
            ILabelDecorator decorator = VhdlPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
            if (decorator != null) {
                return decorator.decorateImage(image, (Object)this);
            }
        }
        catch (Exception exception) {}
        return image;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
    }

    protected void createActions() {
        super.createActions();
        Object a = new DVTEditor.CollapseAllLevelsAction((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "CollapseAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(COLLAPSE_ALL_LEVELS);
        this.setAction("CollapseAllLevels", (IAction)a);
        a = new DVTEditor.ExpandAllLevelsAction((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "ExpandAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(EXPAND_ALL_LEVELS);
        this.setAction("ExpandAllLevels", (IAction)a);
        a = new DVTEditor.ShowFirstLevelAction((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "ExpandFirstLevel.", (ITextEditor)this);
        a.setActionDefinitionId(EXPAND_FIRST_LEVEL);
        this.setAction("ExpandFirstLevel", (IAction)a);
        a = new DVTEditor.DefineFoldingRegionAction((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "DefineFoldingRegion.", (ITextEditor)this);
        a.setActionDefinitionId(DEFINE_FOLDING_REGION);
        this.setAction("DefineFoldingRegion", (IAction)a);
        a = new DVTEditor.OpenHelpSearch((DVTEditor)this);
        a.setActionDefinitionId(OPEN_HELP_SEARCH);
        this.setAction("OpenHelpSearch", (IAction)a);
        a = new ToggleMarkOccurrencesAction(VhdlEditorMessages.getResourceBundle(), "ToggleMarkOccurrences.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_MARK_OCCURRENCES);
        this.setAction("ToggleMarkOccurrences", (IAction)a);
        this.getEditorSite().getActionBars().setGlobalActionHandler(TOGGLE_MARK_OCCURRENCES, (IAction)a);
        a = new DVTEditor.ForwardEndOfWord((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(FORWARD_END_OF_WORD);
        this.setAction("ForwardEndOfWord", (IAction)a);
        a = new DVTEditor.BackwardStartOfWord((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(BACKWARD_START_OF_WORD);
        this.setAction("BackwardStartOfWord", (IAction)a);
        a = new DVTEditor.SelectEnclosingElement((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(SELECT_ENCLOSING_ELEMENT);
        this.setAction("SelectEnclosingElement", (IAction)a);
        a = new DVTEditor.RestoreLastSelection((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(RESTORE_LAST_SELECTION);
        this.setAction("RestoreLastSelection", (IAction)a);
        a = new DVTEditor.GoToPairMatchingBeginEndBlockOrPairBracket((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "GoToPairBracket.", (ITextEditor)this);
        a.setActionDefinitionId(GOTO_PAIR_BRACKET);
        this.setAction("GoToPairBracket", (IAction)a);
        a = new DVTEditor.ToggleCollapseLineAction((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "ToggleCollapseLine.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_COLLAPSE_LINE);
        this.setAction("ToggleCollapseLine", (IAction)a);
        a = new DVTEditor.ToggleExpandScopeAction((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "ToggleExpandScope.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_EXPAND_SCOPE);
        this.setAction("ToggleExpandScope", (IAction)a);
        a = new DVTContentAssistAction(VhdlEditorMessages.getResourceBundle(), "ContentAssistProposal", (ITextEditor)this);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        a = new DVTTextOperationAction(TemplateMessages.getResourceBundle(), "Editor.template_proposals_action.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(TEMPLATE_PROPOSALS, (IAction)a);
        this.markAsStateDependentAction(TEMPLATE_PROPOSALS, true);
        a = new DVTEditor.FormatSourceAction((DVTEditor)this, VhdlEditorMessages.getResourceBundle(), "FormatSource.", (ITextEditor)this);
        a.setActionDefinitionId(FORMAT_SOURCE);
        this.setAction("FormatSource", (IAction)a);
        a = new ToggleCommentAction(VhdlEditorMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_COMMENT);
        this.setAction("ToggleComment", (IAction)a);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        a = new OpenDeclarationAction(VhdlEditorMessages.getResourceBundle(), "OpenDeclaration.", (ITextEditor)this);
        a.setActionDefinitionId(OPEN_DECLARATION);
        this.setAction("OpenDeclaration", (IAction)a);
        a = new VhdlAddSignalToWaveViewTextEditorHandler(VhdlEditorMessages.getResourceBundle(), "AddToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_TO_WAVE_VIEW);
        this.setAction("AddToWave", (IAction)a);
        a = new VhdlAddPortsInDVTWaveViewEditorActionHandler(VhdlEditorMessages.getResourceBundle(), "AddPortsToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_PORTS_TO_WAVE_VIEW);
        this.setAction("AddPortsToWave", (IAction)a);
        a = new VhdlAddAllSignalsInDVTWaveViewEditorActionHandler(VhdlEditorMessages.getResourceBundle(), "AddAllSignalsToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_ALL_SIGNALS_TO_WAVE_VIEW);
        this.setAction("AddAllSignalsToWave", (IAction)a);
        a = new VhdlAddDriversToWaveViewTextEditorActionHandler(VhdlEditorMessages.getResourceBundle(), "AddDriversToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_DRIVERS_TO_WAVE_VIEW);
        this.setAction("AddDriversToWave", (IAction)a);
        a = new VhdlAddLoadsToWaveViewTextEditorActionHandler(VhdlEditorMessages.getResourceBundle(), "AddLoadsToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_LOADS_TO_WAVE_VIEW);
        this.setAction("AddLoadsToWave", (IAction)a);
        a = new VhdlRevealInDVTWaveViewEditorAction(VhdlEditorMessages.getResourceBundle(), "RevealInWaveView.", (ITextEditor)this);
        a.setActionDefinitionId(REVEAL_IN_WAVE_VIEW);
        this.setAction("RevealInWaveView", (IAction)a);
        a = new ShowDiagramAction(VhdlEditorMessages.getResourceBundle(), "ShowDiagram.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_DIAGRAM);
        this.setAction("ShowDiagram", (IAction)a);
        a = new ReferencesInWorkspaceAction(VhdlEditorMessages.getResourceBundle(), "ReferencesInWorkspace.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_WORKSPACE);
        this.setAction("ReferencesInWorkspace", (IAction)a);
        a = new ReferencesInProjectAction(VhdlEditorMessages.getResourceBundle(), "ReferencesInProject.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_PROJECT);
        this.setAction("ReferencesInProject", (IAction)a);
        a = new ReferencesInFileAction(VhdlEditorMessages.getResourceBundle(), "ReferencesInFile.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_FILE);
        this.setAction("ReferencesInFile", (IAction)a);
        a = new ShowReadersUsagesAction(VhdlEditorMessages.getResourceBundle(), "ShowReadersUsages.", (ITextEditor)this);
        a.setActionDefinitionId("ro.amiq.dvt.ui.views.commands.ShowReaders");
        this.setAction("ShowReadersUsages", (IAction)a);
        a = new ShowWritersUsagesAction(VhdlEditorMessages.getResourceBundle(), "ShowWritersUsages.", (ITextEditor)this);
        a.setActionDefinitionId("ro.amiq.dvt.ui.views.commands.ShowWriters");
        this.setAction("ShowWritersUsages", (IAction)a);
        a = new ReferencesInProjectAction(VhdlEditorMessages.getResourceBundle(), "Usages.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_PROJECT);
        this.setAction("Usages", (IAction)a);
        this.showInstancesAction = new ShowInstancesAction(VhdlEditorMessages.getResourceBundle(), "ShowInstances.", (ITextEditor)this);
        this.showInstancesAction.setActionDefinitionId(SHOW_INSTANCES);
        this.setAction("ShowInstances", (IAction)this.showInstancesAction);
        this.showInstancesInDHAction = new ShowInstancesInDesignHierarchyViewAction(VhdlEditorMessages.getResourceBundle(), "ShowInstancesInDH.", (ITextEditor)this);
        this.showInstancesInDHAction.setActionDefinitionId(SHOW_INSTANCES_IN_DH);
        this.setAction("ShowInstancesInDH", (IAction)this.showInstancesInDHAction);
        a = new ReferencesInWorkingSetAction(VhdlEditorMessages.getResourceBundle(), "ReferencesInWorkingSet.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_WORKING_SET);
        this.setAction("ReferencesInWorkingSet", (IAction)a);
        a = new VhdlRenameRefactorAction(VhdlEditorMessages.getResourceBundle(), "RefactorRename.", this);
        a.setActionDefinitionId(REFACTOR_RENAME);
        this.setAction("RefactorRename", (IAction)a);
        a = new VhdlRefactorConnectOutputAction(VhdlEditorMessages.getResourceBundle(), "RefactorConnectOutput.", this);
        a.setActionDefinitionId(REFACTOR_CONNECT_OUTPUT);
        this.setAction("RefactorConnectOutput", (IAction)a);
        a = new VhdlRefactorConnectInputAction(VhdlEditorMessages.getResourceBundle(), "RefactorConnectInput.", this);
        a.setActionDefinitionId(REFACTOR_CONNECT_INPUT);
        this.setAction("RefactorConnectInput", (IAction)a);
        a = new VhdlRenameAcrossDesignHierarchyRefactorAction(VhdlEditorMessages.getResourceBundle(), "RefactorRenameAcrossDesignHierarchy.", this);
        a.setActionDefinitionId(REFACTOR_RENAME_ACROSS_DESIGN_HIERARCHY);
        this.setAction("RefactorRenameAcrossDesignHierarchy", (IAction)a);
        a = new VhdlRefactorAddPortAction(VhdlEditorMessages.getResourceBundle(), "RefactorAddPort.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_ADD_PORT);
        this.setAction("RefactorAddPort", (IAction)a);
        a = new VhdlRefactorAddGenericAction(VhdlEditorMessages.getResourceBundle(), "RefactorAddGeneric.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_ADD_GENERIC);
        this.setAction("RefactorAddGeneric", (IAction)a);
        a = new VhdlRefactorExtractToVariableAction(VhdlEditorMessages.getResourceBundle(), "RefactorExtractToLocalVariable.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_EXTRACT_TO_LOCAL_VARIABLE);
        this.setAction("RefactorExtractToLocalVariable", (IAction)a);
        a = new CopyFileInfoAction(VhdlEditorMessages.getResourceBundle(), "CopyFullPath.", (ITextEditor)this, CopyFileInfoKind.COPY_FULL_PATH);
        a.setActionDefinitionId(COPY_FULL_PATH);
        this.setAction("CopyFullPath", (IAction)a);
        a = new CopyFileInfoAction(VhdlEditorMessages.getResourceBundle(), "CopyFileName.", (ITextEditor)this, CopyFileInfoKind.COPY_FILE_NAME);
        a.setActionDefinitionId(COPY_FILE_NAME);
        this.setAction("CopyFileName", (IAction)a);
        a = new CopyHierarchyPathAction(VhdlEditorMessages.getResourceBundle(), "CopyHierarchyPath.", (ITextEditor)this);
        a.setActionDefinitionId(COPY_HIERARCHY_PATH);
        this.setAction("CopyHierarchyPath", (IAction)a);
    }

    private String getSourceMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(SOURCE_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)VhdlEditorMessages.getString("SourceSubmenu.label"), (Object)keyBinding);
    }

    private String getReferencesMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(REFERENCES_SUBMENU_COMMAND_ID);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)VhdlEditorMessages.getString("ReferencesSubmenu.label"), (Object)keyBinding);
    }

    private String getRefactorMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(REFACTOR_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)VhdlEditorMessages.getString("RefactorSubMenu.label"), (Object)keyBinding);
    }

    protected void addSourceSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "QuickAssist");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "GoToPairBracket");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "FormatSource");
        this.addAction(menu, "ToggleComment");
    }

    protected void addReferencesSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "ReferencesInWorkspace");
        this.addAction(menu, "ReferencesInProject");
        this.addAction(menu, "ReferencesInFile");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "ReferencesInWorkingSet");
    }

    protected void addRefactorSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "RefactorRename");
        this.addAction(menu, "RefactorRenameAcrossDesignHierarchy");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorAddPort");
        this.addAction(menu, "RefactorAddGeneric");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorExtractToLocalVariable");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorConnectOutput");
        this.addAction(menu, "RefactorConnectInput");
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        MenuManager submenu = new MenuManager("Edit", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.CUT);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.COPY);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.PASTE);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.UNDO);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.REDO);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "CopyFileName");
        this.addAction((IMenuManager)submenu, "CopyFullPath");
        this.addAction((IMenuManager)submenu, "CopyHierarchyPath");
        submenu.add((IContributionItem)new Separator());
        submenu.add((IContributionItem)new EditorEmulationContributionItem(new EditorEmulationAction(false)));
        submenu = new MenuManager("Folding", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "CollapseAllLevels");
        this.addAction((IMenuManager)submenu, "ShowActivePreprocessing");
        this.addAction((IMenuManager)submenu, "ExpandFirstLevel");
        this.addAction((IMenuManager)submenu, "ExpandAllLevels");
        this.addAction((IMenuManager)submenu, "ToggleExpandScope");
        this.addAction((IMenuManager)submenu, "ToggleCollapseLine");
        this.addAction((IMenuManager)submenu, "DefineFoldingRegion");
        this.addWaveSubmenuItems(menu);
        submenu = new MenuManager(this.getSourceMenuLabel(), null, null);
        menu.add((IContributionItem)submenu);
        this.addSourceSubmenuItems((IMenuManager)submenu);
        submenu = new MenuManager("Show", null, "ro.amiq.dvt.ui.editor.menu.show");
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "OpenDeclaration");
        submenu.add((IContributionItem)new Separator());
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group1"));
        this.addAction((IMenuManager)submenu, "ShowDiagram");
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group2"));
        this.addAction((IMenuManager)submenu, "QuickOutline");
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group3"));
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "ShowInstances");
        this.addAction((IMenuManager)submenu, "Usages");
        this.addAction((IMenuManager)submenu, "ShowReadersUsages");
        this.addAction((IMenuManager)submenu, "ShowWritersUsages");
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "ShowInstancesInDH");
        menu.add((IContributionItem)new Separator());
        submenu = new MenuManager(this.getReferencesMenuLabel(), null, "ro.amiq.dvt.ui.editor.ReferencesSubMenu");
        menu.add((IContributionItem)submenu);
        this.addReferencesSubmenuItems((IMenuManager)submenu);
        submenu = new MenuManager(this.getRefactorMenuLabel());
        menu.add((IContributionItem)submenu);
        this.addRefactorSubmenuItems((IMenuManager)submenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("ro.amiq.dvt.ui.editor.menu.debug"));
    }

    private void addWaveSubmenuItems(IMenuManager menu) {
        MenuManager subsubmenu = new MenuManager("Waveform Viewer", null);
        menu.add((IContributionItem)subsubmenu);
        this.addAction((IMenuManager)subsubmenu, "AddToWave");
        menu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)subsubmenu, "AddPortsToWave");
        this.addAction((IMenuManager)subsubmenu, "AddAllSignalsToWave");
        menu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)subsubmenu, "AddDriversToWave");
        this.addAction((IMenuManager)subsubmenu, "AddLoadsToWave");
        this.addAction((IMenuManager)subsubmenu, "RevealInWaveView");
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"ro.amiq.vhdldt.vhdlEditorScope", "ro.amiq.dvt.ui.vlogVhdlEditorScope", "ro.amiq.dvt.ui.trace.connections.actions.context"});
    }

    public void setFocus() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        if (styledText.isFocusControl()) {
            return;
        }
        super.setFocus();
        if (this.fPropertyChangedEvent) {
            sourceViewer.invalidateTextPresentation();
            this.fPropertyChangedEvent = false;
        }
        VhdlQuickViewersUtil.getInstance().scheduleReparseIfNonTop((ITextEditor)this);
        this.connectFileToDocument(true);
        this.switchPerspective();
        this.detectIndentation();
    }

    private void switchPerspective() {
        try {
            boolean disableSwitchPerspective = DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.DISABLE_SWITCH_PERSPECTIVE");
            if (disableSwitchPerspective) {
                return;
            }
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IWorkbenchPage activePage = DVTPlugin.getActivePage();
            if (activePage == null) {
                return;
            }
            IPerspectiveDescriptor perspective = activePage.getPerspective();
            if (perspective == null) {
                return;
            }
            if (perspective.getId().equals("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective")) {
                return;
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && (perspective.getId().equals("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective") || perspective.getId().equals("ro.amiq.edt.ui.perspectives.EDTPerspective"))) {
                PlatformUI.getWorkbench().showPerspective("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void connectFileToDocument(boolean connectPositionsAfterEditorFocus) {
        try {
            IProject project = this.getProject();
            if (project == null) {
                DVTHlUtils.startHighlight(null, (DVTEditor)this, (DVTSemanticHighlighter)new VhdlSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)VhdlPlugin.getDefault(), (String)"highlight.semantic");
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            IDocument document = this.getDocument();
            if (document == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            if (rfProject != null) {
                rfProject.connectFileToDocument(parserPath, this, connectPositionsAfterEditorFocus);
            } else {
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            }
            DVTHlUtils.startHighlight((IRfFileDef)(rfProject != null ? rfProject.getFileDefUsingParserPath(parserPath) : null), (DVTEditor)this, (DVTSemanticHighlighter)new VhdlSemanticHighlighter(document), (AbstractUIPlugin)VhdlPlugin.getDefault(), (String)"highlight.semantic");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyListeners(int eventType, Event event) {
        this.getSourceViewer().getTextWidget().notifyListeners(eventType, event);
    }

    public ISourceViewer testGetSourceViewer() {
        return this.getSourceViewer();
    }

    public VhdlSourceViewerConfiguration testGetSourceViewerConfiguration() {
        return (VhdlSourceViewerConfiguration)this.getSourceViewerConfiguration();
    }

    public IHyperlinkDetector testGetRfHyperlinkDetector() {
        IHyperlinkDetector[] detectors = this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
        int i = 0;
        while (i < detectors.length) {
            if (detectors[i] instanceof RfHyperlinkDetector) {
                return detectors[i];
            }
            ++i;
        }
        return null;
    }

    public IHyperlinkDetector[] testGetAllHyperlinkDetectors() {
        return this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
    }

    public int testGetCurrentLine() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText styledText = sourceViewer.getTextWidget();
        return styledText.getLineAtOffset(styledText.getCaretOffset());
    }

    public TextEditorAction testGetReferencesInWorkspaceAction() {
        return new ReferencesInWorkspaceAction(VhdlEditorMessages.getResourceBundle(), "ReferencesInWorkspace.", (ITextEditor)this);
    }

    public TextEditorAction testGetReferencesInFileAction() {
        return new ReferencesInFileAction(VhdlEditorMessages.getResourceBundle(), "ReferencesInFile.", (ITextEditor)this);
    }

    public IRfNamedElement testGetNamedElementAtPosition(int line, int column) {
        IRfNamedElementAndScope testGetNamedElementAtPosition = this.testGetNamedElementAndScopeAtPosition(line, column);
        if (testGetNamedElementAtPosition == null) {
            return null;
        }
        IRfNamedElement namedElement = testGetNamedElementAtPosition.getIRfNamedElement();
        if (namedElement instanceof RfComponent) {
            namedElement = ((RfComponent)namedElement).getResolvedElement();
        }
        return namedElement;
    }

    public IRfNamedElementAndScope testGetNamedElementAndScopeAtPosition(int line, int column) {
        IDocument document;
        block3: {
            try {
                document = this.getDocument();
                if (document != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        int offset = document.getLineOffset(line) + column;
        return RfUtils.getRfElement((ITextEditor)this, document, offset);
    }

    public IRfScopeElement getCursorScope() {
        return RfGUIEnclosingScopeUtils.getScope((ITextEditor)this, this.getCursor());
    }

    public IRfNamedElement getCursorScopeForBreadcrumb(boolean overrideCache) {
        IRfBreadcrumbElement scopeForBreadcrumb = ((ScopeBreadcrumbUtils)this.getBreadcrumbUtils(ScopeBreadcrumbViewer.class)).getScopeForBreadcrumb((ITextEditor)this, this.getCursor(), overrideCache);
        if (scopeForBreadcrumb instanceof RfDefElement) {
            return ((RfDefElement)scopeForBreadcrumb).getNamedElement();
        }
        return (IRfNamedElement)scopeForBreadcrumb;
    }

    protected IPreferenceStore getPluginSpecificPreferenceStore() {
        return VhdlPlugin.getDefault().getPreferenceStore();
    }

    public IBaseShowConstraintsAction testGetShowConstraintsAction() {
        return null;
    }

    public IBaseShowEmittersAction testGetShowEmittersAction() {
        return null;
    }

    public void showContentAssistProposalsForCreatedFile() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((VhdlSourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            ((VhdlSourceViewerConfiguration)this.getSourceViewerConfiguration()).getSourceProcessorManager().showContentAssistPage(IDVTContentAssistConstants.ContentAssistProposalsPage.TEMPLATES.getCode());
            contAss.showPossibleCompletions();
        });
    }

    public void showAIAssistantProposals() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((VhdlSourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            ((VhdlSourceViewerConfiguration)this.getSourceViewerConfiguration()).getSourceProcessorManager().showContentAssistPage(IDVTContentAssistConstants.ContentAssistProposalsPage.AI_ASSISTANT.getCode());
            contAss.showPossibleCompletions();
        });
    }

    public boolean isHoverDisabled() {
        return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_tool_tips");
    }

    public void installSubmenuActions() {
        this.fHandlerService = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            IHandler handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    VhdlEditor.this.addSourceSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(SOURCE_SUBMENU, this.fHandlerService.activateHandler(SOURCE_SUBMENU, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    VhdlEditor.this.addReferencesSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(REFERENCES_SUBMENU_COMMAND_ID, this.fHandlerService.activateHandler(REFERENCES_SUBMENU_COMMAND_ID, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    VhdlEditor.this.addRefactorSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(REFACTOR_SUBMENU, this.fHandlerService.activateHandler(REFACTOR_SUBMENU, handler));
        }
    }

    public AbstractBreadcrumbUtils getBreadcrumbUtils(Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            return VHDLDHBreadcrumbUtils.getInstance();
        }
        if (breadcrumbType == ScopeBreadcrumbViewer.class) {
            return VHDLScopeBreadcrumbUtils.getInstance();
        }
        if (breadcrumbType == FSBreadcrumbViewer.class) {
            return FSBreadcrumbUtils.getInstance();
        }
        return null;
    }

    public IBaseShowInstancesAction testGetShowInstancesAction() {
        return new ShowInstancesAction(VhdlEditorMessages.getResourceBundle(), "ShowInstances.", (ITextEditor)this);
    }

    public CopyHierarchyPathAction testHelpCopyHierarchyWirePathAction() {
        return new CopyHierarchyPathAction(VhdlEditorMessages.getResourceBundle(), "ShowConstraints.", (ITextEditor)this);
    }

    public IReferencesAction testGetShowReadersUsagesAction() {
        return new ShowReadersUsagesAction(VhdlEditorMessages.getResourceBundle(), "ShowReadersUsages.", (ITextEditor)this);
    }

    public IReferencesAction testGetShowWritersUsagesAction() {
        return new ShowWritersUsagesAction(VhdlEditorMessages.getResourceBundle(), "ShowWritersUsages.", (ITextEditor)this);
    }

    public void recomputeHighlightPositionsAndInvalidateEditor() {
        IProject project = this.getProject();
        if (project == null) {
            DVTHlUtils.startHighlight(null, (DVTEditor)this, (DVTSemanticHighlighter)new VhdlSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)VhdlPlugin.getDefault(), (String)"highlight.semantic");
            ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            return;
        }
        IFile file = (IFile)this.getAdapter(IResource.class);
        if (file == null) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            return;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            return;
        }
        DVTHlUtils.startHighlight((IRfFileDef)rfProject.getFileDefUsingParserPath(parserPath), (DVTEditor)this, (DVTSemanticHighlighter)new VhdlSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)VhdlPlugin.getDefault(), (String)"highlight.semantic");
    }

    @Override
    public IDesignPathProvider getDesignPathProvider() {
        return VhdlDesignPathProvider.getInstance();
    }

    public QuickLazyOutlineView createQuickOutlineView() {
        return new VhdlQuickLazyOutlineView(this);
    }

    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
        this.updateBreadcrumb(marker);
    }

    public DVTLazyOutlinePage getOutlinePage() {
        return this.fOutlinePage;
    }
}

