/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPairMatcher;
import ro.amiq.dvt.ui.editor.DVTPairMatcherAccessor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.model.IVhdlModule;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.VhdlPairMatcherAccessor;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.VhdlWordFinder;
import ro.amiq.vhdldt.ui.editor.pathmanager.VhdlDesignPathProvider;

public abstract class VhdlEditorCommon
extends DVTEditor {
    public static final String ID = "ro.amiq.vhdldt.ui.editor.VhdlEditor";

    protected VhdlEditorCommon() {
    }

    protected VhdlEditorCommon(IDocument document) {
        super(document);
    }

    protected void createEditorConfiguration(VhdlEditor editor) {
        VhdlSourceViewerConfiguration configuration = new VhdlSourceViewerConfiguration(editor);
        configuration.setBracketMatcher((ICharacterPairMatcher)DVTPairMatcher.makePairMatcher((LanguageKind)LanguageKind.VHDL, (char[])BRACKETS, (DVTPairMatcherAccessor)new VhdlPairMatcherAccessor()));
        this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            super.doSave(monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfProject getRfProject() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return RfManager.getInstance().getRfProject(project);
    }

    protected void disconnectFileFromDocument() {
        try {
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return;
            }
            rfProject.disconnectFileFromDocument(parserPath);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void scheduleReparse(IDocument document, IFile file) {
        IVhdlModule module = VhdlModelManager.getInstance().getVhdlModel().getOrCreateVhdlFile(file);
        if (module == null) {
            return;
        }
        boolean shouldIncrementalBuild = DVTFileUtils.getInstance().shouldIncrementalBuild(this.getDocument(), null, this.getProject());
        if (shouldIncrementalBuild) {
            int buildAutoTime = DVTPlugin.getDefault().getPreferenceStore().getInt("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE");
            module.scheduleReparse(false, false, (long)buildAutoTime * 1000L, document, false);
        }
    }

    public DVTWordFinder getWordFinder() {
        return VhdlWordFinder.getDefault();
    }

    protected boolean c() {
        return DVTPlugin.getDefault().collect().c(this.getProject(), "F7668646C");
    }

    public IRfNamedElementAndScope getCursorElement() {
        return this.getCursorElementNonUi(this.getCursor());
    }

    public IRfNamedElementAndScope getCursorElementNonUi(int cursor) {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement((ITextEditor)this, this.getDocument(), cursor);
        return namedElementAndScope;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public DVTSourceViewerConfiguration makeSourceViewerConfiguration() {
        return new VhdlSourceViewerConfiguration(null);
    }

    public IDesignPathProvider getDesignPathProvider() {
        return VhdlDesignPathProvider.getInstance();
    }

    public String getEditorID() {
        return ID;
    }

    public String getCodePartition() {
        return "__vhdl_partitioning";
    }
}

